/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import softcore.tac.Tac;
import softcore.util.Constants;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;

public class JdbcUpdateRecord {
    public final Connection connection;
    public final String tableName;
    PreparedStatement updateStatement;
    PreparedStatement insertStatement;
    PreparedStatement deleteStatement;
    PreparedStatement countStatement;
    PreparedStatement selectStatement;
    public String updateSql;
    public String insertSql;
    public String deleteSql;
    public String countSql;
    public String selectSql;
    String[] columnsName;
    public int[] columnsSqlType;
    int[] columnsScale;
    int[] columnsFlag;
    boolean notInsertNullRecord;
    boolean useSetStreamForStreams;
    int doneFlags;
    public boolean nonInsert;
    public boolean forceInsert;
    public boolean doInsertCaseCount;
    public boolean forceInsertCaseCount;

    public void setNotInsertNullRecord(boolean flag) {
        this.notInsertNullRecord = flag;
    }

    public void close() {
        try {
            this.updateStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatement = null;
        try {
            this.insertStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertStatement = null;
        try {
            this.deleteStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deleteStatement = null;
        try {
            this.countStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.countStatement = null;
        try {
            this.selectStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectStatement = null;
        JDBC.notifyServerTableUpdated(this.tableName);
    }

    protected void finalize() throws Throwable {
        if (this.updateStatement != null || this.insertStatement != null || this.deleteStatement != null || this.countStatement != null || this.selectStatement != null) {
            System.err.println("JdbcUpdateRecord not closed.");
        }
        this.close();
        super.finalize();
    }

    public JdbcUpdateRecord(Connection connection1, String s) {
        if (connection1 == null) {
            connection1 = JDBC.getDefaultJdbcConnection();
        }
        try {
            this.useSetStreamForStreams = connection1 != null && connection1.getMetaData().getDatabaseProductName().indexOf("Oracle") >= 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.connection = connection1;
        this.tableName = s;
    }

    public JdbcUpdateRecord(String s) {
        this(null, s);
    }

    public String getTableName() {
        return this.tableName;
    }

    private String buildWhere() {
        String s = null;
        int i = 0;
        while (i < this.columnsName.length) {
            if ((this.columnsFlag[i] & 1) != 0) {
                s = s == null ? " where " + this.columnsName[i] + "=?" : String.valueOf(s) + " and " + this.columnsName[i] + "=?";
            }
            ++i;
        }
        return s;
    }

    public void setDoneFlags(int i) {
        this.doneFlags = i;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initJdbcStatement(int i) throws SQLException {
        i &= ~this.doneFlags;
        boolean flag = false;
        if (this.columnsName == null) {
            String s = "select fldname,fldtype,flddecimal,fldflags from tbldef,flddef where tbldef.tblid=flddef.tblid and tbldef.tblname='" + this.tableName + "'";
            Object[][] aobj = JDBC.sqlSelect3(this.connection, s);
            if (aobj == null) {
                return false;
            }
            int k = 0;
            int j1 = 0;
            while (true) {
                int k1;
                if (j1 >= aobj.length) break;
                int n = k1 = aobj[j1][3] instanceof Number ? ((Number)aobj[j1][3]).intValue() : 0;
                if ((k1 & 4) == 0) {
                    ++k;
                }
                ++j1;
            }
            this.columnsName = new String[k];
            this.columnsSqlType = new int[k];
            this.columnsScale = new int[k];
            this.columnsFlag = new int[k];
            int l1 = 0;
            int i2 = 0;
            while (true) {
                int k2;
                if (i2 >= aobj.length) {
                    flag = true;
                    break;
                }
                int n = k2 = aobj[i2][3] instanceof Number ? ((Number)aobj[i2][3]).intValue() : 0;
                if ((k2 & 4) == 0) {
                    String s8 = ((String)aobj[i2][0]).toLowerCase();
                    int j3 = ((Number)aobj[i2][1]).intValue();
                    int k3 = aobj[i2][2] instanceof Number ? ((Number)aobj[i2][2]).intValue() : 0;
                    this.columnsName[l1] = s8;
                    this.columnsSqlType[l1] = j3;
                    this.columnsScale[l1] = k3;
                    this.columnsFlag[l1] = k2 & 3;
                    ++l1;
                }
                ++i2;
            }
        }
        if (this.columnsSqlType == null || flag) {
            if (this.columnsSqlType == null) {
                this.columnsSqlType = new int[this.columnsName.length];
            }
            DatabaseMetaData databasemetadata = this.connection.getMetaData();
            boolean flag1 = false;
            try {
                flag1 = databasemetadata.storesUpperCaseIdentifiers();
            }
            catch (Exception exception) {
                Message.out.println(exception);
            }
            String s6 = null;
            if (databasemetadata.getDatabaseProductName().indexOf("Oracle") >= 0) {
                s6 = databasemetadata.getUserName().toUpperCase();
            }
            ResultSet resultset = databasemetadata.getColumns(null, s6, flag1 ? this.tableName.toUpperCase() : this.tableName, null);
            try {
                int j2;
                boolean[] aflag = new boolean[this.columnsSqlType.length];
                block7: while (true) {
                    if (!resultset.next()) {
                        j2 = 0;
                        break;
                    }
                    String s7 = resultset.getString(4);
                    int l2 = resultset.getInt(5);
                    int i3 = 0;
                    while (true) {
                        if (i3 >= this.columnsName.length) continue block7;
                        if (this.columnsName[i3].equalsIgnoreCase(s7)) {
                            this.columnsSqlType[i3] = (short)l2;
                            aflag[i3] = true;
                        }
                        ++i3;
                    }
                    break;
                }
                while (j2 < aflag.length) {
                    if (!aflag[j2]) {
                        Message.out.println("\u5b57\u6bb5 " + this.columnsName[j2] + ": \u4e0d\u662f\u8868" + this.tableName + "\u7684\u5217.");
                    }
                    ++j2;
                }
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                resultset.close();
                throw throwable;
            }
            {
                Object var11_21 = null;
            }
            resultset.close();
        }
        if (this.updateStatement == null && (i & 1) != 0) {
            String s1 = null;
            String s4 = null;
            int l = 0;
            while (true) {
                if (l >= this.columnsName.length) {
                    if (s1 != null && s4 != null) {
                        this.updateSql = "update " + this.tableName + s1 + s4;
                        this.updateStatement = this.connection.prepareStatement(this.updateSql);
                    }
                    this.doneFlags |= 1;
                    break;
                }
                if ((this.columnsFlag[l] & 1) != 0) {
                    s4 = s4 == null ? " where " + this.columnsName[l] + "=?" : String.valueOf(s4) + " and " + this.columnsName[l] + "=?";
                } else if ((this.columnsFlag[l] & 0x100) == 0) {
                    s1 = s1 == null ? " set " + this.columnsName[l] + "=?" : String.valueOf(s1) + "," + this.columnsName[l] + "=?";
                }
                ++l;
            }
        }
        if (this.insertStatement == null && (i & 2) != 0) {
            String s2 = "";
            String s5 = "";
            int i1 = 0;
            while (true) {
                if (i1 >= this.columnsName.length) {
                    this.insertSql = "insert into " + this.tableName + "(" + s2 + ") values (" + s5 + ")";
                    this.insertStatement = this.connection.prepareStatement(this.insertSql);
                    this.doneFlags |= 2;
                    break;
                }
                if (i1 > 0) {
                    s2 = String.valueOf(s2) + ',';
                    s5 = String.valueOf(s5) + ',';
                }
                s2 = String.valueOf(s2) + this.columnsName[i1];
                s5 = String.valueOf(s5) + '?';
                ++i1;
            }
        }
        if (this.deleteStatement == null && (i & 4) != 0) {
            this.deleteSql = "delete from " + this.tableName + this.buildWhere();
            if (MainApp.isDebug) {
                System.out.println(this.deleteSql);
            }
            this.deleteStatement = this.connection.prepareStatement(this.deleteSql);
            this.doneFlags |= 4;
        }
        if (this.countStatement == null && (i & 8) != 0) {
            this.countSql = "select count(*) from " + this.tableName + this.buildWhere();
            this.countStatement = this.connection.prepareStatement(this.countSql);
            this.doneFlags |= 8;
        }
        if (this.selectStatement != null || (i & 0x10) == 0) return true;
        String s3 = null;
        int j = 0;
        while (true) {
            if (j >= this.columnsName.length) {
                if (s3 != null) {
                    this.selectSql = String.valueOf(s3) + " from " + this.tableName + this.buildWhere();
                    this.selectStatement = this.connection.prepareStatement(this.selectSql);
                }
                this.doneFlags |= 0x10;
                return true;
            }
            if ((this.columnsFlag[j] & 1) == 0) {
                s3 = s3 == null ? " select " + this.columnsName[j] : String.valueOf(s3) + "," + this.columnsName[j];
            }
            ++j;
        }
    }

    public void setColumns(String[] as, String[] as1, String[] as2) {
        int i = as.length + as1.length + (as2 != null ? as2.length : 0);
        this.columnsName = new String[i];
        this.columnsFlag = new int[i];
        int j = 0;
        int k = 0;
        while (k < as.length) {
            this.columnsName[j + k] = as[k].toLowerCase();
            this.columnsFlag[j + k] = 3;
            ++k;
        }
        j = as.length;
        int l = 0;
        while (l < as1.length) {
            this.columnsName[j + l] = as1[l].toLowerCase();
            ++l;
        }
        j += as1.length;
        if (as2 != null) {
            int i1 = 0;
            while (i1 < as2.length) {
                this.columnsName[j + i1] = as2[i1].toLowerCase();
                int n = j + i1;
                this.columnsFlag[n] = this.columnsFlag[n] | 0x100;
                ++i1;
            }
        }
    }

    public void setColumns(String[] as, int[] ai) {
        this.columnsName = as;
        this.columnsFlag = ai;
    }

    public void clearNonPrimaryColumnValue(Hashtable hashtable) {
        if (hashtable == null || this.columnsName == null) {
            return;
        }
        int i = 0;
        while (i < this.columnsName.length) {
            if ((this.columnsFlag[i] & 1) == 0) {
                hashtable.remove(this.columnsName[i]);
            }
            ++i;
        }
    }

    public void setNonInsert(boolean flag) {
        this.nonInsert = flag;
    }

    public void setForceInsert(boolean flag) {
        this.forceInsert = flag;
    }

    public void setDoInsertCaseCount(boolean flag) {
        this.doInsertCaseCount = flag;
    }

    protected void setPreparedStatementParameter(PreparedStatement preparedstatement, int i, Object obj, int j, int k) throws SQLException {
        if (obj == null) {
            preparedstatement.setNull(i, j);
        } else {
            int l = j == 5 || j == -6 ? 4 : j;
            if (obj instanceof String) {
                if (j == -1) {
                    try {
                        preparedstatement.setCharacterStream(i, (Reader)new StringReader((String)obj), ((String)obj).length());
                        return;
                    }
                    catch (Throwable throwable) {}
                } else if (l != 12) {
                    obj = Utilities.parseStringFromSqlType((String)obj, l);
                }
            }
            obj = Utilities.toCompatibleSqlObject(obj, l, this.columnsScale != null ? this.columnsScale[k] : 0);
            try {
                if (l == -4 && obj instanceof byte[] && this.useSetStreamForStreams) {
                    byte[] abyte0 = (byte[])obj;
                    preparedstatement.setBinaryStream(i, (InputStream)new ByteArrayInputStream(abyte0), abyte0.length);
                } else {
                    preparedstatement.setObject(i, obj, j);
                }
            }
            catch (SQLException sqlexception) {
                System.out.println("setObject:column " + i + "(" + this.columnsName[k] + "),value=" + obj + "," + (obj != null ? obj.getClass() : null) + ",sqlType=" + j);
                throw sqlexception;
            }
        }
    }

    public int updateRecord(Hashtable hashtable) throws SQLException {
        return this.updateRecord(hashtable, false);
    }

    public int updateRecord(Hashtable hashtable, boolean flag) throws SQLException {
        return this.updateRecord(hashtable, null, flag);
    }

    private void setUpdateStmtParams(Hashtable hashtable) throws SQLException {
        this.updateStatement.clearParameters();
        int i = 1;
        int j = 0;
        while (j <= 1) {
            int k = 0;
            while (k < this.columnsName.length) {
                if ((this.columnsFlag[k] & 1) == j && (this.columnsFlag[k] & 0x100) == 0) {
                    int l;
                    Object obj = hashtable.get(this.columnsName[k]);
                    int n = l = this.columnsSqlType != null ? this.columnsSqlType[k] : 0;
                    if (obj == null && l != 0 && (this.columnsFlag[k] & 2) != 0 && (obj = Utilities.defaultSqlObject(l)) instanceof String) {
                        obj = " ";
                    }
                    this.setPreparedStatementParameter(this.updateStatement, i++, obj, l, k);
                }
                ++k;
            }
            ++j;
        }
    }

    public int updateRecordcopy(Hashtable hashtable, Hashtable hashtable1, boolean flag, int copymode) throws SQLException {
        int n;
        block37: {
            block29: {
                int n2;
                block36: {
                    int l;
                    block30: {
                        int n3;
                        block35: {
                            int i2;
                            int k;
                            block33: {
                                int n4;
                                block34: {
                                    int k1;
                                    block31: {
                                        int n5;
                                        block32: {
                                            int j1;
                                            block27: {
                                                int n6;
                                                block28: {
                                                    int i;
                                                    if (this.initJdbcStatement(copymode)) break block27;
                                                    n6 = i = 0;
                                                    Object var10_16 = null;
                                                    if (this.updateStatement == null) break block28;
                                                    this.updateStatement.clearParameters();
                                                }
                                                if (this.insertStatement != null) {
                                                    this.insertStatement.clearParameters();
                                                }
                                                return n6;
                                            }
                                            if (this.forceInsert) break block29;
                                            if (flag && this.updateStatement != null) {
                                                this.loadRecord(hashtable, false);
                                            }
                                            if (hashtable1 != null) {
                                                Enumeration enumeration = hashtable1.keys();
                                                while (enumeration.hasMoreElements()) {
                                                    Object obj = enumeration.nextElement();
                                                    Object obj2 = hashtable1.get(obj);
                                                    if (obj2 == Constants.NULL) {
                                                        hashtable.remove(obj);
                                                        continue;
                                                    }
                                                    if (hashtable.get(obj) != null || obj2 == null) continue;
                                                    hashtable.put(obj, obj2);
                                                }
                                            }
                                            if (this.updateStatement == null) break block30;
                                            if (!this.forceInsertCaseCount) break block31;
                                            int j = this.countRecord(hashtable);
                                            if (j <= 0) break block30;
                                            this.setUpdateStmtParams(hashtable);
                                            this.updateStatement.executeUpdate();
                                            n5 = j1 = j;
                                            Object var10_17 = null;
                                            if (this.updateStatement == null) break block32;
                                            this.updateStatement.clearParameters();
                                        }
                                        if (this.insertStatement != null) {
                                            this.insertStatement.clearParameters();
                                        }
                                        return n5;
                                    }
                                    this.setUpdateStmtParams(hashtable);
                                    k = this.updateStatement.executeUpdate();
                                    if (k <= 0) break block33;
                                    n4 = k1 = k;
                                    Object var10_18 = null;
                                    if (this.updateStatement == null) break block34;
                                    this.updateStatement.clearParameters();
                                }
                                if (this.insertStatement != null) {
                                    this.insertStatement.clearParameters();
                                }
                                return n4;
                            }
                            if (!this.doInsertCaseCount || (k = this.countRecord(hashtable)) <= 0) break block30;
                            n3 = i2 = k;
                            Object var10_19 = null;
                            if (this.updateStatement == null) break block35;
                            this.updateStatement.clearParameters();
                        }
                        if (this.insertStatement != null) {
                            this.insertStatement.clearParameters();
                        }
                        return n3;
                    }
                    if (!this.nonInsert) break block29;
                    n2 = l = 0;
                    Object var10_20 = null;
                    if (this.updateStatement == null) break block36;
                    this.updateStatement.clearParameters();
                }
                if (this.insertStatement != null) {
                    this.insertStatement.clearParameters();
                }
                return n2;
            }
            try {
                int j2;
                if (this.updateStatement != null) {
                    this.updateStatement.clearParameters();
                }
                if (this.insertStatement != null) {
                    this.insertStatement.clearParameters();
                }
                int i1 = 0;
                int l1 = 0;
                while (l1 < this.columnsName.length) {
                    int l2;
                    Object obj3 = hashtable.get(this.columnsName[l1]);
                    int k2 = this.columnsSqlType != null ? this.columnsSqlType[l1] : 0;
                    int n7 = l2 = this.columnsFlag != null ? this.columnsFlag[l1] : 0;
                    if (obj3 == null && k2 != 0 && (this.columnsFlag[l1] & 2) != 0 && (obj3 = Utilities.defaultSqlObject(k2)) instanceof String) {
                        obj3 = " ";
                    }
                    if (!(obj3 == null || !this.notInsertNullRecord || (l2 & 1) != 0 || obj3 instanceof String && ((String)obj3).trim().length() == 0 || obj3 instanceof Number && Tac.valueSignnum((Number)obj3) == 0)) {
                        ++i1;
                    }
                    this.setPreparedStatementParameter(this.insertStatement, l1 + 1, obj3, k2, l1);
                    ++l1;
                }
                n = j2 = this.notInsertNullRecord && i1 <= 0 ? 0 : this.insertStatement.executeUpdate();
                Object var10_21 = null;
                if (this.updateStatement == null) break block37;
            }
            catch (SQLException sqlexception) {
                try {
                    if (MainApp.isDebug) {
                        Enumeration enumeration1 = hashtable.keys();
                        while (enumeration1.hasMoreElements()) {
                            Object obj1 = enumeration1.nextElement();
                            Object obj4 = hashtable.get(obj1);
                            Message.out.print(obj1 + "=" + obj4 + ",");
                        }
                        Message.out.println();
                        Message.out.println("updateSql=" + this.updateSql);
                        Message.out.println("insertSql=" + this.insertSql);
                    }
                    throw sqlexception;
                }
                catch (Throwable throwable) {
                    block38: {
                        Object var10_22 = null;
                        if (this.updateStatement != null) {
                            this.updateStatement.clearParameters();
                        }
                        if (this.insertStatement == null) break block38;
                        this.insertStatement.clearParameters();
                    }
                    throw throwable;
                }
            }
            this.updateStatement.clearParameters();
        }
        if (this.insertStatement != null) {
            this.insertStatement.clearParameters();
        }
        return n;
    }

    public int updateRecord(Hashtable hashtable, Hashtable hashtable1, boolean flag) throws SQLException {
        int n;
        block36: {
            block28: {
                int n2;
                block35: {
                    int l;
                    block29: {
                        int n3;
                        block34: {
                            int i2;
                            int k;
                            block32: {
                                int n4;
                                block33: {
                                    int k1;
                                    block30: {
                                        int n5;
                                        block31: {
                                            int j1;
                                            block26: {
                                                int n6;
                                                block27: {
                                                    int i;
                                                    if (this.initJdbcStatement(3)) break block26;
                                                    n6 = i = 0;
                                                    Object var9_15 = null;
                                                    if (this.updateStatement == null) break block27;
                                                    this.updateStatement.clearParameters();
                                                }
                                                if (this.insertStatement != null) {
                                                    this.insertStatement.clearParameters();
                                                }
                                                return n6;
                                            }
                                            if (this.forceInsert) break block28;
                                            if (flag && this.updateStatement != null) {
                                                this.loadRecord(hashtable, false);
                                            }
                                            if (hashtable1 != null) {
                                                Enumeration enumeration = hashtable1.keys();
                                                while (enumeration.hasMoreElements()) {
                                                    Object obj = enumeration.nextElement();
                                                    Object obj2 = hashtable1.get(obj);
                                                    if (obj2 == Constants.NULL) {
                                                        hashtable.remove(obj);
                                                        continue;
                                                    }
                                                    if (hashtable.get(obj) != null || obj2 == null) continue;
                                                    hashtable.put(obj, obj2);
                                                }
                                            }
                                            if (this.updateStatement == null) break block29;
                                            if (!this.forceInsertCaseCount) break block30;
                                            int j = this.countRecord(hashtable);
                                            if (j <= 0) break block29;
                                            this.setUpdateStmtParams(hashtable);
                                            this.updateStatement.executeUpdate();
                                            n5 = j1 = j;
                                            Object var9_16 = null;
                                            if (this.updateStatement == null) break block31;
                                            this.updateStatement.clearParameters();
                                        }
                                        if (this.insertStatement != null) {
                                            this.insertStatement.clearParameters();
                                        }
                                        return n5;
                                    }
                                    this.setUpdateStmtParams(hashtable);
                                    k = this.updateStatement.executeUpdate();
                                    if (k <= 0) break block32;
                                    n4 = k1 = k;
                                    Object var9_17 = null;
                                    if (this.updateStatement == null) break block33;
                                    this.updateStatement.clearParameters();
                                }
                                if (this.insertStatement != null) {
                                    this.insertStatement.clearParameters();
                                }
                                return n4;
                            }
                            if (!this.doInsertCaseCount || (k = this.countRecord(hashtable)) <= 0) break block29;
                            n3 = i2 = k;
                            Object var9_18 = null;
                            if (this.updateStatement == null) break block34;
                            this.updateStatement.clearParameters();
                        }
                        if (this.insertStatement != null) {
                            this.insertStatement.clearParameters();
                        }
                        return n3;
                    }
                    if (!this.nonInsert) break block28;
                    n2 = l = 0;
                    Object var9_19 = null;
                    if (this.updateStatement == null) break block35;
                    this.updateStatement.clearParameters();
                }
                if (this.insertStatement != null) {
                    this.insertStatement.clearParameters();
                }
                return n2;
            }
            try {
                int j2;
                if (this.updateStatement != null) {
                    this.updateStatement.clearParameters();
                }
                this.insertStatement.clearParameters();
                int i1 = 0;
                int l1 = 0;
                while (l1 < this.columnsName.length) {
                    int l2;
                    Object obj3 = hashtable.get(this.columnsName[l1]);
                    int k2 = this.columnsSqlType != null ? this.columnsSqlType[l1] : 0;
                    int n7 = l2 = this.columnsFlag != null ? this.columnsFlag[l1] : 0;
                    if (obj3 == null && k2 != 0 && (this.columnsFlag[l1] & 2) != 0 && (obj3 = Utilities.defaultSqlObject(k2)) instanceof String) {
                        obj3 = " ";
                    }
                    if (!(obj3 == null || !this.notInsertNullRecord || (l2 & 1) != 0 || obj3 instanceof String && ((String)obj3).trim().length() == 0 || obj3 instanceof Number && Tac.valueSignnum((Number)obj3) == 0)) {
                        ++i1;
                    }
                    this.setPreparedStatementParameter(this.insertStatement, l1 + 1, obj3, k2, l1);
                    ++l1;
                }
                n = j2 = this.notInsertNullRecord && i1 <= 0 ? 0 : this.insertStatement.executeUpdate();
                Object var9_20 = null;
                if (this.updateStatement == null) break block36;
            }
            catch (SQLException sqlexception) {
                try {
                    if (MainApp.isDebug) {
                        Enumeration enumeration1 = hashtable.keys();
                        while (enumeration1.hasMoreElements()) {
                            Object obj1 = enumeration1.nextElement();
                            Object obj4 = hashtable.get(obj1);
                            Message.out.print(obj1 + "=" + obj4 + ",");
                        }
                        Message.out.println();
                        Message.out.println("updateSql=" + this.updateSql);
                        Message.out.println("insertSql=" + this.insertSql);
                    }
                    throw sqlexception;
                }
                catch (Throwable throwable) {
                    block37: {
                        Object var9_21 = null;
                        if (this.updateStatement != null) {
                            this.updateStatement.clearParameters();
                        }
                        if (this.insertStatement == null) break block37;
                        this.insertStatement.clearParameters();
                    }
                    throw throwable;
                }
            }
            this.updateStatement.clearParameters();
        }
        if (this.insertStatement != null) {
            this.insertStatement.clearParameters();
        }
        return n;
    }

    private void setPrimaryKeyParameter(PreparedStatement preparedstatement, Hashtable hashtable, int i) throws SQLException {
        int j = 0;
        while (j < this.columnsName.length) {
            if ((this.columnsFlag[j] & 1) != 0) {
                int k;
                Object obj = hashtable.get(this.columnsName[j]);
                int n = k = this.columnsSqlType != null ? this.columnsSqlType[j] : 0;
                if (obj == null && k != 0 && (this.columnsFlag[j] & 2) != 0 && (obj = Utilities.defaultSqlObject(k)) instanceof String) {
                    obj = " ";
                }
                this.setPreparedStatementParameter(preparedstatement, i++, obj, k, j);
            }
            ++j;
        }
    }

    public int deleteRecord(Hashtable hashtable) throws SQLException {
        if (!this.initJdbcStatement(4)) {
            return 0;
        }
        this.deleteStatement.clearParameters();
        this.setPrimaryKeyParameter(this.deleteStatement, hashtable, 1);
        return this.deleteStatement.executeUpdate();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countRecord(Hashtable hashtable) throws SQLException {
        block13: {
            if (!this.initJdbcStatement(8)) {
                return 0;
            }
            this.countStatement.clearParameters();
            this.setPrimaryKeyParameter(this.countStatement, hashtable, 1);
            resultset = null;
            try {
                try {
                    resultset = this.countStatement.executeQuery();
                    if (resultset.next()) {
                        var7_5 = i = resultset.getInt(1);
                        var5_7 = null;
                        break block13;
                    }
                    ** GOTO lbl-1000
                }
                catch (SQLException sqlexception) {
                    var7_6 = j = 0;
                    var5_8 = null;
                    try {
                        resultset.close();
                        return var7_6;
                    }
                    catch (Exception var8_12) {
                        // empty catch block
                    }
                    return var7_6;
                }
            }
            catch (Throwable var6_16) {
                var5_9 = null;
                ** try [egrp 2[TRYBLOCK] [4 : 92->101)] { 
lbl29:
                // 1 sources

                resultset.close();
                throw var6_16;
lbl31:
                // 1 sources

                catch (Exception var8_13) {
                    // empty catch block
                }
                throw var6_16;
            }
        }
        try {}
        catch (Exception var8_11) {
            // empty catch block
            return var7_5;
        }
        resultset.close();
        return var7_5;
lbl-1000:
        // 1 sources

        {
            var5_10 = null;
        }
        try {}
        catch (Exception var8_14) {
            return 0;
        }
        resultset.close();
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public int loadRecord(Hashtable hashtable, boolean flag) throws SQLException {
        int n;
        int byte0;
        if (!this.initJdbcStatement(16) || this.selectStatement == null) {
            return -1;
        }
        this.selectStatement.clearParameters();
        this.setPrimaryKeyParameter(this.selectStatement, hashtable, 1);
        ResultSet resultset = null;
        int i = 0;
        resultset = this.selectStatement.executeQuery();
        if (resultset.next()) {
            int j = 1;
            int k = 0;
            while (k < this.columnsName.length) {
                if ((this.columnsFlag[k] & 1) == 0) {
                    Object obj;
                    String s = this.columnsName[k];
                    if ((obj = resultset.getObject(j++)) != null) {
                        if (flag || hashtable.get(s) == null) {
                            hashtable.put(s, obj);
                            ++i;
                        }
                    } else if (flag) {
                        hashtable.remove(s);
                        ++i;
                    }
                }
                ++k;
            }
            break block18;
        }
        int n2 = byte0 = -1;
        Object var10_14 = null;
        try {
            resultset.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        {
            int l;
            block18: {
                return n2;
            }
            n = l = i;
        }
        Object var10_15 = null;
        try {
            resultset.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        {
            return n;
            catch (SQLException sqlexception) {
                int byte1;
                int n3 = byte1 = -2;
                Object var10_16 = null;
                try {
                    resultset.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return n3;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            try {
                resultset.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public int[] getColumnsSqlType() {
        return this.columnsSqlType;
    }

    public int[] getColumnsScale() {
        return this.columnsScale;
    }

    public int[] getColumnsFlag() {
        return this.columnsFlag;
    }

    public static int insertInto(String s, String[] as, String s1) throws SQLException {
        return JdbcUpdateRecord.insertInto(null, s, as, null, s1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int insertInto(Connection connection1, String s, String[] as, Connection connection2, String s1) throws SQLException {
        block16: {
            jdbcupdaterecord = new JdbcUpdateRecord(connection1, s);
            jdbcupdaterecord.doneFlags = 1;
            jdbcupdaterecord.setColumns(new String[0], new String[0], as);
            if (connection2 == null) {
                connection2 = JDBC.getDefaultJdbcConnection();
            }
            statement = null;
            resultset = null;
            i = 0;
            try {
                statement = connection2.createStatement();
                resultset = statement.executeQuery(s1);
                hashtable = new Hashtable<String, Object>();
                block9: while (resultset.next()) {
                    j = 0;
                    while (true) {
                        if (j >= as.length) {
                            jdbcupdaterecord.updateRecord(hashtable);
                            ++i;
                            continue block9;
                        }
                        obj = resultset.getObject(j + 1);
                        if (obj != null) {
                            hashtable.put(as[j], obj);
                        } else {
                            hashtable.remove(as[j]);
                        }
                        ++j;
                    }
                }
            }
            catch (Throwable var13_12) {
                var12_13 = null;
                try {
                    resultset.close();
                }
                catch (Exception var14_15) {
                    // empty catch block
                }
                try {
                    statement.close();
                    throw var13_12;
                }
                catch (Exception var14_15) {
                    // empty catch block
                }
                throw var13_12;
            }
            {
                var12_14 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 172->182)] { 
lbl48:
            // 1 sources

            resultset.close();
            break block16;
lbl50:
            // 1 sources

            catch (Exception var14_16) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var14_16) {
            return i;
        }
        statement.close();
        return i;
    }

    public static int executeInsertSql(String s) throws SQLException {
        s = s.trim();
        String s1 = s.toLowerCase();
        int i = s.indexOf(40);
        int j = s.indexOf(41);
        int k = s1.indexOf("into");
        int l = s1.indexOf("select", j + 1);
        if (!s1.startsWith("insert") || k < 7 || i <= k + 6 || j < i || l < 0) {
            throw new IllegalArgumentException();
        }
        String s2 = s.substring(k + 5, i).trim();
        String[] as = Utilities.splitString(s.substring(i + 1, j), ',');
        String s3 = s.substring(l);
        return JdbcUpdateRecord.insertInto(s2, as, s3);
    }
}

