/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import softcore.awt.AwtUtil;
import softcore.awt.InsetsedJPanel;
import softcore.util.IProgressPrompt;
import softcore.util.Message;
import softcore.util.UnReportableException;
import softcore.util.Utilities;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;

public final class ProgressBar
extends IProgressPrompt {
    private JInternalFrame iFrame;
    private JDesktopPane desktopPane;
    private Frame jFrame;
    private JPanel progressPanel = new InsetsedJPanel(40, 30, 20, 30);
    private JLabel tmpLabel = null;
    private JLabel progressImg = new JLabel();
    private JLabel progressText = new JLabel();
    private SnProgressBar progressBar = new SnProgressBar();
    private JButton cancelButton = new JButton("\u53d6\u6d88");
    private boolean canceled;
    private boolean bShowWait;
    int barFlag;

    private static Container createFrame(String s) {
        JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
        return appdesktoppane == null ? new JInternalFrame(s) : appdesktoppane.createInternalFrame(s, (Component[])null, (Class)null);
    }

    public ProgressBar(String s) {
        this(s, 0, 0, 4);
    }

    public ProgressBar(String s, int i) {
        this(s, 0, i, 3);
    }

    public ProgressBar(String s, int i, int j) {
        this(s, i, j, 3);
    }

    public ProgressBar(String s, int i, int j, int k) {
        Container container1;
        this.barFlag = k;
        Container container = ProgressBar.createFrame(s);
        this.progressBar.setMinimum(i);
        this.progressBar.setMaximum(j);
        if (container instanceof JFrame) {
            container1 = ((JFrame)container).getContentPane();
            this.jFrame = (JFrame)container;
            this.jFrame.setResizable(false);
        } else {
            container1 = ((JInternalFrame)container).getContentPane();
            this.iFrame = (JInternalFrame)container;
            this.iFrame.setResizable(false);
            this.iFrame.setMaximizable(false);
            this.iFrame.setClosable(false);
            this.iFrame.setIconifiable(false);
        }
        this.progressPanel.setLayout(new BorderLayout());
        container1.add((Component)this.progressPanel, "Center");
        if ((k & 4) > 0) {
            ImageIcon imageicon = null;
            try {
                imageicon = Utilities.createImageIconFromResource("res/wait.gif");
                this.progressImg.setIcon(imageicon);
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
            if (imageicon != null) {
                Dimension dimension = new Dimension(imageicon.getIconWidth(), imageicon.getIconHeight());
                InsetsedJPanel insetsedjpanel = new InsetsedJPanel(10, 0, 10, 10);
                insetsedjpanel.setLayout(new BorderLayout());
                this.progressImg.setMaximumSize(dimension);
                this.progressImg.setPreferredSize(dimension);
                insetsedjpanel.add((Component)this.progressImg, "Center");
                this.progressPanel.add((Component)insetsedjpanel, "West");
            }
        }
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 1));
        Dimension dimension1 = new Dimension((k & 4) <= 0 ? 400 : 320, 20);
        this.progressText.setAlignmentX(0.0f);
        this.progressText.setMaximumSize(dimension1);
        this.progressText.setPreferredSize(dimension1);
        jpanel.add(this.progressText);
        jpanel.add(Box.createRigidArea(new Dimension(1, 20)));
        if ((k & 2) > 0) {
            this.progressBar.setStringPainted(i < j);
            this.progressText.setLabelFor(this.progressBar);
            this.progressBar.setAlignmentX(0.0f);
            jpanel.add(this.progressBar);
            jpanel.add(Box.createRigidArea(new Dimension(1, 20)));
        }
        this.progressPanel.add((Component)jpanel, "Center");
        if ((k & 1) > 0) {
            JPanel jpanel1 = new JPanel();
            jpanel1.setAlignmentX(0.0f);
            jpanel1.add(this.cancelButton);
            this.progressPanel.add((Component)jpanel1, "South");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionevent) {
                    ProgressBar.this.canceled = true;
                }
            });
        }
        if (this.jFrame != null) {
            this.jFrame.pack();
            AwtUtil.locateCenter(this.jFrame, null);
            this.jFrame.show();
            this.jFrame.update(this.jFrame.getGraphics());
        } else if (this.iFrame != null) {
            this.desktopPane = MainFrame.getDesktopPane();
            this.iFrame.pack();
            AwtUtil.locateCenter(this.iFrame, this.desktopPane);
            this.desktopPane.add((Component)this.iFrame, JLayeredPane.MODAL_LAYER);
            this.iFrame.moveToFront();
            try {
                this.iFrame.setSelected(true);
                this.iFrame.setMaximum(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.iFrame.setVisible(true);
            try {
                this.iFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.iFrame.update(this.iFrame.getGraphics());
        }
    }

    public void dispose() {
        if (this.iFrame != null) {
            MainFrame.getDesktopPane().closeInternalFrame(this.iFrame);
        }
        if (this.jFrame != null) {
            this.jFrame.dispose();
        }
    }

    public void setProgressText(String s) {
        this.progressText.setText(s);
        Graphics g = this.progressText.getGraphics();
        g.setColor(this.progressText.getBackground());
        Rectangle rectangle = this.progressText.getBounds();
        g.fillRect(0, 0, rectangle.width, rectangle.height);
        this.progressText.update(g);
    }

    public void setProgressTitle(String s) {
        if (this.iFrame != null) {
            this.iFrame.setTitle(s);
        }
        if (this.jFrame != null) {
            this.jFrame.setTitle(s);
        }
    }

    public void setProgressMaxValue(int i) {
        this.progressBar.setMaximum(i);
    }

    public void setProgressValue(int i) {
        if ((this.barFlag & 2) > 0) {
            this.progressBar.setValue(i);
        }
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public void incProgressValue() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    public boolean isProgressCenceled(String s, boolean flag) {
        if (!this.canceled) {
            return false;
        }
        this.canceled = false;
        boolean flag1 = true;
        if (s != null) {
            boolean bl = flag1 = Message.showQuestionDialog("\u53d6\u6d88\u786e\u8ba4", s) == 0;
        }
        if (flag1 && flag) {
            throw new ProgressCancelException(s);
        }
        return flag1;
    }

    public static class ProgressCancelException
    extends RuntimeException
    implements UnReportableException {
        public ProgressCancelException() {
        }

        public ProgressCancelException(String s) {
            super(s);
        }
    }

    public static class SnProgressBar
    extends JComponent {
        protected boolean paintString;
        protected boolean paintBorder;
        protected int curValue = 0;
        protected int minValue;
        protected int maxValue;
        int oldPercent = -1;
        Rectangle clientRect = new Rectangle();

        public boolean isStringPainted() {
            return this.paintString;
        }

        public void setStringPainted(boolean flag) {
            if (this.paintString != flag) {
                this.paintString = flag;
                this.revalidate();
                this.repaint();
            }
        }

        public double getPercentComplete() {
            if (this.maxValue <= this.minValue) {
                return 0.0;
            }
            int i = this.maxValue - this.minValue;
            if (i == 0) {
                return 1.0;
            }
            int j = this.curValue - this.minValue;
            if (j > i) {
                j = i;
            }
            double d = (double)j / (double)i;
            return d;
        }

        public boolean isBorderPainted() {
            return this.paintBorder;
        }

        public void setBorderPainted(boolean flag) {
            if (flag != this.paintBorder) {
                this.paintBorder = flag;
                this.repaint();
            }
        }

        protected void paintBorder(Graphics g) {
            if (this.isBorderPainted()) {
                super.paintBorder(g);
            }
        }

        public int getValue() {
            return this.curValue;
        }

        public int getMinimum() {
            return this.minValue;
        }

        public int getMaximum() {
            return this.maxValue;
        }

        public void setValue(int i) {
            this.curValue = i;
            int j = (int)(100.0 * this.getPercentComplete());
            if (j != this.oldPercent) {
                this.oldPercent = j;
                this.imRepaint();
            }
        }

        public void setMinimum(int i) {
            this.minValue = i;
        }

        public void setMaximum(int i) {
            this.maxValue = i;
        }

        public void imRepaint() {
            this.paintComponent(this.getGraphics());
        }

        public Dimension getPreferredSize() {
            return new Dimension(160, 30);
        }

        public void getClientRect(Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            Dimension dimension = this.getSize();
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                rectangle.setBounds(insets.left, insets.top, dimension.width - insets.right - insets.left, dimension.height - insets.bottom - insets.top);
            } else {
                rectangle.setBounds(0, 0, dimension.width, dimension.height);
            }
        }

        protected void paintComponent(Graphics g) {
            this.getClientRect(this.clientRect);
            double d = this.getPercentComplete();
            int i = (int)(d * (double)this.clientRect.width);
            int j = (int)(d * 100.0);
            g.setColor(Color.white);
            g.fillRect(this.clientRect.x, this.clientRect.y, this.clientRect.width, this.clientRect.height);
            g.setColor(this.getForeground());
            if (i > 0) {
                g.setColor(Color.blue);
                g.fillRect(this.clientRect.x, this.clientRect.y, i, this.clientRect.height);
                g.setColor(this.getForeground());
            }
            if (this.paintString) {
                String s = j + "%";
                FontMetrics fontmetrics = g.getFontMetrics();
                int k = fontmetrics.stringWidth(s);
                g.setXORMode(Color.white);
                g.drawString(s, (this.clientRect.width - k) / 2, (this.clientRect.height + fontmetrics.getAscent()) / 2 - fontmetrics.getLeading());
                g.setXORMode(Color.black);
            }
        }

        public SnProgressBar() {
            this(0, 100);
        }

        public SnProgressBar(int i, int j) {
            this.minValue = i;
            this.maxValue = j;
            this.setBorderPainted(true);
            this.setStringPainted(true);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }
    }
}

