/*
 * Decompiled with CFR 0.152.
 */
package softcore.util.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import softcore.util.IProcessFile;
import softcore.util.IProgressPrompt;
import softcore.util.Message;
import softcore.util.PreprocessedTextReader;
import softcore.util.ProgressBar;
import softcore.util.Utilities;

public final class FileZip {
    public static int copyFiles(String s, String s1, String s2, String s3, boolean flag, boolean flag1) throws IOException {
        ProgressBar progressbar = new ProgressBar("Copy File", 0, 0);
        try {
            int j;
            CopyProcess copyprocess = new CopyProcess(s1, flag1);
            File file = new File(s);
            int i = file.getAbsolutePath().length() + 1;
            int n = j = Utilities.forEachFile(i, s, s2, s3, flag, (IProcessFile)copyprocess, (IProgressPrompt)progressbar);
            Object var11_12 = null;
            progressbar.dispose();
            return n;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            progressbar.dispose();
            throw throwable;
        }
    }

    private FileZip() {
    }

    private static void loadArgsFromFile(Vector vector, String s) {
        try {
            String s1;
            PreprocessedTextReader preprocessedtextreader = new PreprocessedTextReader(new FileReader(s));
            while ((s1 = preprocessedtextreader.readLine()) != null) {
                s1 = String.valueOf(s1.trim()) + ' ';
                int i = 0;
                int j = 0;
                while (j < s1.length()) {
                    if (s1.charAt(j) <= ' ' && j > i) {
                        String s2 = s1.substring(i, j).trim();
                        i = j + 1;
                        if (s2.length() > 0) {
                            vector.addElement(s2);
                        }
                    }
                    ++j;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFile(String[] as) {
        int i = as.length;
        ProgressBar progressbar = new ProgressBar("Create File", 0, 0);
        ZipProcess zipprocess = new ZipProcess();
        Vector<String> vector = new Vector<String>();
        int j = 0;
        while (j < i) {
            String s;
            if ((s = as[j++]).charAt(0) == '@') {
                FileZip.loadArgsFromFile(vector, s.substring(1));
                continue;
            }
            vector.addElement(s);
        }
        try {
            try {
                Object obj = null;
                ZipOutputStream jaroutputstream = null;
                boolean flag = true;
                File file = null;
                int k = 0;
                int l = 0;
                while (true) {
                    int i1;
                    String s1;
                    if (l >= vector.size()) {
                        jaroutputstream.close();
                    }
                    if ((s1 = (String)vector.elementAt(l++)).equalsIgnoreCase("-s")) {
                        flag = true;
                        continue;
                    }
                    if (s1.equalsIgnoreCase("-s-")) {
                        flag = false;
                        continue;
                    }
                    if (s1.equalsIgnoreCase("-a")) {
                        if (jaroutputstream != null) {
                            jaroutputstream.close();
                        }
                        String s2 = as[l++];
                        FileOutputStream fileoutputstream = new FileOutputStream(s2);
                        jaroutputstream = new JarOutputStream(fileoutputstream);
                        zipprocess.jarProcess = false;
                        progressbar.setProgressTitle("Create " + s2);
                        continue;
                    }
                    if (s1.equalsIgnoreCase("-jar")) {
                        if (jaroutputstream != null) {
                            jaroutputstream.close();
                        }
                        String s3 = as[l++];
                        FileOutputStream fileoutputstream1 = new FileOutputStream(s3);
                        jaroutputstream = new JarOutputStream(fileoutputstream1);
                        zipprocess.jarProcess = true;
                        progressbar.setProgressTitle("Create " + s3);
                        continue;
                    }
                    if (k == 0) {
                        File file1 = new File(s1);
                        k = file1 != null ? file1.getAbsolutePath().length() + 1 : s1.length();
                        continue;
                    }
                    if (file == null) {
                        file = new File(s1);
                        continue;
                    }
                    zipprocess.setZipOutputStream(jaroutputstream);
                    if (!file.isDirectory()) {
                        Message.out.println(String.valueOf(file.getAbsolutePath()) + " not a valid path.");
                    }
                    if ((i1 = s1.indexOf(59)) >= 0) {
                        Utilities.forEachFile(k, file, s1.substring(0, i1), s1.substring(i1 + 1), flag, (IProcessFile)zipprocess, (IProgressPrompt)progressbar);
                    } else {
                        Utilities.forEachFile(k, file, s1, null, flag, (IProcessFile)zipprocess, (IProgressPrompt)progressbar);
                    }
                    k = 0;
                    file = null;
                }
            }
            catch (Exception exception) {
                Message.out.println(exception);
                exception.printStackTrace(Message.out);
            }
            Object var14_21 = null;
            progressbar.dispose();
            return;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            progressbar.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int unzip(String s, String s1, String s2, boolean flag) throws IOException {
        ProgressBar progressbar = new ProgressBar("Unzip File", 0, 0);
        ZipInputStream zipinputstream = null;
        int i = 0;
        try {
            ZipEntry zipentry;
            zipinputstream = new ZipInputStream(new FileInputStream(s));
            byte[] abyte0 = new byte[1024];
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                Object var13_13;
                String s3 = zipentry.getName();
                File file = new File(s1, s3);
                if (file.exists() && file.lastModified() >= zipentry.getTime()) continue;
                progressbar.setProgressText(s3);
                Message.out.println(s3);
                Utilities.makeDirForFilename(file.getAbsolutePath());
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                try {
                    int j;
                    while ((j = zipinputstream.read(abyte0)) > 0) {
                        fileoutputstream.write(abyte0, 0, j);
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    fileoutputstream.close();
                    throw throwable;
                }
                {
                    var13_13 = null;
                    fileoutputstream.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            progressbar.dispose();
            if (zipinputstream == null) throw throwable;
            zipinputstream.close();
            throw throwable;
        }
        {
            Object var15_17 = null;
            progressbar.dispose();
            if (zipinputstream == null) return i;
        }
        zipinputstream.close();
        return i;
    }

    public static class CopyProcess
    implements IProcessFile {
        String toPath;
        boolean forceCopy;
        private byte[] buffer = new byte[1024];

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void processFile(File file, int i) throws IOException {
            FileOutputStream fileoutputstream;
            block6: {
                String s = file.getAbsolutePath();
                File file1 = new File(this.toPath, s.substring(i));
                if (file1.exists() && !this.forceCopy && file.lastModified() <= file1.lastModified()) {
                    return;
                }
                Utilities.makeDirForFilename(file1.getAbsolutePath());
                Message.out.println(String.valueOf(file.getAbsolutePath()) + "=>" + file1.getAbsolutePath());
                FileInputStream fileinputstream = null;
                fileoutputstream = null;
                try {
                    int j;
                    fileinputstream = new FileInputStream(file);
                    fileoutputstream = new FileOutputStream(file1);
                    while ((j = fileinputstream.read(this.buffer)) > 0) {
                        fileoutputstream.write(this.buffer, 0, j);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (fileinputstream != null) {
                        fileinputstream.close();
                    }
                    if (fileoutputstream == null) throw throwable;
                    fileoutputstream.close();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    if (fileinputstream == null) break block6;
                }
                fileinputstream.close();
            }
            if (fileoutputstream == null) return;
            fileoutputstream.close();
        }

        CopyProcess(String s, boolean flag) {
            this.toPath = s;
            this.forceCopy = flag;
        }
    }

    public static class ZipProcess
    implements IProcessFile {
        boolean jarProcess;
        ZipOutputStream zipOut;
        private byte[] buffer = new byte[1024];

        public void setZipOutputStream(ZipOutputStream zipoutputstream) {
            this.zipOut = zipoutputstream;
        }

        public void processFile(File file, int i) throws IOException {
            int j;
            String s = file.getAbsolutePath();
            String s1 = Utilities.replaceChar(s.substring(i), '\\', '/');
            ZipEntry obj = this.jarProcess ? new JarEntry(s1) : new ZipEntry(s1);
            ((ZipEntry)obj).setTime(file.lastModified());
            this.zipOut.putNextEntry(obj);
            FileInputStream fileinputstream = new FileInputStream(file);
            while ((j = fileinputstream.read(this.buffer)) > 0) {
                this.zipOut.write(this.buffer, 0, j);
            }
            fileinputstream.close();
            this.zipOut.closeEntry();
        }

        ZipProcess() {
        }

        ZipProcess(ZipOutputStream zipoutputstream) {
            this.zipOut = zipoutputstream;
        }
    }
}

