/*
 * Decompiled with CFR 0.152.
 */
package softcore.win;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;
import softcore.dataset.AbstractDataSet;
import softcore.dataset.DataColumn;
import softcore.dataset.DataSetException;

public class AdoDataSet
extends AbstractDataSet {
    protected final Dispatch recordSet = new Dispatch("ADODB.Recordset");
    Dispatch fields;

    public AdoDataSet() {
    }

    public AdoDataSet(String s, String s1) {
        this();
        this.open(s, s1);
    }

    public void open(String s, String s1) {
        Dispatch.call((Object)this.recordSet, (String)"Open", (Object)new Variant(s1), (Object)new Variant(s));
        this.fields = Dispatch.get((Object)this.recordSet, (String)"Fields").toDispatch();
        int i = Dispatch.get((Object)this.fields, (String)"Count").toInt();
        System.out.println("columnCount=" + i);
        this.dataColumns = new DataColumn[i];
        int j = 0;
        while (j < i) {
            System.out.println(j);
            Dispatch dispatch = Dispatch.call((Object)this.fields, (String)"Item", (Object)new Variant(j)).toDispatch();
            this.dataColumns[j] = new DataColumn();
            this.dataColumns[j].columnName = Dispatch.get((Object)dispatch, (String)"Name").toString();
            System.out.println(this.dataColumns[j].columnName);
            this.dataColumns[j].sqlType = Dispatch.get((Object)dispatch, (String)"Type").toInt();
            this.dataColumns[j].size = Dispatch.get((Object)dispatch, (String)"DefinedSize").toInt();
            this.dataColumns[j].displayCaption = this.dataColumns[j].columnName;
            this.dataColumns[j].decimals = Dispatch.get((Object)dispatch, (String)"NumericScale").toInt();
            if (this.dataColumns[j].decimals == 255) {
                this.dataColumns[j].decimals = 0;
            }
            ++j;
        }
    }

    public int getRowCount() throws DataSetException {
        return Dispatch.get((Object)this.recordSet, (String)"RecordCount").toInt();
    }

    public int getRow() throws DataSetException {
        return 0;
    }

    public void gotoRow(int i) throws DataSetException {
        Dispatch.call((Object)this.recordSet, (String)"Move", (Object)new Variant(i), (Object)new Variant(0));
    }

    public Object getValue(int i, int j) throws DataSetException {
        return null;
    }

    public Object getValue(int i, String s) throws DataSetException {
        return this.getValue(i, this.toColumnIndex(s));
    }

    public Object getValue(int i) throws DataSetException {
        return AdoDataSet.variant2obj(Dispatch.get((Object)Dispatch.call((Object)this.fields, (String)"Item", (Object)new Variant(i)).toDispatch(), (String)"Value"));
    }

    public Object getValue(String s) throws DataSetException {
        return this.getValue(this.toColumnIndex(s));
    }

    public void insertRow(boolean flag) throws DataSetException {
    }

    public void postRow() throws DataSetException {
    }

    public boolean isRowChanged() throws DataSetException {
        return false;
    }

    public boolean isNewRow() throws DataSetException {
        return false;
    }

    public void deleteRow() throws DataSetException {
    }

    public void setValue(int i, Object obj) throws DataSetException {
    }

    public void setValue(String s, Object obj) throws DataSetException {
        this.setValue(this.toColumnIndex(s), obj);
    }

    public void saveChanges() throws DataSetException {
    }

    public boolean isChanged() throws DataSetException {
        return false;
    }

    public void close() throws DataSetException {
        Dispatch.call((Object)this.recordSet, (String)"Close");
    }

    public boolean atBOF() {
        return Dispatch.get((Object)this.recordSet, (String)"BOF").toBoolean();
    }

    public boolean atEOF() {
        return Dispatch.get((Object)this.recordSet, (String)"EOF").toBoolean();
    }

    public boolean gotoFirst() throws DataSetException {
        try {
            Dispatch.call((Object)this.recordSet, (String)"MoveFirst");
        }
        catch (Exception exception) {
            return false;
        }
        return !this.atBOF();
    }

    public boolean gotoLast() throws DataSetException {
        try {
            Dispatch.call((Object)this.recordSet, (String)"MoveLast");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return !this.atEOF();
    }

    public boolean gotoNext() throws DataSetException {
        try {
            Dispatch.call((Object)this.recordSet, (String)"MoveNext");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return !this.atEOF();
    }

    public boolean gotoPrev() throws DataSetException {
        try {
            Dispatch.call((Object)this.recordSet, (String)"MovePrevious");
        }
        catch (Exception exception) {
            return false;
        }
        return !this.atBOF();
    }

    public static Object variant2obj(Variant variant) {
        switch (variant.getvt()) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return new Short(variant.getShort());
            }
            case 3: {
                return new Integer(variant.getInt());
            }
            case 4: {
                return new Float(variant.getFloat());
            }
            case 5: {
                return new Double(variant.getDouble());
            }
            case 6: {
                return new BigDecimal(new BigInteger("" + variant.getCurrency()), 4);
            }
            case 7: {
                return null;
            }
            case 8: {
                return variant.getString();
            }
            case 11: {
                return variant.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new RuntimeException();
    }
}

