/*
 * Decompiled with CFR 0.152.
 */
package softcore.win;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.SafeArray;
import com.jacob.com.Variant;
import java.awt.Font;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import softcore.util.Message;
import softcore.util.Utilities;

public class MSExcelApp {
    public ActiveXComponent excelApp;
    private Dispatch workbooks;
    private Dispatch workbook;
    private Dispatch sheet;
    String m_szFileName;
    String m_szSheetName;
    boolean m_bNewFile;
    boolean m_bReadOnly;
    boolean m_bValidate;
    boolean bPreparedFectch;
    int rowCount;
    int colCount;
    int curRow;
    Vector fldNames = new Vector();
    boolean bCreateFile = false;
    boolean visible;
    public static int modeAppend = 1;
    public static int modeAlwayOverWrite = 2;
    SafeArray sa;

    public MSExcelApp() {
        this(true);
    }

    public MSExcelApp(boolean flag) {
        this.visible = flag;
    }

    public boolean openExcel(String s, String s1) {
        return this.openExcel(s, s1, true, false, false, -1);
    }

    public boolean openExcel(String s, String s1, boolean flag) {
        return this.openExcel(s, s1, flag, false, false, -1);
    }

    public boolean openExcel(String s, String s1, boolean flag, boolean flag1, boolean flag2) {
        return this.openExcel(s, s1, flag, flag1, flag2, -1);
    }

    public boolean openExcel(String s, String s1, boolean flag, boolean flag1, boolean flag2, int i) {
        block14: {
            block15: {
                if (i < 0) {
                    i = 0;
                }
                if (this.excelApp == null) {
                    ComThread.InitSTA();
                    this.excelApp = new ActiveXComponent("Excel.Application");
                    if (this.visible) {
                        this.excelApp.setProperty("Visible", new Variant(true));
                    }
                }
                this.workbooks = Dispatch.get((Object)this.excelApp, (String)"Workbooks").toDispatch();
                this.bPreparedFectch = false;
                this.curRow = -1;
                this.colCount = 0;
                this.rowCount = 0;
                if (s.indexOf(47) >= 0) {
                    s = s.replace('/', '\\');
                }
                this.m_szFileName = s;
                this.m_bReadOnly = flag;
                this.m_bNewFile = flag1;
                if (!flag1 && MSExcelApp.isFileExist(s)) {
                    this.workbook = Dispatch.call((Object)this.workbooks, (String)"Open", (Object)s).toDispatch();
                    this.m_bValidate = true;
                } else {
                    this.workbook = Dispatch.call((Object)this.workbooks, (String)"Add").toDispatch();
                    this.bCreateFile = true;
                    this.m_bValidate = true;
                }
                if (s1 == null || s1.length() <= 0) break block14;
                String s2 = "[]:/?*";
                int j = 0;
                while (j < s2.length()) {
                    if (s1.indexOf(s2.charAt(j)) >= 0) {
                        s1 = s1.replace(s2.charAt(j), '-');
                    }
                    ++j;
                }
                s1 = s1.replace(':', '-');
                if (flag2 && !this.isSheetExist(s1)) {
                    this.m_bValidate = this.newSheet(s1);
                    break block14;
                }
                this.m_bValidate = this.activeSheet(s1);
                if (!this.m_bValidate) break block14;
                if (flag || (i & modeAppend) != 0) break block15;
                if ((i & modeAlwayOverWrite) > 0 || Message.showQuestionDialog("\u63d0\u793a", "\u5df2\u6709Sheet'" + s1 + "',\u662f\u5426\u8986\u76d6\uff1f") == 0) {
                    Dispatch dispatch = Dispatch.get((Object)this.sheet, (String)"Cells").toDispatch();
                    Dispatch.call((Object)dispatch, (String)"Select");
                    Dispatch.call((Object)dispatch, (String)"ClearContents");
                    dispatch = Dispatch.call((Object)this.sheet, (String)"Range", (Object)"A1").toDispatch();
                    Dispatch.call((Object)dispatch, (String)"Select");
                    return true;
                }
                return false;
            }
            try {
                this.innerGetRowColCount();
                int k = 0;
                while (k < this.colCount) {
                    this.fldNames.addElement(this.innerGetColumnName(k));
                    ++k;
                }
            }
            catch (Exception exception) {
                this.m_bValidate = false;
                exception.printStackTrace();
            }
        }
        return this.m_bValidate;
    }

    public static boolean isFileExist(String s) {
        try {
            File file = new File(s);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int nameToIndex(String s) {
        int i = 0;
        while (i < this.fldNames.size()) {
            if (this.fldNames.elementAt(i).toString().equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Dispatch addField(int i, String s, int j) {
        if (this.setCellValue(-1, i, s)) {
            this.fldNames.addElement(s);
            String s1 = "@";
            if (j == 4 || j == 3 || j == 2 || j == 5) {
                s1 = "0;[\u7ea2\u8272]0";
            } else if (j == 10 || j == 6 || j == 7) {
                s1 = "0.00_ ";
            } else if (j == 13 || j == 15) {
                s1 = "yyyy-m-d";
            }
            String s2 = Utilities.getExcelCellColName(i);
            Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Columns", (int)2, (Object[])new Object[]{String.valueOf(s2) + ":" + s2}, (int[])new int[1]).toDispatch();
            Dispatch.put((Object)dispatch, (String)"NumberFormatLocal", (Object)s1);
            ++this.colCount;
            return dispatch;
        }
        return null;
    }

    public String getColumnName(int i) {
        if (i >= 0 && i < this.fldNames.size()) {
            return this.fldNames.elementAt(i).toString();
        }
        return "";
    }

    public int getColumnType(int i) {
        return 0;
    }

    protected String getCellName(int i, int j) {
        return String.valueOf(Utilities.getExcelCellColName(j)) + (i + 2);
    }

    public void close() {
        this.fldNames.removeAllElements();
        this.endFetchData();
        if (this.workbook != null) {
            Dispatch.call((Object)this.workbook, (String)"Close", (Object)new Variant(false));
            this.workbook = null;
        }
        if (this.excelApp != null) {
            this.excelApp.invoke("Quit", new Variant[0]);
            ComThread.Release();
            this.excelApp = null;
        }
    }

    public String getFileName() {
        return this.m_szFileName;
    }

    boolean isReadOnly() {
        return this.m_bReadOnly;
    }

    public void prepareFetchData() {
        if (!this.bPreparedFectch) {
            String s = this.getCellName(-1, 0);
            String s1 = this.getCellName(this.rowCount, this.colCount);
            Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{String.valueOf(s) + ":" + s1}, (int[])new int[1]).toDispatch();
            Variant variant = Dispatch.get((Object)dispatch, (String)"Value");
            this.sa = variant.toSafeArray();
            this.bPreparedFectch = true;
        }
    }

    public void endFetchData() {
        if (this.bPreparedFectch) {
            if (this.sa != null) {
                this.sa.release();
                this.sa = null;
            }
            this.bPreparedFectch = false;
        }
    }

    boolean activeSheet(String s) {
        Dispatch dispatch = Dispatch.get((Object)this.workbook, (String)"Sheets").toDispatch();
        int i = Dispatch.get((Object)dispatch, (String)"Count").toInt();
        int j = 0;
        while (j < i) {
            this.sheet = Dispatch.call((Object)dispatch, (String)"Item", (Object)new Variant(j + 1)).toDispatch();
            if (s.equalsIgnoreCase(Dispatch.get((Object)this.sheet, (String)"name").toString())) {
                Dispatch.call((Object)this.sheet, (String)"Activate");
                return true;
            }
            ++j;
        }
        return false;
    }

    boolean isSheetExist(String s) {
        Dispatch dispatch = Dispatch.get((Object)this.workbook, (String)"Sheets").toDispatch();
        int i = Dispatch.get((Object)dispatch, (String)"Count").toInt();
        int j = 0;
        while (j < i) {
            this.sheet = Dispatch.call((Object)dispatch, (String)"Item", (Object)new Variant(j + 1)).toDispatch();
            if (s.equalsIgnoreCase(Dispatch.get((Object)this.sheet, (String)"name").toString())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    boolean deleteSheet(String s) {
        Dispatch dispatch = Dispatch.get((Object)this.workbook, (String)"Sheets").toDispatch();
        int i = Dispatch.get((Object)dispatch, (String)"Count").toInt();
        int j = 0;
        while (j < i) {
            this.sheet = Dispatch.call((Object)dispatch, (String)"Item", (Object)new Variant(j + 1)).toDispatch();
            if (s.equalsIgnoreCase(Dispatch.get((Object)this.sheet, (String)"name").toString())) {
                try {
                    Dispatch.call((Object)this.sheet, (String)"Delete");
                    return true;
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++j;
        }
        return false;
    }

    boolean newSheet(String s) {
        try {
            Dispatch dispatch = Dispatch.get((Object)this.workbook, (String)"Sheets").toDispatch();
            this.sheet = Dispatch.call((Object)dispatch, (String)"Add").toDispatch();
            Dispatch.put((Object)this.sheet, (String)"Name", (Object)s);
        }
        catch (Exception exception) {
            Message.showErrorDialog("\u9519\u8bef", "\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01");
            return false;
        }
        return true;
    }

    public String[] getSheetNames() {
        Dispatch dispatch = Dispatch.get((Object)this.workbook, (String)"Sheets").toDispatch();
        int i = Dispatch.get((Object)dispatch, (String)"Count").toInt();
        String[] as = new String[i];
        int j = 0;
        while (j < i) {
            this.sheet = Dispatch.call((Object)dispatch, (String)"Item", (Object)new Variant(j + 1)).toDispatch();
            as[j] = Dispatch.get((Object)this.sheet, (String)"name").toString();
            ++j;
        }
        return as;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getRow() {
        return this.curRow;
    }

    public void gotoRow(int i) {
        if (i >= 0 && i < this.rowCount) {
            this.curRow = i;
        }
    }

    public Object getValue(int i, int j) {
        return this.getCellValue(i, j);
    }

    public Object getValue(int i, String s) {
        return this.getCellValue(i, this.nameToIndex(s));
    }

    public Object getValue(int i) {
        return this.getCellValue(this.curRow, i);
    }

    public void insertRow(boolean flag) {
        this.insertRow(this.curRow, flag);
    }

    public void insertRow(int i, boolean flag) {
        if (this.m_bReadOnly || !this.m_bValidate) {
            return;
        }
        try {
            if (!flag) {
                this.curRow = this.rowCount++;
            } else {
                this.curRow = i;
                String s = this.getCellName(i, 0);
                String s1 = this.getCellName(i, this.colCount - 1);
                Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{String.valueOf(s) + ":" + s1}, (int[])new int[1]).toDispatch();
                boolean flag1 = Dispatch.call((Object)dispatch, (String)"Insert", (Object)new Variant(-4121.0)).toBoolean();
                if (flag1) {
                    ++this.rowCount;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void postRow() {
        if (this.m_bReadOnly || !this.m_bValidate || this.excelApp == null) {
            return;
        }
        try {
            if (this.bCreateFile) {
                Dispatch.call((Object)this.workbook, (String)"SaveAs", (Object)this.m_szFileName);
            } else {
                Dispatch.call((Object)this.workbook, (String)"Save");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isRowChanged() {
        return false;
    }

    public boolean isNewRow() {
        return false;
    }

    public boolean deleteIndexRow(int i) {
        if (this.m_bReadOnly || !this.m_bValidate || i >= this.rowCount || i < 0) {
            return false;
        }
        boolean flag = false;
        try {
            Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{this.getCellName(i, 0), this.getCellName(i, this.colCount - 1)}, (int[])new int[1]).toDispatch();
            flag = Dispatch.call((Object)dispatch, (String)"Delete", (Object)new Variant(-4162.0)).toBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flag) {
            --this.rowCount;
            if (this.curRow >= this.rowCount) {
                this.curRow = this.rowCount - 1;
            }
        }
        return flag;
    }

    public void deleteRow() {
        this.deleteIndexRow(this.curRow);
    }

    public void saveChanges() {
        this.postRow();
    }

    public boolean gotoFirst() {
        this.curRow = 0;
        return this.rowCount > 0;
    }

    public boolean gotoLast() {
        this.curRow = this.rowCount - 1;
        return this.rowCount > 0;
    }

    public boolean gotoNext() {
        if (this.curRow < this.rowCount - 1) {
            ++this.curRow;
            return true;
        }
        return false;
    }

    public boolean gotoPrev() {
        if (this.curRow > 0) {
            --this.curRow;
            return true;
        }
        return false;
    }

    public void edit() {
    }

    public void update() {
        this.postRow();
    }

    void innerGetRowColCount() {
        this.colCount = 0;
        this.rowCount = 0;
        if (!this.m_bValidate) {
            return;
        }
        Dispatch dispatch = Dispatch.get((Object)this.excelApp, (String)"ActiveCell").toDispatch();
        dispatch = Dispatch.call((Object)dispatch, (String)"SpecialCells", (Object)new Variant(11)).toDispatch();
        Dispatch.call((Object)dispatch, (String)"Select");
        this.rowCount = Dispatch.get((Object)dispatch, (String)"Row").toInt() - 1;
        this.colCount = Dispatch.get((Object)dispatch, (String)"Column").toInt();
    }

    String innerGetColumnName(int i) {
        Object obj = this.getCellValue(-1, i);
        return obj != null ? obj.toString() : "";
    }

    public Object variantToObject(Variant variant) {
        Object obj = null;
        if (variant == null || variant.isNull()) {
            obj = null;
        } else {
            switch (variant.getvt()) {
                case 11: {
                    obj = new Boolean(variant.getBoolean());
                    break;
                }
                case 5: {
                    obj = new Double(variant.getDouble());
                    break;
                }
                case 4: {
                    obj = new Float(variant.getFloat());
                    break;
                }
                case 3: {
                    obj = new Integer(variant.getInt());
                    break;
                }
                case 2: {
                    obj = new Short(variant.getShort());
                    break;
                }
                case 8: {
                    obj = variant.getString();
                    break;
                }
                default: {
                    obj = variant;
                }
            }
        }
        return obj;
    }

    public Object getCellValue(String s) {
        if (!this.m_bValidate || s == null) {
            return null;
        }
        Object obj = null;
        try {
            if (this.bPreparedFectch && this.sa != null) {
                int k = s.length();
                int i = 0;
                while (i < k) {
                    char c = s.charAt(i);
                    if (c >= '0' && c <= '9') break;
                    ++i;
                }
                int l = Integer.parseInt(s.substring(i));
                String s1 = s.substring(0, i);
                int i1 = 0;
                int j = 0;
                while (j < s1.length()) {
                    i1 *= 26;
                    char c1 = s1.charAt(j);
                    i1 += 1 + (s1.charAt(j) - 65);
                    ++j;
                }
                obj = this.sa.getVariant(l, i1);
            } else {
                Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{s}, (int[])new int[1]).toDispatch();
                obj = Dispatch.get((Object)dispatch, (String)"Value");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (obj instanceof Variant) {
            Variant variant = obj;
            obj = variant.isNull() ? null : this.variantToObject(variant);
        }
        return obj;
    }

    public Object getCellValue(int i, int j) {
        Object obj = null;
        if (this.m_bValidate && i >= -1 && j >= 0 && i < this.rowCount && j < this.colCount) {
            try {
                if (this.bPreparedFectch && this.sa != null) {
                    obj = this.sa.getVariant(i + 2, j + 1);
                } else {
                    String s = this.getCellName(i, j);
                    Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{s}, (int[])new int[1]).toDispatch();
                    obj = Dispatch.get((Object)dispatch, (String)"Value");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (obj instanceof Variant) {
            Variant variant = (Variant)obj;
            obj = variant.isNull() ? null : this.variantToObject(variant);
        }
        return obj;
    }

    public boolean setCellValue(int i, int j, Object obj) {
        if (!this.m_bValidate || this.m_bReadOnly) {
            return false;
        }
        if (i >= -1 && j >= 0) {
            try {
                String s = this.getCellName(i, j);
                Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{s}, (int[])new int[1]).toDispatch();
                String s1 = obj == null ? "" : (obj instanceof Date ? Utilities.dateToString((Date)obj) : obj.toString());
                Dispatch.put((Object)dispatch, (String)"FormulaR1C1", (Object)s1);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public Dispatch getCell(int i) {
        return this.getCell(this.curRow, i);
    }

    public Dispatch getCell(int i, int j) {
        String s = this.getCellName(this.curRow, j);
        return Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{s}, (int[])new int[1]).toDispatch();
    }

    public void mergeCell(int i, int j, int k, int l) {
        this.mergeCell(this.getCellName(i, j), this.getCellName(k, l));
    }

    public void mergeCell(String s, String s1) {
        Dispatch dispatch = Dispatch.invoke((Object)this.sheet, (String)"Range", (int)2, (Object[])new Object[]{String.valueOf(s) + ":" + s1}, (int[])new int[1]).toDispatch();
        Variant variant = new Variant();
        Dispatch.call((Object)dispatch, (String)"Merge", (Object)variant);
    }

    public Dispatch getColumn(int i) {
        String s = Utilities.getExcelCellColName(i);
        this.sheet = Dispatch.get((Object)this.workbook, (String)"ActiveSheet").toDispatch();
        return Dispatch.invoke((Object)this.sheet, (String)"Columns", (int)2, (Object[])new Object[]{String.valueOf(s) + ":" + s}, (int[])new int[1]).toDispatch();
    }

    public void setCellFont(int i, Font font) {
        double d = 0.7;
        Dispatch dispatch = Dispatch.get((Object)this.getCell(i), (String)"Font").toDispatch();
        Dispatch.put((Object)dispatch, (String)"Bold", (Object)new Variant(font.isBold() ? 1 : 0));
        Dispatch.put((Object)dispatch, (String)"Italic", (Object)new Variant(font.isItalic() ? 1 : 0));
        Dispatch.put((Object)dispatch, (String)"Name", (Object)font.getFontName());
        Dispatch.put((Object)dispatch, (String)"Size", (Object)new Variant(d * (double)font.getSize()));
    }

    public void setCellHorizontalAlignment(int i, int j) {
        Dispatch dispatch = this.getCell(i);
        Dispatch.put((Object)dispatch, (String)"HorizontalAlignment", (Object)new Variant(j));
    }

    public int getCellHorizontalAlignment(int i, int j) {
        Dispatch dispatch = this.getCell(i, j);
        return Dispatch.get((Object)dispatch, (String)"HorizontalAlignment").toInt();
    }

    public void setColumnWidth(int i, double d) {
        Dispatch dispatch = this.getColumn(i);
        Dispatch.put((Object)dispatch, (String)"ColumnWidth", (Object)new Variant(d));
    }

    public void setValue(int i, Object obj) {
        this.setCellValue(this.curRow, i, obj);
    }

    public void setValue(String s, Object obj) {
        this.setCellValue(this.curRow, this.nameToIndex(s), obj);
    }

    public static boolean newExcelSheet(String s, String s1) {
        boolean flag = false;
        try {
            File file = new File(s);
            flag = file.isFile();
        }
        catch (Exception file) {
            // empty catch block
        }
        MSExcelApp msexcelapp = new MSExcelApp();
        if (msexcelapp.openExcel(s, s1, true, flag, true)) {
            try {
                msexcelapp.update();
                return true;
            }
            catch (Exception exception1) {
                return false;
            }
        }
        return false;
    }

    public static boolean isSheetExist(String s, String s1) {
        MSExcelApp msexcelapp = new MSExcelApp();
        boolean flag = msexcelapp.openExcel(s, s1, false);
        msexcelapp.close();
        return flag;
    }

    public static boolean deleteSheet(String s, String s1) {
        MSExcelApp msexcelapp = new MSExcelApp();
        if (msexcelapp.openExcel(s, s1, true) && msexcelapp.deleteSheet(s1)) {
            try {
                msexcelapp.postRow();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static String[] listSheetNames(String s) {
        MSExcelApp msexcelapp;
        if (MSExcelApp.isFileExist(s) && (msexcelapp = new MSExcelApp()).openExcel(s, null)) {
            String[] as = msexcelapp.getSheetNames();
            msexcelapp.close();
            return as;
        }
        return null;
    }

    public static void main(String[] args) {
        MSExcelApp msexcelapp = new MSExcelApp();
        if (msexcelapp.openExcel("c:\\1\\1.xls", "Sheet1")) {
            int i = msexcelapp.getRowCount();
            int j = msexcelapp.getColumnCount();
            msexcelapp.prepareFetchData();
            int k = 0;
            while (k < i) {
                msexcelapp.gotoRow(k);
                int l = 0;
                while (l < j) {
                    Object obj = msexcelapp.getValue(l);
                    System.out.print(obj + "/Align=" + msexcelapp.getCellHorizontalAlignment(k, l));
                    ++l;
                }
                System.out.println();
                ++k;
            }
            msexcelapp.endFetchData();
            msexcelapp.close();
        }
    }
}

