/*
 * Decompiled with CFR 0.152.
 */
package softcore.win;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import softcore.print.Print;
import softcore.util.ProgressBar;
import softcore.util.Utilities;
import softcore.win.MSWordApp;
import softface.MainApp;

public class PrintToWord {
    Print print;
    String wordFile;
    Rectangle m_pageRect;
    Vector wordCell;
    CSnWordTable wordTable;
    CLineTexts lineTexts;
    MSWordApp msWordApp;
    ActiveXComponent doc;
    Dispatch documents;
    Dispatch document;
    static int colExtWidth = 8;
    double fontScale = 0.7;
    Variant vOne;
    Variant vTrue;
    Variant vFalse;
    Variant vOpt;

    public PrintToWord(Print print1, String s) {
        this.print = print1;
        this.wordFile = s;
        this.wordCell = new Vector();
        this.m_pageRect = new Rectangle();
        this.wordTable = new CSnWordTable();
        this.lineTexts = new CLineTexts();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean genWordFile() throws Exception {
        if (this.wordFile == null || this.print == null || this.print.getNumberOfPages() == 0) {
            return false;
        }
        this.msWordApp = new MSWordApp(MainApp.isDebug);
        this.doc = this.msWordApp.getWordApp();
        this.documents = this.msWordApp.getDocuments();
        this.vOne = new Variant(1);
        this.vTrue = new Variant(true);
        this.vFalse = new Variant(false);
        this.vOpt = new Variant(-1);
        this.document = Dispatch.call((Object)this.documents, (String)"Add").toDispatch();
        ProgressBar progressbar = new ProgressBar("\u751f\u6210Word\u6587\u4ef6(\u5171" + this.print.getNumberOfPages() + "\u9875)", this.print.getNumberOfPages() * 2);
        try {
            int i = 0;
            while (i < this.print.getNumberOfPages()) {
                progressbar.setProgressText("\u7b2c" + (i + 1) + "\u9875");
                this.setPageIndex(i);
                progressbar.setProgressValue(2 * i + 1);
                this.genWordFilePage(i);
                progressbar.setProgressValue(2 * i + 2);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            progressbar.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
            progressbar.dispose();
        }
        Dispatch.call((Object)this.document, (String)"SaveAs", (Object)this.wordFile);
        if (!this.doc.getProperty("Visible").getBoolean()) {
            Dispatch.call((Object)this.document, (String)"Close");
        }
        return true;
    }

    public void genWordFilePage(int i) throws Exception {
        if (this.wordCell.size() == 0) {
            return;
        }
        if (i == 0) {
            Dispatch dispatch = Dispatch.get((Object)this.document, (String)"PageSetup").toDispatch();
            Dispatch.put((Object)dispatch, (String)"PageWidth", (Object)new Float(this.m_pageRect.width + colExtWidth * this.wordTable.getColCount() + 120));
            int j = this.m_pageRect.height;
            if (this.m_pageRect.height >= 400) {
                Dispatch.put((Object)dispatch, (String)"PageHeight", (Object)new Float(this.m_pageRect.height + 70));
            }
        }
        Dispatch dispatch1 = Dispatch.get((Object)this.doc, (String)"Selection").toDispatch();
        Dispatch dispatch2 = Dispatch.get((Object)dispatch1, (String)"Paragraphs").toDispatch();
        if (i > 0) {
            Dispatch.call((Object)dispatch1, (String)"InsertBreak", (Object)new Variant(7));
        }
        Object obj = null;
        int k = 0;
        while (k < this.lineTexts.lineTexts.size()) {
            CLineText clinetext = (CLineText)this.lineTexts.lineTexts.elementAt(k);
            if (clinetext.isAtHeader()) {
                Dispatch dispatch6 = Dispatch.get((Object)dispatch2, (String)"Last").toDispatch();
                clinetext.putIntoParagraph(dispatch6, dispatch1);
            }
            ++k;
        }
        if (this.wordTable.getRowCount() > 0 && this.wordTable.getColCount() > 0) {
            Dispatch dispatch3 = Dispatch.get((Object)dispatch2, (String)"Last").toDispatch();
            Dispatch.call((Object)dispatch1, (String)"TypeText", (Object)" ");
            Dispatch.call((Object)dispatch1, (String)"TypeParagraph");
            Dispatch dispatch4 = Dispatch.get((Object)dispatch1, (String)"Font").toDispatch();
            int l = 0;
            while (l < this.wordTable.getRowCount()) {
                int j1 = 0;
                while (j1 < this.wordTable.getColCount()) {
                    CSnWordCell csnwordcell = this.wordTable.getCell(l, j1);
                    if (csnwordcell != null && csnwordcell.getType() == 2) {
                        Print.TextCell textcell = (Print.TextCell)csnwordcell.cell;
                        Dispatch.put((Object)dispatch4, (String)"Color", (Object)new Variant(textcell.color.getRGB()));
                        Dispatch.put((Object)dispatch4, (String)"Bold", (Object)new Variant(textcell.font.isBold() ? 1 : 0));
                        Dispatch.put((Object)dispatch4, (String)"Italic", (Object)new Variant(textcell.font.isItalic() ? 1 : 0));
                        Dispatch.put((Object)dispatch4, (String)"Name", (Object)textcell.font.getFontName());
                        Dispatch.put((Object)dispatch4, (String)"Size", (Object)new Variant(this.fontScale * (double)textcell.font.getSize()));
                    }
                    ++j1;
                }
                ++l;
            }
            Dispatch dispatch7 = Dispatch.get((Object)dispatch3, (String)"Range").toDispatch();
            Dispatch dispatch10 = Dispatch.get((Object)dispatch7, (String)"Tables").toDispatch();
            Dispatch dispatch11 = Dispatch.call((Object)dispatch10, (String)"Add", (Object)dispatch7, (Object)new Variant(this.wordTable.getRowCount()), (Object)new Variant(this.wordTable.getColCount()), (Object)this.vTrue, (Object)this.vFalse).toDispatch();
            int k1 = 0;
            while (k1 < this.wordTable.getRowCount()) {
                int l1 = 0;
                while (l1 < this.wordTable.getColCount()) {
                    CSnWordCell csnwordcell1;
                    Dispatch dispatch12 = Dispatch.call((Object)dispatch11, (String)"Cell", (Object)new Variant(k1 + 1), (Object)new Variant(l1 + 1)).toDispatch();
                    if (k1 == 0) {
                        Dispatch dispatch13 = Dispatch.get((Object)dispatch12, (String)"Column").toDispatch();
                        Dispatch.put((Object)dispatch13, (String)"Width", (Object)new Float((double)(this.wordTable.getColWidth(l1) + colExtWidth) * this.fontScale));
                    }
                    if ((csnwordcell1 = this.wordTable.getCell(k1, l1)) != null) {
                        Dispatch dispatch16;
                        Dispatch dispatch8 = Dispatch.get((Object)dispatch12, (String)"Range").toDispatch();
                        if (csnwordcell1.getType() == 3) {
                            dispatch16 = Dispatch.get((Object)dispatch8, (String)"FormFields").toDispatch();
                            Dispatch.call((Object)dispatch16, (String)"Add", (Object)dispatch8, (Object)new Variant(71));
                            Dispatch dispatch19 = Dispatch.call((Object)dispatch16, (String)"Item", (Object)this.vOne).toDispatch();
                            Dispatch dispatch20 = Dispatch.get((Object)dispatch19, (String)"CheckBox").toDispatch();
                            Dispatch.put((Object)dispatch20, (String)"AutoSize", (Object)this.vFalse);
                            Dispatch.put((Object)dispatch20, (String)"Size", (Object)new Variant(10.0));
                            Dispatch.put((Object)dispatch20, (String)"Value", (Object)this.vTrue);
                        } else {
                            Dispatch.put((Object)dispatch8, (String)"Text", (Object)csnwordcell1.getText());
                            dispatch16 = Dispatch.get((Object)dispatch8, (String)"Font").toDispatch();
                        }
                        Dispatch dispatch17 = Dispatch.get((Object)dispatch8, (String)"Paragraphs").toDispatch();
                        int byte0 = 0;
                        if ((csnwordcell1.getFormat() & 0x1000) > 0) {
                            byte0 = 1;
                        } else if ((csnwordcell1.getFormat() & 0x2000) > 0) {
                            byte0 = 2;
                        }
                        Dispatch.put((Object)dispatch17, (String)"Alignment", (Object)new Variant(byte0));
                        if ((csnwordcell1.getFormat() & 0x4000) > 0) {
                            Dispatch.put((Object)dispatch12, (String)"VerticalAlignment", (Object)new Variant(1));
                        }
                    }
                    ++l1;
                }
                ++k1;
            }
            Rectangle rectangle = new Rectangle();
            int i2 = this.wordTable.getMergeNum() - 1;
            while (i2 >= 0) {
                this.wordTable.findMergeCell(i2, rectangle);
                if (rectangle.x != rectangle.width || rectangle.y != rectangle.height) {
                    Dispatch dispatch14 = Dispatch.call((Object)dispatch11, (String)"Cell", (Object)new Variant(rectangle.x + 1), (Object)new Variant(rectangle.y + 1)).toDispatch();
                    Dispatch dispatch18 = Dispatch.call((Object)dispatch11, (String)"Cell", (Object)new Variant(rectangle.width + 1), (Object)new Variant(rectangle.height + 1)).toDispatch();
                    Dispatch.call((Object)dispatch14, (String)"Merge", (Object)dispatch18);
                }
                --i2;
            }
            Dispatch dispatch15 = Dispatch.get((Object)dispatch11, (String)"Range").toDispatch();
            int j2 = Dispatch.get((Object)dispatch15, (String)"End").toInt();
            Dispatch.call((Object)dispatch1, (String)"SetRange", (Object)new Variant(j2 + 1), (Object)new Variant(j2 + 1));
        }
        int i1 = 0;
        while (i1 < this.lineTexts.lineTexts.size()) {
            CLineText clinetext1 = (CLineText)this.lineTexts.lineTexts.elementAt(i1);
            if (!clinetext1.isAtHeader()) {
                Dispatch dispatch9 = Dispatch.get((Object)dispatch2, (String)"Last").toDispatch();
                clinetext1.putIntoParagraph(dispatch9, dispatch1);
            }
            ++i1;
        }
        Dispatch.call((Object)dispatch1, (String)"TypeParagraph");
    }

    public void emptyPage() {
        this.wordCell.removeAllElements();
        this.m_pageRect.setBounds(0, 0, 0, 0);
        this.wordTable.empty();
        this.lineTexts.empty();
    }

    public void setPageIndex(int i) {
        this.emptyPage();
        Vector vector = this.print.getPages();
        if (i < 0 || i >= vector.size()) {
            return;
        }
        Print.Page page = (Print.Page)vector.elementAt(i);
        int j = 0;
        int k = 0;
        Enumeration enumeration = page.cellSet.elements();
        while (enumeration.hasMoreElements()) {
            Print.PrintCell printcell = (Print.PrintCell)enumeration.nextElement();
            CSnWordCell csnwordcell = new CSnWordCell(printcell);
            this.wordCell.addElement(csnwordcell);
            j = Math.max(j, csnwordcell.right());
            k = Math.max(k, csnwordcell.bottom());
        }
        this.m_pageRect.setBounds(0, 0, j, k);
        this.wordTable.fromCellList(this.wordCell);
        this.lineTexts.fromCellList(this.wordCell);
    }

    public void close() {
        this.emptyPage();
        if (this.msWordApp != null) {
            this.msWordApp.close();
        }
    }

    public static boolean printToWord(Print print1, String s) {
        if (s == null) {
            return false;
        }
        if (s.toLowerCase().indexOf(".doc") != s.length() - 4) {
            s = String.valueOf(s) + ".DOC";
        }
        PrintToWord printtoword = new PrintToWord(print1, s);
        boolean flag = false;
        try {
            flag = printtoword.genWordFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        printtoword.close();
        return flag;
    }

    class CLineText {
        Rectangle m_boundRect;
        Vector m_LineText = new Vector();

        public void empty() {
            this.m_LineText.removeAllElements();
        }

        void addCell(CSnWordCell csnwordcell) {
            boolean flag = false;
            int i = 0;
            while (i < this.m_LineText.size()) {
                CSnWordCell csnwordcell1 = (CSnWordCell)this.m_LineText.elementAt(i);
                if (csnwordcell.x() < csnwordcell1.x()) {
                    flag = true;
                    this.m_LineText.insertElementAt(csnwordcell, i);
                    break;
                }
                ++i;
            }
            if (!flag) {
                this.m_LineText.addElement(csnwordcell);
            }
            this.m_boundRect = this.m_boundRect.width == 0 ? new Rectangle(csnwordcell.cell) : this.m_boundRect.union(csnwordcell.cell);
        }

        boolean isCellInByPos(CSnWordCell csnwordcell) {
            if (csnwordcell != null) {
                return this.m_boundRect.width == 0 || Math.abs(this.m_boundRect.y - csnwordcell.y()) < 8 && Math.abs(this.m_boundRect.y + this.m_boundRect.height - csnwordcell.bottom()) < 8;
            }
            return false;
        }

        boolean isAtHeader() {
            if (this.m_LineText.size() > 0) {
                CSnWordCell csnwordcell = (CSnWordCell)this.m_LineText.elementAt(0);
                return csnwordcell.bAtHeader;
            }
            return false;
        }

        boolean isCellInLineText(CSnWordCell csnwordcell) {
            return this.m_LineText.contains(csnwordcell);
        }

        int getItemCount() {
            return this.m_LineText.size();
        }

        void putIntoParagraph(Dispatch dispatch, Dispatch dispatch1) {
            int i = 0;
            Dimension dimension = new Dimension();
            int j = 0;
            while (j < this.m_LineText.size()) {
                CSnWordCell csnwordcell = (CSnWordCell)this.m_LineText.elementAt(j);
                Print.TextCell textcell = (Print.TextCell)csnwordcell.cell;
                String s = textcell.font.getFontName();
                if (s == null) {
                    s = "\u5b8b\u4f53";
                }
                Dispatch dispatch2 = Dispatch.get((Object)dispatch1, (String)"Font").toDispatch();
                Dispatch.put((Object)dispatch2, (String)"Color", (Object)new Variant(textcell.color.getRGB()));
                Dispatch.put((Object)dispatch2, (String)"Bold", (Object)new Variant(textcell.font.isBold() ? 1 : 0));
                Dispatch.put((Object)dispatch2, (String)"Italic", (Object)new Variant(textcell.font.isItalic() ? 1 : 0));
                Dispatch.put((Object)dispatch2, (String)"Name", (Object)s);
                Dispatch.put((Object)dispatch2, (String)"Size", (Object)new Variant(PrintToWord.this.fontScale * (double)textcell.font.getSize()));
                int k = textcell.x - i;
                if (k < 0) {
                    k = 0;
                }
                Dimension dimension1 = csnwordcell.getStringWidHeg(textcell.text);
                int l = 0;
                int i1 = textcell.width - dimension1.width;
                i = csnwordcell.right() - i1;
                String s1 = csnwordcell.getSpaceMatchWid(k += l);
                Dispatch.call((Object)dispatch1, (String)"TypeText", (Object)(String.valueOf(s1) + textcell.text));
                ++j;
            }
            Dispatch.call((Object)dispatch1, (String)"TypeParagraph");
        }

        public CLineText() {
            this.m_boundRect = new Rectangle(0, 0, 0, 0);
        }
    }

    class CLineTexts {
        Vector lineTexts = new Vector();

        public void empty() {
            this.lineTexts.removeAllElements();
        }

        CLineText findLineTextByCellPos(CSnWordCell csnwordcell) {
            int i = 0;
            while (i < this.lineTexts.size()) {
                CLineText clinetext = (CLineText)this.lineTexts.elementAt(i);
                if (clinetext.isAtHeader() == csnwordcell.bAtHeader && clinetext.isCellInByPos(csnwordcell)) {
                    return clinetext;
                }
                ++i;
            }
            return null;
        }

        void fromCellList(Vector vector) {
            this.empty();
            if (vector == null) {
                return;
            }
            int i = 0;
            while (i < vector.size()) {
                CSnWordCell csnwordcell = (CSnWordCell)vector.elementAt(i);
                if (!csnwordcell.bInTable && csnwordcell.getType() == 2) {
                    CLineText clinetext = this.findLineTextByCellPos(csnwordcell);
                    if (clinetext == null) {
                        clinetext = new CLineText();
                        this.lineTexts.addElement(clinetext);
                    }
                    clinetext.addCell(csnwordcell);
                }
                ++i;
            }
        }
    }

    class CSnWordCell {
        Print.PrintCell cell;
        boolean bInTable;
        boolean bAtHeader;
        int row;
        int col;

        public int getType() {
            int byte0 = 0;
            if (this.cell instanceof Print.LineCell) {
                byte0 = 1;
            } else if (this.cell instanceof Print.TextCell) {
                byte0 = 2;
            } else if (this.cell instanceof Print.BoolCell) {
                byte0 = 3;
            }
            return byte0;
        }

        public int x() {
            return this.cell.x;
        }

        public int y() {
            return this.cell.y;
        }

        public int right() {
            return this.cell.x + this.cell.width;
        }

        public int bottom() {
            return this.cell.y + this.cell.height;
        }

        public int getFormat() {
            if (this.cell instanceof Print.TextCell) {
                return ((Print.TextCell)this.cell).format;
            }
            return 0;
        }

        public String getText() {
            if (this.cell instanceof Print.TextCell) {
                return ((Print.TextCell)this.cell).text;
            }
            return "";
        }

        public String getSpaceMatchWid(int i) {
            int j;
            String s = "";
            if (i <= 0) {
                return s;
            }
            Font font = this.cell instanceof Print.TextCell ? ((Print.TextCell)this.cell).font : null;
            FontMetrics fontmetrics = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(new BufferedImage(1, 1, 1)).getFontMetrics(font);
            while ((j = fontmetrics.stringWidth(s)) < i) {
                s = String.valueOf(s) + ' ';
            }
            return s;
        }

        public Dimension getStringWidHeg(String s) {
            if (s == null || s.length() == 0) {
                return new Dimension(0, 0);
            }
            Font font = this.cell instanceof Print.TextCell ? ((Print.TextCell)this.cell).font : null;
            FontMetrics fontmetrics = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(new BufferedImage(1, 1, 1)).getFontMetrics(font);
            int i = fontmetrics.stringWidth(s);
            int j = fontmetrics.getAscent();
            return new Dimension(i, j);
        }

        public CSnWordCell(Print.PrintCell printcell) {
            this.cell = printcell;
            this.col = -1;
            this.row = -1;
            this.bInTable = false;
        }
    }

    class CSnWordTable {
        Vector cellList = new Vector();
        int m_row;
        int m_col;
        int[] m_colPos;
        int[] m_rowPos;
        int mergNum;
        int[] mergCell;
        Dimension posDimension = new Dimension();
        Rectangle rect1 = new Rectangle();

        public void empty() {
            this.m_colPos = null;
            this.m_rowPos = null;
            this.mergCell = null;
        }

        public boolean isRectEmpty(Rectangle rectangle) {
            return rectangle == null || rectangle.width == 0 || rectangle.height == 0;
        }

        protected void finalize() throws Throwable {
            this.empty();
        }

        int getMergeNum() {
            return this.mergNum;
        }

        void findMergeCell(int i, Rectangle rectangle) {
            if (i >= 0 && i < this.mergNum) {
                int j = i * 4;
                rectangle.setBounds(this.mergCell[j], this.mergCell[j + 1], this.mergCell[j + 2], this.mergCell[j + 3]);
            }
        }

        boolean isRectInRect(Rectangle rectangle, Rectangle rectangle1) {
            if (rectangle == null || rectangle1 == null) {
                return false;
            }
            return rectangle.x <= rectangle1.x && rectangle.y <= rectangle1.y && rectangle.x + rectangle.width >= rectangle1.x + rectangle1.width && rectangle.y + rectangle.height >= rectangle1.y + rectangle1.height;
        }

        int getRowCount() {
            return this.m_row;
        }

        int getColCount() {
            return this.m_col;
        }

        int getColWidth(int i) {
            if (i >= 0 && i < this.m_col && this.m_colPos != null) {
                return this.m_colPos[i + 1] - this.m_colPos[i];
            }
            return -1;
        }

        int getRowHeight(int i) {
            if (i >= 0 && i < this.m_row && this.m_rowPos != null) {
                return this.m_rowPos[i + 1] - this.m_rowPos[i];
            }
            return -1;
        }

        void getTableRect(Rectangle rectangle) {
            if (this.m_row <= 0 || this.m_col <= 0) {
                rectangle.setBounds(0, 0, 0, 0);
            } else {
                rectangle.setBounds(this.m_colPos[0], this.m_rowPos[0], this.m_colPos[this.m_col] - this.m_colPos[0], this.m_rowPos[this.m_row] - this.m_rowPos[0]);
            }
        }

        void getCellIdByRect(Rectangle rectangle, Dimension dimension) {
            dimension.height = -1;
            dimension.width = -1;
            if (rectangle == null) {
                return;
            }
            int i = 0;
            while (i < this.m_row) {
                if (rectangle.y <= this.m_rowPos[i]) break;
                ++i;
            }
            int j = 0;
            while (j < this.m_col) {
                if (rectangle.x <= this.m_colPos[j]) break;
                ++j;
            }
            int k = i;
            while (k < this.m_row) {
                int l = j;
                while (l < this.m_col) {
                    this.getCellRect(k, l, this.rect1);
                    if (!this.isRectEmpty(this.rect1) && this.isRectInRect(this.rect1, rectangle)) {
                        dimension.width = k;
                        dimension.height = l;
                        return;
                    }
                    ++l;
                }
                ++k;
            }
        }

        void getCellRect(int i, int j, Rectangle rectangle) {
            rectangle.setBounds(0, 0, 0, 0);
            if (i < 0 || j < 0 || i > this.m_row || j > this.m_col) {
                return;
            }
            boolean flag = true;
            int k = 1;
            int l = 1;
            if (this.mergCell != null) {
                int i1 = 0;
                while (i1 < this.mergNum) {
                    int j1 = i1 * 4;
                    if (i == this.mergCell[j1] && j == this.mergCell[j1 + 1]) {
                        l = this.mergCell[j1 + 2] - this.mergCell[j1] + 1;
                        k = this.mergCell[j1 + 3] - this.mergCell[j1 + 1] + 1;
                        break;
                    }
                    if (i >= this.mergCell[j1] && i <= this.mergCell[j1 + 2] && j >= this.mergCell[j1 + 1] && j <= this.mergCell[j1 + 3]) {
                        flag = false;
                    }
                    ++i1;
                }
            }
            if (!flag) {
                rectangle.setBounds(0, 0, 0, 0);
            } else {
                rectangle.setBounds(this.m_colPos[j], this.m_rowPos[i], this.m_colPos[j + k] - this.m_colPos[j], this.m_rowPos[i + l] - this.m_rowPos[i]);
            }
        }

        CSnWordCell getCell(int i, int j) {
            if (this.cellList.size() == 0 || i < 0 || j < 0) {
                return null;
            }
            int k = 0;
            while (k < this.cellList.size()) {
                CSnWordCell csnwordcell = (CSnWordCell)this.cellList.elementAt(k);
                if (csnwordcell.getType() > 1 && csnwordcell.row == i && csnwordcell.col == j) {
                    return csnwordcell;
                }
                ++k;
            }
            return null;
        }

        boolean isLineInTable(CSnWordCell csnwordcell) {
            int i = csnwordcell.cell.width;
            int j = csnwordcell.cell.height;
            if (i != 0 && j != 0) {
                return false;
            }
            int k = Math.min(csnwordcell.x(), csnwordcell.right());
            int l = Math.max(csnwordcell.x(), csnwordcell.right());
            int i1 = Math.min(csnwordcell.y(), csnwordcell.bottom());
            int j1 = Math.max(csnwordcell.y(), csnwordcell.bottom());
            int k1 = 0;
            while (k1 < this.cellList.size()) {
                CSnWordCell csnwordcell1 = (CSnWordCell)this.cellList.elementAt(k1);
                if (csnwordcell1 != csnwordcell && csnwordcell1.getType() == 1) {
                    int l1 = csnwordcell1.cell.width;
                    int i2 = csnwordcell1.cell.height;
                    int j2 = Math.min(csnwordcell1.x(), csnwordcell1.right());
                    int k2 = Math.max(csnwordcell1.x(), csnwordcell1.right());
                    int l2 = Math.min(csnwordcell1.y(), csnwordcell1.bottom());
                    int i3 = Math.max(csnwordcell1.y(), csnwordcell1.bottom());
                    if (i == 0 && i2 == 0 ? i1 <= l2 && j1 >= l2 && k >= j2 && k <= k2 : j == 0 && l1 == 0 && k <= j2 && l >= j2 && i1 >= l2 && i1 <= i3) {
                        return true;
                    }
                }
                ++k1;
            }
            return false;
        }

        boolean lineExist(int i, int j, int k, int l) {
            int i1 = 0;
            while (i1 < this.cellList.size()) {
                CSnWordCell csnwordcell = (CSnWordCell)this.cellList.elementAt(i1);
                if (csnwordcell.getType() == 1 && (csnwordcell.x() == csnwordcell.right() && i == k && i == csnwordcell.x() ? j >= csnwordcell.y() && l <= csnwordcell.bottom() : csnwordcell.y() == csnwordcell.bottom() && j == l && j == csnwordcell.y() && i >= csnwordcell.x() && k <= csnwordcell.right())) {
                    return true;
                }
                ++i1;
            }
            return false;
        }

        void figureCellMerge(int i, int j, Dimension dimension) {
            dimension.height = 1;
            dimension.width = 1;
            if (!this.lineExist(this.m_colPos[j], this.m_rowPos[i], this.m_colPos[j], this.m_rowPos[i + 1])) {
                return;
            }
            if (!this.lineExist(this.m_colPos[j], this.m_rowPos[i], this.m_colPos[j + 1], this.m_rowPos[i])) {
                return;
            }
            int k = 0;
            k = i + 1;
            while (k < this.m_row) {
                if (this.lineExist(this.m_colPos[j], this.m_rowPos[k], this.m_colPos[j + 1], this.m_rowPos[k])) {
                    dimension.height = k - i;
                    break;
                }
                ++k;
            }
            if (k >= this.m_row) {
                dimension.height = this.m_row - i;
            }
            int l = 0;
            l = j + 1;
            while (l < this.m_col) {
                if (this.lineExist(this.m_colPos[l], this.m_rowPos[i], this.m_colPos[l], this.m_rowPos[i + 1])) {
                    dimension.width = l - j;
                    break;
                }
                ++l;
            }
            if (l >= this.m_col) {
                dimension.width = this.m_col - j;
            }
        }

        void fromCellList(Vector vector) {
            this.empty();
            this.cellList = vector;
            if (vector == null) {
                return;
            }
            this.m_col = 0;
            this.m_row = 0;
            int[] ai = new int[256];
            int[] ai1 = new int[256];
            int i = 0;
            while (i < ai.length) {
                ai1[i] = -1;
                ai[i] = -1;
                ++i;
            }
            int k1 = 0;
            while (k1 < vector.size()) {
                CSnWordCell csnwordcell = (CSnWordCell)vector.elementAt(k1);
                if (csnwordcell.getType() == 1 && this.isLineInTable(csnwordcell)) {
                    if (Utilities.findAtIntArray(ai1, csnwordcell.y()) < 0) {
                        ai1[this.m_row++] = csnwordcell.y();
                    }
                    if (Utilities.findAtIntArray(ai1, csnwordcell.bottom()) < 0) {
                        ai1[this.m_row++] = csnwordcell.bottom();
                    }
                    if (Utilities.findAtIntArray(ai, csnwordcell.x()) < 0) {
                        ai[this.m_col++] = csnwordcell.x();
                    }
                    if (Utilities.findAtIntArray(ai, csnwordcell.right()) < 0) {
                        ai[this.m_col++] = csnwordcell.right();
                    }
                }
                ++k1;
            }
            --this.m_col;
            --this.m_row;
            if (this.m_row <= 0 || this.m_col <= 0) {
                return;
            }
            this.m_colPos = new int[this.m_col + 1];
            int j = 0;
            while (j < this.m_col + 1) {
                this.m_colPos[j] = ai[j];
                ++j;
            }
            Utilities.sort(this.m_colPos, true);
            this.m_rowPos = new int[this.m_row + 1];
            int k = 0;
            while (k < this.m_row + 1) {
                this.m_rowPos[k] = ai1[k];
                ++k;
            }
            Utilities.sort(this.m_rowPos, true);
            Rectangle rectangle = new Rectangle();
            this.getTableRect(rectangle);
            Vector<Short> vector1 = new Vector<Short>();
            int l = 0;
            while (l < this.m_row) {
                int j1 = 0;
                while (j1 < this.m_col) {
                    this.figureCellMerge(l, j1, this.posDimension);
                    int i2 = this.posDimension.height;
                    int l1 = this.posDimension.width;
                    if (l1 > 1 || i2 > 1) {
                        vector1.addElement(new Short((short)l));
                        vector1.addElement(new Short((short)j1));
                        vector1.addElement(new Short((short)(l + i2 - 1)));
                        vector1.addElement(new Short((short)(j1 + l1 - 1)));
                    }
                    ++j1;
                }
                ++l;
            }
            this.mergNum = vector1.size();
            if (this.mergNum > 0) {
                this.mergCell = new int[this.mergNum];
                int i1 = 0;
                while (i1 < this.mergNum) {
                    this.mergCell[i1] = ((Number)vector1.elementAt(i1)).intValue();
                    ++i1;
                }
                this.mergNum /= 4;
            }
            vector1.removeAllElements();
            int j2 = 0;
            while (j2 < vector.size()) {
                CSnWordCell csnwordcell1 = (CSnWordCell)vector.elementAt(j2);
                if (csnwordcell1.getType() > 1) {
                    csnwordcell1.bInTable = this.isRectInRect(rectangle, csnwordcell1.cell);
                    boolean bl = csnwordcell1.bAtHeader = csnwordcell1.bottom() < rectangle.y;
                    if (csnwordcell1.bInTable) {
                        this.getCellIdByRect(csnwordcell1.cell, this.posDimension);
                        csnwordcell1.row = this.posDimension.width;
                        csnwordcell1.col = this.posDimension.height;
                    }
                }
                ++j2;
            }
        }
    }
}

