/*
 * Decompiled with CFR 0.152.
 */
package softcore.win;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.util.StringTokenizer;

public class WordOperBean {
    private ActiveXComponent MsWordApp = null;
    private Dispatch document = null;
    private String[] tags;
    private String[] values;

    public void openWord(boolean makeVisible) {
        if (this.MsWordApp == null) {
            this.MsWordApp = new ActiveXComponent("Word.Application");
        }
        Dispatch.put((Object)this.MsWordApp, (String)"Visible", (Object)new Variant(makeVisible));
    }

    public void openDocument(String pathStr) {
        Dispatch documents = this.MsWordApp.getProperty("Documents").toDispatch();
        this.document = Dispatch.invoke((Object)documents, (String)"Open", (int)1, (Object[])new Object[]{pathStr, new Variant(false), new Variant(true)}, (int[])new int[1]).toDispatch();
    }

    public void setTagsValues(String[] ParamTags, String[] ParamValues) {
        this.tags = ParamTags;
        this.values = ParamValues;
    }

    public void repalyTagsWithValues() {
        Dispatch selection = Dispatch.get((Object)this.MsWordApp, (String)"Selection").toDispatch();
        int v_count = this.values.length;
        int i = 0;
        while (i < v_count) {
            System.out.println("Tags[" + i + "] Value is :" + this.tags[i]);
            int wdWhat_wdGoToBookMark = -1;
            Variant What = new Variant(-1);
            boolean wdWhich_wdGoToNext = false;
            Variant Which = new Variant(0);
            boolean count = false;
            Variant Count = new Variant(0);
            Variant Name = new Variant(this.tags[i]);
            Object[] v = new Variant[]{What, Which, Count, Name};
            try {
                Dispatch.callN((Object)selection, (String)"GoTo", (Object[])v);
            }
            catch (Exception e) {
                System.out.println("Error: when replace tag \u6a21\u677f\u6587\u4ef6\u4e2d\u672a\u8bbe\u7f6etag: " + this.tags[i]);
            }
            if (this.values[i].indexOf("~") == -1) {
                Dispatch.call((Object)selection, (String)"TypeText", (Object)this.values[i]);
            } else {
                StringTokenizer str = new StringTokenizer(this.values[i], "~");
                while (str.hasMoreTokens()) {
                    Dispatch.call((Object)selection, (String)"TypeText", (Object)str.nextToken());
                    if (!str.hasMoreTokens()) continue;
                    Dispatch.call((Object)selection, (String)"TypeParagraph");
                }
            }
            ++i;
        }
    }

    public void createNewDocument() {
        Dispatch documents = Dispatch.get((Object)this.MsWordApp, (String)"Documents").toDispatch();
        this.document = Dispatch.call((Object)documents, (String)"Add").toDispatch();
    }

    public void insertText(String textToInsert) {
        Dispatch selection = Dispatch.get((Object)this.MsWordApp, (String)"Selection").toDispatch();
        Dispatch.put((Object)selection, (String)"Text", (Object)textToInsert);
    }

    public void saveFileAs(String filename) {
        Dispatch.call((Object)this.document, (String)"SaveAs", (Object)filename);
    }

    public void printFile() {
        Dispatch.call((Object)this.document, (String)"PrintOut");
    }

    public void closeDocument() {
        Dispatch.call((Object)this.document, (String)"Close", (Object)new Variant(0));
        this.document = null;
    }

    public void closeWord() {
        Dispatch.call((Object)this.MsWordApp, (String)"Quit");
        this.MsWordApp = null;
        this.document = null;
    }

    public static void main(String[] args) {
        WordOperBean wordApp = new WordOperBean();
        wordApp.openWord(true);
        System.out.println("\u8bbe\u7f6eWord\u5e94\u7528\u6253\u5f00\u6210\u529f");
        wordApp.openDocument("c:New.doc");
        String[] ptags = new String[]{"CompanyName", "YearStr", "UserName", "UpDate"};
        String[] pvalues = new String[]{"\u6c47\u4e45\u8f6f\u4ef6", "2007", "\u6c47\u4e45", "2007-10-19"};
        System.out.println("\u65b0\u5efaWord\u6587\u6863\u6210\u529f");
        wordApp.setTagsValues(ptags, pvalues);
        wordApp.repalyTagsWithValues();
        System.out.println("\u5728Word\u63d2\u5165\u6307\u5b9a\u5185\u5bb9\u6210\u529f");
    }
}

