/*
 * Decompiled with CFR 0.152.
 */
package softcore.yacc;

import java.io.IOException;
import java.io.Reader;
import softcore.util.PreprocessedTextReader;
import softcore.yacc.LexIdentifier;
import softcore.yacc.LexKeyWord;
import softcore.yacc.LexPunctuator;
import softcore.yacc.Null;
import softcore.yacc.Yacc;

public class LexTokenizer {
    private Reader inputStream;
    private boolean caseSensitive = true;
    private int lineNo = 1;
    private int c = 0;
    public LexKeyWord[] lexKeyWord;
    private boolean acodePrefix;
    public Object endToken;

    public Reader getInputStream() {
        return this.inputStream;
    }

    public final int getLineNo() {
        if (this.inputStream instanceof PreprocessedTextReader) {
            return ((PreprocessedTextReader)this.inputStream).getLineNo();
        }
        return this.lineNo;
    }

    public final void setCaseSensitive(boolean flag) {
        this.caseSensitive = flag;
    }

    public final boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public LexTokenizer() {
    }

    public LexTokenizer(Reader reader) {
        this.inputStream = reader;
    }

    public void setInputStream(Reader reader) {
        this.inputStream = reader;
        this.c = 0;
        this.lineNo = 1;
    }

    public int read() throws IOException {
        if (this.c == 0) {
            this.c = this.inputStream.read();
            if (this.c == 10) {
                ++this.lineNo;
            }
        }
        return this.c;
    }

    static boolean charInSet(int i, String s) {
        int j = s.length();
        int k = 0;
        while (k < j) {
            if (k < j - 1 && s.charAt(k + 1) == '-') {
                int c2;
                char c1 = s.charAt(k);
                int n = c2 = k + 2 >= j ? 256 : (int)s.charAt(k + 2);
                if (c1 <= i && i <= c2) {
                    return true;
                }
                k += 3;
                continue;
            }
            if (i != s.charAt(k++)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isIdentifierStart(char c1) {
        return Character.isJavaIdentifierStart(c1) || Character.isUnicodeIdentifierStart(c1);
    }

    public static final boolean isIdentifierPart(char c1) {
        return Character.isJavaIdentifierPart(c1) || Character.isUnicodeIdentifierPart(c1);
    }

    public String getWord(String s) throws IOException {
        StringBuffer stringbuffer = new StringBuffer();
        while (this.read() > 0 && (s != null && LexTokenizer.charInSet(this.c, s) || s == null && LexTokenizer.isIdentifierPart((char)this.c))) {
            stringbuffer.append((char)this.c);
            this.c = 0;
        }
        return new String(stringbuffer);
    }

    public void setAcodePrefix(boolean flag) {
        this.acodePrefix = flag;
    }

    protected String readString() throws IOException {
        if (this.read() != 34) {
            return null;
        }
        this.c = 0;
        StringBuffer stringbuffer = new StringBuffer(512);
        while (true) {
            if ((this.c = this.read()) == 34) {
                this.c = 0;
                break;
            }
            if (this.c == 92) {
                this.c = 0;
                this.read();
                switch (this.c) {
                    case 110: {
                        this.c = 10;
                        break;
                    }
                    case 114: {
                        this.c = 13;
                        break;
                    }
                    case 116: {
                        this.c = 9;
                    }
                }
            } else if (this.c == 10 || this.c == -1) break;
            stringbuffer.append((char)this.c);
            this.c = 0;
        }
        return new String(stringbuffer);
    }

    public Object getToken() throws IOException {
        while (this.read() != -1) {
            if (this.c >= 48 && this.c <= 57) {
                if (this.c == 48) {
                    this.c = 0;
                    this.read();
                    if (this.c == 120 || this.c == 88) {
                        this.c = 0;
                        String s = this.getWord("0-9a-fA-F");
                        return Integer.valueOf(s, 16);
                    }
                }
                String s1 = this.getWord("0-9");
                if (this.read() == 46) {
                    this.c = 0;
                    return Double.valueOf(String.valueOf(s1) + "." + this.getWord("0-9"));
                }
                return s1.length() != 0 ? Integer.valueOf(s1) : new Integer(0);
            }
            if (LexTokenizer.isIdentifierStart((char)this.c)) {
                LexKeyWord lexkeyword;
                String s2 = this.getWord(null);
                if (!this.caseSensitive) {
                    s2 = s2.toLowerCase();
                }
                if ((lexkeyword = LexKeyWord.find(this.lexKeyWord, s2)) != null) {
                    if (lexkeyword.token == 257) {
                        return new Integer(lexkeyword.keyValue);
                    }
                    return lexkeyword;
                }
                if (s2.equals("true")) {
                    return Boolean.TRUE;
                }
                if (s2.equals("false")) {
                    return Boolean.FALSE;
                }
                if (s2.equals("null")) {
                    return Null.NULL;
                }
                return new LexIdentifier(s2);
            }
            if (this.c == 34) {
                return this.readString();
            }
            if (this.c == 39) {
                this.c = 0;
                int c1 = this.read();
                this.c = 0;
                if (c1 == 39) {
                    return new Character('\u0000');
                }
                this.read();
                if (c1 == 92) {
                    char c2 = (char)this.c;
                    this.c = 0;
                    this.read();
                    switch (c2) {
                        case 'n': {
                            c1 = 10;
                            break;
                        }
                        case 'r': {
                            c1 = 13;
                            break;
                        }
                        case 't': {
                            c1 = 9;
                            break;
                        }
                        case '\'': {
                            c1 = 39;
                        }
                    }
                }
                if (this.c == 39) {
                    this.c = 0;
                    return new Character((char)c1);
                }
                return null;
            }
            if (this.c == 38 && this.acodePrefix) {
                LexPunctuator lexpunctuator = new LexPunctuator(38);
                this.c = 0;
                if (this.read() == 34) {
                    lexpunctuator.objectValue = this.readString();
                } else if (this.c >= 48 && this.c <= 57) {
                    lexpunctuator.objectValue = this.getWord("0-9");
                } else if (this.c == 38) {
                    this.c = 0;
                    lexpunctuator = new LexPunctuator(266);
                }
                return lexpunctuator;
            }
            int i = this.c;
            this.c = 0;
            if (i == 47) {
                this.read();
                if (this.c == 47) {
                    do {
                        this.c = 0;
                        this.read();
                    } while (this.c != 10 && this.c > 0);
                    this.c = 0;
                    continue;
                }
                if (this.c == 42) {
                    do {
                        this.c = 0;
                        if (this.read() != 42) continue;
                        this.c = 0;
                        if (this.read() == 47 || this.c <= 0) break;
                    } while (this.c > 0);
                    this.c = 0;
                    continue;
                }
            }
            if (i <= 32) continue;
            this.read();
            if (this.c > 32 && this.c < 127 && i < 127) {
                int j = i << 8 | this.c;
                int k = 0;
                while (k < Yacc.char2TokensMap.length - 1) {
                    if (Yacc.char2TokensMap[k] == j) {
                        this.c = 0;
                        return new LexPunctuator(Yacc.char2TokensMap[k + 1]);
                    }
                    k += 2;
                }
            }
            return new LexPunctuator(i);
        }
        Object obj = this.endToken;
        this.endToken = null;
        return obj;
    }
}

