/*
 * Decompiled with CFR 0.152.
 */
package softface.imagebutton;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class ToolBarExample
extends JPanel {
    public JTextPane pane;
    public JMenuBar menuBar;
    public JToolBar toolBar;
    String[] fonts = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};

    public ToolBarExample() {
        this.menuBar = new JMenuBar();
        DemoAction leftJustifyAction = new DemoAction("Left", new ImageIcon("left.gif"), "Left justify text", 'L');
        DemoAction rightJustifyAction = new DemoAction("Right", new ImageIcon("right.gif"), "Right justify text", 'R');
        DemoAction centerJustifyAction = new DemoAction("Center", new ImageIcon("center.gif"), "Center justify text", 'M');
        DemoAction fullJustifyAction = new DemoAction("Full", new ImageIcon("full.gif"), "Full justify text", 'F');
        JMenu formatMenu = new JMenu("Justify");
        formatMenu.add(leftJustifyAction);
        formatMenu.add(rightJustifyAction);
        formatMenu.add(centerJustifyAction);
        formatMenu.add(fullJustifyAction);
        this.menuBar.add(formatMenu);
        this.toolBar = new JToolBar("Formatting");
        this.toolBar.add(leftJustifyAction);
        this.toolBar.add(rightJustifyAction);
        this.toolBar.add(centerJustifyAction);
        this.toolBar.add(fullJustifyAction);
        this.toolBar.addSeparator();
        JLabel label = new JLabel("Font");
        this.toolBar.add(label);
        this.toolBar.addSeparator();
        JComboBox<String> combo = new JComboBox<String>(this.fonts);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ToolBarExample.this.pane.getStyledDocument().insertString(0, "Font [" + ((JComboBox)e.getSource()).getSelectedItem() + "] chosen!\n", null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.toolBar.add(combo);
        fullJustifyAction.setEnabled(false);
    }

    public static void main(String[] s) {
        ToolBarExample example = new ToolBarExample();
        example.pane = new JTextPane();
        example.pane.setPreferredSize(new Dimension(250, 250));
        example.pane.setBorder(new BevelBorder(1));
        example.toolBar.setMaximumSize(example.toolBar.getSize());
        JFrame frame = new JFrame("Menu Example");
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(example.menuBar);
        frame.getContentPane().add((Component)example.toolBar, "North");
        frame.getContentPane().add((Component)example.pane, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    class DemoAction
    extends AbstractAction {
        public DemoAction(String text, Icon icon, String description, char accelerator) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("ShortDescription", description);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ToolBarExample.this.pane.getStyledDocument().insertString(0, "Action [" + this.getValue("Name") + "] performed!\n", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

