/*
 * Decompiled with CFR 0.152.
 */
package softface.mdi;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import softface.mdi.JMDIFrame;

public class JMDIMenuBar
extends JMenuBar
implements ComponentListener,
ActionListener {
    public JButton closeButton = new JButton(MetalIconFactory.getInternalFrameCloseIcon(16));
    public JButton resizeButton = null;
    public JButton iconifyButton = null;
    JMDIFrame activeFrame = null;
    boolean isMaximized = false;
    int closeCount = 0;

    public JMDIMenuBar() {
        this.closeButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.resizeButton = new JButton(MetalIconFactory.getInternalFrameAltMaximizeIcon(16));
        this.resizeButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.iconifyButton = new JButton(MetalIconFactory.getInternalFrameMinimizeIcon(16));
        this.iconifyButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.addComponentListener(this);
    }

    public void componentHidden(ComponentEvent componentevent) {
    }

    public void componentMoved(ComponentEvent componentevent) {
    }

    public void componentResized(ComponentEvent componentevent) {
        if (this.getParent() != null && this.closeButton != null) {
            this.closeButton.setBounds(this.getParent().getWidth() - 16 - 2, (this.getHeight() - 16) / 2, 16, 16);
        }
        if (this.getParent() != null && this.closeButton != null) {
            this.resizeButton.setBounds(this.getParent().getWidth() - 32 - 6, (this.getHeight() - 16) / 2, 16, 16);
        }
        if (this.getParent() != null && this.closeButton != null) {
            this.iconifyButton.setBounds(this.getParent().getWidth() - 48 - 6, (this.getHeight() - 16) / 2, 16, 16);
        }
    }

    public void removeFrameButtons() {
        this.isMaximized = false;
        this.activeFrame = null;
        this.closeButton.removeActionListener(this);
        this.resizeButton.removeActionListener(this);
        this.iconifyButton.removeActionListener(this);
        this.remove(this.closeButton);
        this.remove(this.resizeButton);
        this.remove(this.iconifyButton);
        this.update(this.getGraphics());
    }

    public void setMaximizedFrame(JMDIFrame jmdiframe) {
        if (jmdiframe == null) {
            this.removeFrameButtons();
        } else {
            if (!this.isMaximized) {
                this.resizeButton.addActionListener(this);
                this.iconifyButton.addActionListener(this);
                this.closeButton.addActionListener(this);
                this.add(this.iconifyButton);
                this.add(this.resizeButton);
                this.add(this.closeButton);
                this.restoreButtonsPosition();
                this.update(this.getGraphics());
            }
            this.activeFrame = jmdiframe;
            this.isMaximized = true;
        }
    }

    public JMDIFrame getMaximizedFrame() {
        return this.activeFrame;
    }

    public void componentShown(ComponentEvent componentevent) {
    }

    public void paint(Graphics g) {
        this.componentResized(null);
        super.paint(g);
    }

    public void actionPerformed(ActionEvent actionevent) {
        ++this.closeCount;
        if (actionevent.getSource() == this.resizeButton) {
            if (this.activeFrame != null) {
                try {
                    this.activeFrame.setMaximum(false);
                    this.activeFrame.getDesktopPane().getDesktopManager().activateFrame(this.activeFrame);
                }
                catch (Exception exception) {}
            }
        } else if (actionevent.getSource() == this.iconifyButton) {
            if (this.activeFrame != null) {
                try {
                    this.activeFrame.setIcon(true);
                }
                catch (Exception exception) {}
            }
        } else if (actionevent.getSource() == this.closeButton && this.activeFrame != null) {
            try {
                JMDIFrame jmdiframe = this.activeFrame;
                int i = this.activeFrame.getDesktopPane().getAllFrames().length;
                jmdiframe.doDefaultCloseAction();
                if (jmdiframe.isClosed() && i <= 0) {
                    this.removeFrameButtons();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void restoreButtonsPosition() {
        this.componentResized(null);
    }
}

