/*
 * Decompiled with CFR 0.152.
 */
package softface.theme;

import java.io.File;
import javax.swing.UIManager;
import softface.theme.Log;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java14;

    static {
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            String s = System.getProperty("os.name");
            if (s.indexOf("Windows 9") != -1 || s.indexOf("Windows M") != -1) {
                os = 1600;
            } else if (s.indexOf("Windows") != -1) {
                os = 1638;
            } else if (s.indexOf("OS/2") != -1) {
                os = 57005;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else {
                os = 2989;
                Log.printWarning("Unknown operating system: " + s);
            }
        }
        if (System.getProperty("java.version").compareTo("1.4") >= 0 && System.getProperty("jedit.nojava14") == null) {
            java14 = true;
        }
    }

    public static final boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static final boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static final boolean isWindows9x() {
        return os == 1600;
    }

    public static final boolean isWindowsNT() {
        return os == 1638;
    }

    public static final boolean isOS2() {
        return os == 57005;
    }

    public static final boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static final boolean isMacOS() {
        return os == 2748;
    }

    public static final boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static final boolean hasJava14() {
        return java14;
    }
}

