/*
 * Decompiled with CFR 0.152.
 */
package softface.theme;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import softface.theme.Log;
import softface.theme.OperatingSystem;

public class Utils {
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static final MediaTracker mediaTracker = new MediaTracker(new JLabel(""));
    private static Hashtable decodeHashtable;
    private static final String[][] decodeArray;
    static /* synthetic */ Class class$0;

    static {
        decodeArray = new String[][]{{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"}, {"&", "<", ">", "'", "\""}};
        decodeHashtable = new Hashtable();
        int i = 0;
        while (i < decodeArray[0].length) {
            decodeHashtable.put(decodeArray[0][i], decodeArray[1][i]);
            ++i;
        }
    }

    public static Document parseXML(InputStream inputstream) throws Exception {
        return Utils.parseXML(inputstream, null);
    }

    public static Document parseXML(InputStream inputstream, String s) throws Exception {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        DocumentBuilder documentbuilder = documentBuilderFactory.newDocumentBuilder();
        documentbuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String s1, String s2) {
                if (s2.toLowerCase().endsWith(".dtd")) {
                    String s3 = "<?xml version='1.0' encoding='UTF-8'?>";
                    return new InputSource(new StringReader(s3));
                }
                return null;
            }
        });
        InputStreamReader inputstreamreader = null;
        inputstreamreader = s != null ? new InputStreamReader(inputstream, s) : new InputStreamReader(inputstream);
        InputSource inputsource = new InputSource(new BufferedReader(inputstreamreader));
        return documentbuilder.parse(inputsource);
    }

    public static String getAttr(Element element, String s) {
        Attr attr = element.getAttributeNode(s);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getValue(Node node) {
        return Utils.getValue(node, false);
    }

    public static String getValue(Node node, boolean flag) {
        String s = "";
        NodeList nodelist = node.getChildNodes();
        int i = nodelist.getLength();
        int j = 0;
        while (j < i) {
            String s2;
            String s3;
            Node node1 = nodelist.item(j);
            short word0 = node1.getNodeType();
            if (word0 == 4) {
                s = node1.getNodeValue();
                break;
            }
            if (word0 == 3) {
                String s1 = node1.getNodeValue();
                if (s1.trim().length() > 0) {
                    s = flag ? String.valueOf(s) + s1 : s1;
                }
            } else if (word0 == 5 && (s3 = (String)decodeHashtable.get(s2 = "&" + node1.getNodeName() + ";")) != null) {
                s = flag ? String.valueOf(s) + s3 : s3;
            }
            ++j;
        }
        while (s.startsWith("\n")) {
            s = s.substring(1);
        }
        while (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        if (!s.equals("")) {
            return s;
        }
        return null;
    }

    public static String[] parseCommandParameters(String s) {
        if (s == null || s.length() <= 0) {
            return new String[0];
        }
        String[] as = Utils.splitString(s, " ");
        return as;
    }

    public static String doubleToString(double d) {
        return Utils.convertNumberStringToString(Double.toString(d));
    }

    public static String objectToString(Object obj) {
        if (obj instanceof Number) {
            return Utils.convertNumberStringToString(obj.toString());
        }
        return obj.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String convertNumberStringToString(String s) {
        block14: {
            block16: {
                block15: {
                    i = s.indexOf(46);
                    if (i < 0) {
                        return s;
                    }
                    j = s.indexOf(69);
                    if (i != 1 || j <= 0) break block14;
                    s1 = s.substring(0, j);
                    stringbuffer = new StringBuffer(s1.substring(2));
                    stringbuffer.insert(0, s1.charAt(0));
                    l = Integer.parseInt(s.substring(j + 1));
                    if (l > 0) break block15;
                    if (stringbuffer.charAt(stringbuffer.length() - 1) == '0') {
                        stringbuffer.deleteCharAt(stringbuffer.length() - 1);
                    }
                    i1 = 0;
                    while (i1 < -l) {
                        stringbuffer.insert(0, "0");
                        ++i1;
                    }
                    stringbuffer.insert(1, ".");
                    break block16;
                }
                if (stringbuffer.length() <= l + 1) ** GOTO lbl31
                stringbuffer.insert(l + 1, '.');
                break block16;
lbl-1000:
                // 1 sources

                {
                    stringbuffer.append("0");
lbl31:
                    // 2 sources

                    ** while (stringbuffer.length() < l + 1)
                }
            }
            return stringbuffer.toString();
        }
        s2 = s.substring(i + 1);
        k = s2.indexOf("9999");
        if (k >= 0) {
            d = Double.parseDouble(s);
            if (k == 0) {
                return Long.toString(Math.round(d));
            }
            if (Math.abs(d) > 9.223372036854776E18) {
                s3 = Double.toString(d);
                j1 = s3.indexOf(".");
                if (j1 > 0 && s3.length() - j1 - 1 > k) {
                    s3 = s3.substring(0, j1 + k + 1);
                }
                if (s3.endsWith(".0")) {
                    return s3.substring(0, s3.length() - 2);
                }
                return s3;
            }
            s4 = d >= 0.0 ? "" : "-";
            l1 = (long)Math.pow(10.0, k - 1);
            l2 = l1 * 10L;
            d = Math.abs(d);
            l3 = Math.round(d * (double)l2);
            s5 = String.valueOf(s4) + Long.toString(l3 / l2);
            v0 = l4 = l2 != 0L ? l3 % l2 : 0L;
            if (l4 == 0L) {
                stringbuffer1 = new StringBuffer("");
                k1 = k;
                while (k1 > 0) {
                    stringbuffer1.insert(0, "0");
                    --k1;
                }
                return String.valueOf(s5) + "." + stringbuffer1;
            }
            stringbuffer2 = new StringBuffer(Long.toString(l4));
            while (l4 < l1) {
                l4 *= 10L;
                stringbuffer2.insert(0, "0");
            }
            return String.valueOf(s5) + "." + stringbuffer2;
        }
        k = s2.indexOf("0000");
        if (k >= 0) {
            s = s.substring(0, i + Math.max(k, 1) + 1);
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public static Color getXORColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static String combineString(String[] as, String s) {
        if (as == null || as.length <= 0) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < as.length - 1) {
            stringbuffer.append(as[i]);
            stringbuffer.append(s);
            ++i;
        }
        stringbuffer.append(as[as.length - 1]);
        return stringbuffer.toString();
    }

    public static String[] splitString(String s, char c) {
        return Utils.splitString(s, "" + c);
    }

    public static String[] splitString(String s, String s1) {
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arraylist = new ArrayList<String>();
        int i = -1;
        while ((i = s.indexOf(s1)) >= 0) {
            arraylist.add(s.substring(0, i));
            s = s.substring(i + s1.length());
        }
        arraylist.add(s);
        String[] as = new String[arraylist.size()];
        arraylist.toArray(as);
        return as;
    }

    public static String replaceAllString(String s, String s1, String s2) {
        int i;
        if (s == null || s.length() <= 0) {
            return s;
        }
        StringBuffer stringbuffer = new StringBuffer();
        while ((i = s.indexOf(s1)) >= 0) {
            stringbuffer.append(s.substring(0, i));
            stringbuffer.append(s2);
            s = s.substring(i + s1.length());
        }
        stringbuffer.append(s);
        return stringbuffer.toString();
    }

    public static StringBuffer replaceAllStringBuffer(StringBuffer stringbuffer, String s, String s1) {
        int i;
        if (stringbuffer == null || stringbuffer.length() <= 0) {
            return stringbuffer;
        }
        String s2 = stringbuffer.toString();
        StringBuffer stringbuffer1 = new StringBuffer();
        while ((i = s2.indexOf(s)) >= 0) {
            stringbuffer1.append(s2.substring(0, i));
            stringbuffer1.append(s1);
            s2 = s2.substring(i + s.length());
        }
        stringbuffer1.append(s2);
        return stringbuffer1;
    }

    public static void copyBinaryTo(File file, OutputStream outputstream) throws IOException {
        Utils.copyBinaryTo(new FileInputStream(file), outputstream);
    }

    public static void copyBinaryTo(InputStream inputstream, OutputStream outputstream) throws IOException {
        int i;
        byte[] abyte0 = new byte[5120];
        while ((i = inputstream.read(abyte0)) >= 0) {
            outputstream.write(abyte0, 0, i);
        }
        outputstream.flush();
        outputstream.close();
        inputstream.close();
    }

    private static void copyCharTo(Reader reader, Writer writer) throws IOException {
        BufferedReader bufferedreader = new BufferedReader(reader);
        PrintWriter printwriter = new PrintWriter(writer);
        String s = null;
        while ((s = bufferedreader.readLine()) != null) {
            printwriter.println(s);
        }
        printwriter.flush();
        printwriter.close();
        bufferedreader.close();
    }

    public static void copyCharFile(Reader reader, File file) throws IOException {
        Utils.copyCharTo(reader, new FileWriter(file));
    }

    public static void copyCharFile(File file, File file1) throws IOException {
        Utils.copyCharFile(new FileReader(file), file1);
    }

    public static InputStream createInputStream(String s) throws IOException {
        return Utils.createInputStream(s, null);
    }

    public static InputStream createInputStream(String s, String s1) throws IOException {
        File file1;
        if (s == null || s.length() <= 0) {
            return null;
        }
        File file = new File(s);
        if (file.exists()) {
            return new FileInputStream(s);
        }
        InputStream inputstream = null;
        if (s.startsWith("/")) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("softface.theme.Utils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            inputstream = clazz.getResourceAsStream(s);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("softface.theme.Utils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            inputstream = clazz.getResourceAsStream("/" + file.getName());
        }
        if (inputstream != null) {
            return inputstream;
        }
        if (s1 != null && (file1 = s.startsWith(File.separator) ? new File(String.valueOf(s1) + s) : new File(String.valueOf(s1) + File.separator + s)).exists()) {
            return new FileInputStream(file1);
        }
        return null;
    }

    public static Image readImage(String s) {
        InputStream inputstream;
        block3: {
            try {
                inputstream = Utils.createInputStream(s);
                if (inputstream != null) break block3;
                return null;
            }
            catch (IOException ioexception) {
                Log.printError(ioexception);
                return null;
            }
        }
        return Utils.readImage(inputstream);
    }

    public static Image readImage(InputStream inputstream) {
        try {
            int i;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            byte[] abyte0 = new byte[5120];
            while ((i = inputstream.read(abyte0)) >= 0) {
                bytearrayoutputstream.write(abyte0, 0, i);
            }
            return Toolkit.getDefaultToolkit().createImage(bytearrayoutputstream.toByteArray());
        }
        catch (Exception exception) {
            Log.printError(exception);
            return null;
        }
    }

    public static void waitForImage(Image image) {
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            Log.printError(exception);
        }
        mediaTracker.removeImage(image);
    }

    public static int[] grabImagePixelsArray(Image image, int i, int j) {
        int[] ai = new int[i * j];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, i, j, ai, 0, i);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException interruptedexception) {
            Log.printError(interruptedexception);
        }
        return ai;
    }

    public static byte[] convertImageToByteArray(Image image) {
        Utils.waitForImage(image);
        int i = image.getWidth(null);
        int j = image.getHeight(null);
        int[] ai = Utils.grabImagePixelsArray(image, i, j);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        int k = 0;
        while (k < ai.length) {
            int l = ai[k];
            bytearrayoutputstream.write((byte)((l & 0xFF0000) >> 16));
            bytearrayoutputstream.write((byte)((l & 0xFF00) >> 8));
            bytearrayoutputstream.write((byte)(l & 0xFF));
            bytearrayoutputstream.write((byte)((l & 0xFF000000) >> 24));
            ++k;
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static boolean mkdirs(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String javaColorToHTMLColor(Color color) {
        return Integer.toString(color.getRGB() & 0xFFFFFF, 16);
    }

    public static boolean checkFileNameValid(String s) {
        return s.indexOf("\"") == -1 && s.indexOf("'") == -1 && s.indexOf("[") == -1 && s.indexOf("]") == -1 && s.indexOf("\\") == -1 && s.indexOf("/") == -1 && s.indexOf(":") == -1 && s.indexOf("*") == -1 && s.indexOf("?") == -1 && s.indexOf("<") == -1 && s.indexOf(">") == -1 && s.indexOf("|") == -1;
    }

    public static String getInvalidFileNameCharactor() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("\"");
        stringbuffer.append(" ");
        stringbuffer.append("\\");
        stringbuffer.append(" ");
        stringbuffer.append("/");
        stringbuffer.append(" ");
        stringbuffer.append(":");
        stringbuffer.append(" ");
        stringbuffer.append("*");
        stringbuffer.append(" ");
        stringbuffer.append("?");
        stringbuffer.append(" ");
        stringbuffer.append("<");
        stringbuffer.append(" ");
        stringbuffer.append(">");
        stringbuffer.append(" ");
        stringbuffer.append("|");
        return stringbuffer.toString();
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] afile = file.listFiles();
            int i = 0;
            while (i < afile.length) {
                if (!Utils.deleteFile(afile[i])) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    public static String createWhiteSpaceString(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            stringbuffer.append(" ");
            ++j;
        }
        return stringbuffer.toString();
    }

    public static File analyzeURLtoCreateFile(URL url) {
        if (url == null) {
            return null;
        }
        String s = url.toString();
        if (s.startsWith("jar:file:")) {
            int i = s.indexOf("!");
            if (i != -1 && i > 11) {
                if (OperatingSystem.isWindows()) {
                    return new File(s.substring(10, i));
                }
                return new File(s.substring(9, i));
            }
        } else if (s.startsWith("file:")) {
            if (OperatingSystem.isWindows()) {
                return new File(s.substring(6));
            }
            return new File(s.substring(5));
        }
        return null;
    }

    public static Method getDeclaredMethod(Class class1, String s, Class[] aclass) {
        try {
            return class1.getDeclaredMethod(s, aclass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            class1 = class1.getSuperclass();
            if (class1 != null) {
                return Utils.getDeclaredMethod(class1, s, aclass);
            }
            return null;
        }
    }

    public static Field getDeclaredField(Class class1, String s) {
        try {
            return class1.getDeclaredField(s);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            class1 = class1.getSuperclass();
            if (class1 != null) {
                return Utils.getDeclaredField(class1, s);
            }
            return null;
        }
    }

    public static String xmlAttrEncode(String s) {
        return Utils.encodeString(s, decodeArray);
    }

    public static String htmlEncode(String s) {
        return Utils.encodeString(s, new String[][]{{"&nbsp;", "&amp;", "&lt;", "&gt;", "&apos;", "&quot;"}, {" ", "&", "<", ">", "'", "\""}});
    }

    public static String javascriptEncode(String s) {
        return Utils.encodeString(s, new String[][]{{"\\\\", "\\'", "\\\""}, {"\\", "'", "\""}});
    }

    private static String encodeString(String s, String[][] as) {
        if (s == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            block4: {
                char c = s.charAt(i);
                int j = 0;
                while (j < as[1].length) {
                    if (c == as[1][j].charAt(0)) {
                        stringbuffer.append(as[0][j]);
                        break block4;
                    }
                    ++j;
                }
                stringbuffer.append(c);
            }
            ++i;
        }
        return stringbuffer.toString();
    }
}

