/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import softcore.awt.DialogPanel;
import softcore.table.GridTable;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.tac.Tac;
import softcore.util.AidInputer;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpRowFilter;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;
import softoperation.finance.erpdata.TableYearMonthCellDataAccess;

public class ErpACodeTable
extends GridTable {
    private String acodePtn = null;
    private boolean bQuery;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] acodeLevl;
    private Variant variant = new Variant();
    private int levl;
    private int levlDataType;
    private Hashtable codeHash;
    TableColumn acodeColumn;
    private String oldACode = "";
    public static String[] propCaption = new String[]{"\u94f6\u884c", "\u5916\u5e01", "\u6570\u91cf", "\u5f80\u6765", "\u5916\u5e01\u5f80\u6765", "\u5ba2\u6237", "\u5546\u54c1", "\u5e93\u5b58", "\u5408\u540c", "\u53d1\u7968", "\u65e5\u671f", "\u56fd\u522b", "\u5916\u5e01\u94f6\u884c", "\u73b0\u91d1", "DCODE", "ECODE", "\u4ed3\u5e93"};
    public static char[] propChar;

    static {
        char[] cArray = new char[17];
        cArray[8] = 104;
        cArray[9] = 105;
        cArray[11] = 110;
        cArray[14] = 100;
        cArray[15] = 101;
        cArray[16] = 115;
        propChar = cArray;
    }

    public ErpACodeTable(String s, boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u79d1\u76ee\uff1f");
        if (!flag) {
            try {
                this.acodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 8 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 1) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 1) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select acode from balance group by acode order by acode", "select acode from ivoucher group by acode order by acode"}, 0, -1, this.acodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.acodePtn = s;
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public static final String getParentUsedCode(DataSet dataset, Hashtable hashtable, String s, Object[] aobj, int i) {
        if (dataset == null || hashtable == null || s == null || aobj == null || i <= 1) {
            return null;
        }
        String s1 = s;
        --i;
        while (i > 0) {
            int j;
            int n = j = aobj[i] instanceof Number ? ((Number)aobj[i]).intValue() : 0;
            if (j > 0) {
                s1 = s1.substring(0, s1.length() - j);
                try {
                    String s2;
                    if (Utilities.seekDataSet(dataset, s1) && (s2 = (String)hashtable.get(s1)) != null && s2.length() <= 0) {
                        return s1;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(Message.out);
                }
            }
            --i;
        }
        return null;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldACode = this.dataSet.getString("acode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldACode = this.dataSet.getString("acode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldACode.length() > 0 && this.codeHash.get(this.oldACode) != null;
        this.setRwFlags(32, flag1);
        if (this.acodeColumn != null) {
            this.acodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",aname,type,dc,blevl,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0 || atablecolumn[i].cellId.startsWith("property")) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("acode")) {
            try {
                String s = dataset.getString("acode");
                int i = s.length();
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.acodeLevl, i, true) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void find() {
        ErpPubl.find(this, "acode");
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u79d1\u76ee");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u79d1\u76ee");
            this.addLoged = true;
        }
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("acode");
            if (this.levl < 0) {
                s = String.valueOf(s) + "\u79d1\u76ee\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldACode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('a');
                if (Utilities.seekDataSet(dataset, "acode", s1)) {
                    s = String.valueOf(s) + "\u79d1\u76ee\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.acodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u79d1\u76ee" + s2 + "\u7684\u5b50\u76ee\uff01\n";
                }
            }
            this.dataSet.getVariant("property", this.variant);
            int i = this.variant.getAsInt();
            if ((i & 0x1000) != 0 && ((i & 1) == 0 || (i & 2) == 0)) {
                s = String.valueOf(s) + "\u5177\u6709\u201c\u5916\u5e01\u94f6\u884c\u201d\u5c5e\u6027\u5fc5\u987b\u540c\u65f6\u5b9a\u4e49\u201c\u5916\u5e01\u201d\u548c\u201c\u94f6\u884c\u201d\u5c5e\u6027\uff01\n";
            }
            if ((i & 0x10) != 0 && ((i & 8) == 0 || (i & 2) == 0)) {
                s = String.valueOf(s) + "\u5177\u6709\u201c\u5916\u5e01\u5f80\u6765\u201d\u5c5e\u6027\u5fc5\u987b\u540c\u65f6\u5b9a\u4e49\u201c\u5916\u5e01\u201d\u548c\u201c\u5f80\u6765\u201d\u5c5e\u6027\uff01\n";
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static void setColumnOption(Table table, String s, char c) {
        TableColumn tablecolumn = table.getColumn(s);
        if (tablecolumn == null) {
            return;
        }
        String s1 = ErpConfig.getCodeTitle(c);
        if (s1 == null) {
            tablecolumn.setOptions(1, true);
        } else {
            tablecolumn.displayCaption = s1;
        }
    }

    public static final void setupACode(boolean flag, String s) throws DataSetException, SQLException {
        ErpACodeTable snaacodetable = new ErpACodeTable(s, flag);
        snaacodetable.setDatasetTablename("acode");
        snaacodetable.setLeftFixedColumns(2);
        snaacodetable.addColumns(new String[]{"acode", "aname", "type", "dc", "blevl"}, new String[]{"\u79d1\u76ee\u7801", "\u79d1\u76ee\u540d", "\u7c7b\u522b", "\u65b9\u5411", "\u90e8\u95e8"});
        int i = MainApp.getAppPropertyAsInt("SNA.ACODEPROPMASK", 2);
        int j = 0;
        while (j < propCaption.length) {
            if ((i & 1 << j) == 0) {
                snaacodetable.addColumn(new TableColumn("property#" + j, propCaption[j]));
            }
            ++j;
        }
        snaacodetable.addColumns(new String[]{"vdclimit", "shortcode"}, new String[]{"\u53d1\u751f\u65b9\u5411", "\u7b80\u7801"});
        TableColumn tablecolumn = snaacodetable.getColumn("acode");
        tablecolumn.setOptions(0x308000, true);
        snaacodetable.acodeColumn = tablecolumn;
        tablecolumn.setDisplayWidth(96);
        tablecolumn = snaacodetable.getColumn("aname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(192);
        tablecolumn = snaacodetable.getColumn("type");
        tablecolumn.setDisplayWidth(48);
        tablecolumn.setOptions(32776, true);
        tablecolumn.createShortStringMap(new short[]{1, 2, 3, 4, 5, 6}, new String[]{"\u8d44\u4ea7", "\u8d1f\u503a", "\u5171\u540c", "\u6743\u76ca", "\u6210\u672c", "\u635f\u76ca"});
        tablecolumn = snaacodetable.getColumn("dc");
        tablecolumn.setDisplayWidth(24);
        tablecolumn.setOptions(32776, true);
        tablecolumn.createShortStringMap(new short[]{1, -1}, new String[]{"\u501f", "\u8d37"});
        tablecolumn = snaacodetable.getColumn("blevl");
        tablecolumn.setDisplayWidth(32);
        tablecolumn.setOptions(8, true);
        int k = 0;
        Object obj = JDBC.sqlSelect1(null, "SELECT max(levlid) FROM codelevl WHERE (tblid=9) and (codelen is not null) and (codelen<>0)");
        if (obj != null) {
            k = ((Number)obj).intValue();
        }
        if (k > 0) {
            short[] aword0 = new short[k + 1];
            String[] as = new String[k + 1];
            aword0[0] = 0;
            as[0] = null;
            int j1 = 1;
            while (j1 < k + 1) {
                aword0[j1] = (short)j1;
                as[j1] = ErpPubl.levlPtn[j1 - 1];
                ++j1;
            }
            tablecolumn.createShortStringMap(aword0, as);
        }
        tablecolumn = snaacodetable.getColumn("vdclimit");
        tablecolumn.setDisplayWidth(48);
        tablecolumn.setOptions(0x2000008, true);
        tablecolumn.createShortStringMap(new short[]{-1, 1}, new String[]{"\u8d37\u65b9", "\u501f\u65b9"});
        tablecolumn = snaacodetable.getColumn("shortcode");
        tablecolumn.setDisplayWidth(64);
        int l = 0;
        while (l < propCaption.length) {
            if (propChar[l] > '\u0000') {
                ErpACodeTable.setColumnOption(snaacodetable, "property#" + l, propChar[l]);
            }
            ++l;
        }
        int i1 = 0;
        while (i1 < snaacodetable.getColumnCount()) {
            tablecolumn = snaacodetable.getColumn(i1);
            if (tablecolumn.cellId.startsWith("property") && tablecolumn.displayCaption.length() == 2) {
                tablecolumn.setDisplayWidth(24);
            }
            ++i1;
        }
        tablecolumn = snaacodetable.addColumn("ym_deprecated", "\u505c\u7528\u5e74\u6708");
        tablecolumn.setDataType(16);
        tablecolumn.setTableCellDataAccess(new TableYearMonthCellDataAccess());
        tablecolumn.setDisplayWidth(96);
        tablecolumn = snaacodetable.addColumn("ucodefilter", "\u53ef\u7528\u64cd\u4f5c\u5458");
        ErpPubl.addExtraTableColumn(snaacodetable, 8, 101);
        DataSet dataset = ErpPubl.getSharedTblDataSet("acode");
        Column column = dataset.getColumn("levl");
        snaacodetable.levlDataType = column.getDataType();
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        if (s != null && s.trim().length() > 0 && !s.equals("*") && !s.equals("%")) {
            ErpRowFilter snarowfilter = new ErpRowFilter(1, "acode", s);
            try {
                datasetview.addRowFilterListener((RowFilterListener)snarowfilter);
            }
            catch (Exception exception) {
                Message.out.println(exception);
            }
        }
        datasetview.setSort(dataset.getSort());
        datasetview.open();
        ErpPubl.createDataSetInternalFrame("\u79d1\u76ee" + (flag ? "\u67e5\u8be2" : "\u7ba1\u7406"), snaacodetable, (DataSet)datasetview, true);
    }

    public static int showACodePtyDialog(int i) {
        int j = MainApp.getAppPropertyAsInt("SNA.ACODEPROPMASK", 2);
        JCheckBox[] ajcheckbox = new JCheckBox[propChar.length];
        DialogPanel dialogpanel = new DialogPanel();
        dialogpanel.setLayout(new GridBagLayout());
        DialogPanel.initGBC();
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.gridy = 0;
        DialogPanel.gbc.anchor = 17;
        int k = 0;
        while (k < propCaption.length) {
            block8: {
                block9: {
                    if ((j & 1 << k) != 0) break block8;
                    if (propChar[k] <= '\u0000') break block9;
                    String s = ErpConfig.getCodeTitle(propChar[k]);
                    if (s == null) break block8;
                    ErpACodeTable.propCaption[k] = s;
                }
                ajcheckbox[k] = new JCheckBox(propCaption[k], (i & 1 << k) != 0);
                dialogpanel.add((Component)ajcheckbox[k], DialogPanel.gbc);
                ++DialogPanel.gbc.gridx;
                if (DialogPanel.gbc.gridx > 2) {
                    DialogPanel.gbc.gridx = 0;
                    ++DialogPanel.gbc.gridy;
                }
            }
            ++k;
        }
        if (dialogpanel.showDialog("\u79d1\u76ee\u5c5e\u6027") == 0) {
            i = 0;
            int l = 0;
            while (l < ajcheckbox.length) {
                if (ajcheckbox[l] != null && ajcheckbox[l].isSelected()) {
                    i += 1 << l;
                }
                ++l;
            }
            return i;
        }
        return -1;
    }

    public static class SnaSetACodePty
    implements AidInputer {
        private Table table;
        private String ptyColumn;
        private Variant variant = new Variant();

        public String doAidInput(Component component, String s, int i) {
            try {
                DataSet dataset = this.table.getDataSet();
                dataset.getVariant(this.ptyColumn, this.variant);
                int j = this.variant.getAsInt();
                int k = ErpACodeTable.showACodePtyDialog(j);
                if (k >= 0 && k != j) {
                    Tac.setDataSetValue((ReadWriteRow)dataset, this.ptyColumn, new Integer(k));
                    this.table.stopEdit();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
            return null;
        }

        public SnaSetACodePty(Table table1, String s) {
            this.table = table1;
            this.ptyColumn = s;
        }
    }
}

