/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.StorageDataSet;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class ErpFCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] fcodeLevl;
    private Hashtable codeHash;
    TableColumn fcodeColumn;
    private String oldFCode = "";

    public ErpFCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u5e01\u79cd\uff1f");
        if (!flag) {
            try {
                this.fcodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 11 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x20) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x20) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select fcode from balance where fcode<>' ' group by fcode order by fcode", "select fcode from ivoucher where fcode<>' ' group by fcode order by fcode"}, 0, -1, this.fcodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldFCode = this.dataSet.getString("fcode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldFCode = this.dataSet.getString("fcode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldFCode.length() > 0 && this.codeHash.get(this.oldFCode) != null;
        this.setRwFlags(32, flag1);
        if (this.fcodeColumn != null) {
            this.fcodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",fname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void find() {
        ErpPubl.find(this, "fcode");
    }

    public void print() {
        try {
            ErpPubl.printTable("\u5e01\u79cd", this.dataSet, 11);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5e01\u79cd");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5e01\u79cd");
            this.addLoged = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("fcode");
            int i = ErpPubl.codeLevlMatched(this.fcodeLevl, s1.trim().length(), false);
            if (i < 0) {
                s = String.valueOf(s) + "\u5e01\u79cd\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldFCode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('f');
                if (Utilities.seekDataSet(dataset, "fcode", s1)) {
                    s = String.valueOf(s) + "\u5e01\u79cd\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.fcodeLevl, i)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u7684\u5e01\u79cd" + s2 + "\u7684\u5b50\u5e01\u79cd\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupFCode(boolean flag) throws DataSetException {
        ErpFCodeTable snafcodetable = new ErpFCodeTable(flag);
        snafcodetable.setDatasetTablename("fcode");
        snafcodetable.addColumns(new String[]{"fcode", "fname"}, new String[]{"\u5e01\u79cd", "\u5e01\u540d"});
        TableColumn tablecolumn = snafcodetable.getColumn("fname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(160);
        snafcodetable.fcodeColumn = tablecolumn = snafcodetable.getColumn("fcode");
        tablecolumn.setOptions(0x308000, true);
        tablecolumn.setDisplayWidth(80);
        ErpPubl.addExtraTableColumn(snafcodetable, 11, 101);
        DataSet dataset = ErpPubl.getSharedTblDataSet("fcode");
        ErpPubl.addYmdepcAndUCodeFilterColumn(snafcodetable, dataset);
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame("\u5e01\u522b", snafcodetable, (DataSet)datasetview, true);
    }
}

