/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import softcore.awt.NoKeyActionsSplitPaneUI;
import softcore.awt.ScrollBarPanel;
import softcore.table.DataWindow;
import softcore.table.GridTable;
import softcore.table.RecordTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpRowFilter;
import softoperation.finance.erpdata.CreateDataTable;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;
import softoperation.finance.erpdata.ErpdataDataWindow;

public class ErpGCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] gcodeLevl;
    private Variant variant = new Variant();
    int levl;
    int levlDataType;
    private String oldGName;
    private DataRow row;
    private DataSet pDataSet;
    private ErpRowFilter dataRowFilter;
    private Hashtable parmHash = new Hashtable();
    private Hashtable codeHash;
    TableColumn gcodeColumn;
    private String oldGCode = "";
    private String gcodePtn;

    public ErpGCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u5546\u54c1\uff1f");
        if (!flag) {
            try {
                this.gcodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 12 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x40) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x40) != 0;
            try {
                this.codeHash = (MainApp.getAppIntOption(2301, 50) & 1) != 0 ? (JDBC.sqlSelectInt("select count(*) from tbldef where tblname='stock_d'") > 0 ? ErpPubl.createHashFromSql(new String[]{"select gcode from balance where gcode<>' ' group by gcode order by gcode", "select gcode from ivoucher where gcode<>' ' group by gcode order by gcode", "select distinct gcode from stock_d where gcode<>' ' order by gcode"}, 0, -1, this.gcodeLevl) : ErpPubl.createHashFromSql(new String[]{"select gcode from balance where gcode<>' ' group by gcode order by gcode", "select gcode from ivoucher where gcode<>' ' group by gcode order by gcode"}, 0, -1, this.gcodeLevl)) : new Hashtable();
                this.gcodePtn = ErpPubl.getAppOptionAsText(106, 15);
            }
            catch (Exception exception) {}
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void print() {
        try {
            ErpPubl.printTable("\u5e93\u5b58\u5546\u54c1", this.dataSet, 12);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    boolean isCCodeUsed(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return this.codeHash.get(s) != null;
    }

    protected Color getCellBackground(int i, TableColumn tablecolumn) {
        Color color = super.getCellBackground(i, tablecolumn);
        if ("gcode".equalsIgnoreCase(tablecolumn.cellId) && this.isCCodeUsed((String)this.getCellValue(i, "gcode"))) {
            return Color.lightGray;
        }
        return color;
    }

    public void deleteRow() throws DataSetException {
        if (this.isCCodeUsed((String)this.getCellValue(-1, "gcode"))) {
            Message.showInformationDialog("\u5546\u54c1" + this.getCellValue(-1, "gcode") + "\u5df2\u7528\u8fc7\uff0c\u4e0d\u80fd\u5220\u9664!");
            return;
        }
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5546\u54c1");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5546\u54c1");
            this.addLoged = true;
        }
    }

    protected void onRowNavigated(boolean flag) {
        TableColumn tablecolumn;
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldGCode = this.dataSet.getString("gcode");
            if ((ErpConfig.getOtherOption() & 0x10) != 0) {
                this.oldGName = this.dataSet.getString("gname");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldGCode.length() > 0 && this.codeHash.get(this.oldGCode) != null;
        this.setRwFlags(32, flag1);
        if (!this.bUsedModifyEnable) {
            String s = ",gname,qtyunit,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
        if ((tablecolumn = this.getColumn("gcode")) != null) {
            tablecolumn.setOptions(256, flag1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldGCode = this.dataSet.getString("gcode");
        if ((ErpConfig.getOtherOption() & 0x10) != 0) {
            this.oldGName = this.dataSet.getString("gname");
        }
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("gcode")) {
            try {
                String s = dataset.getString("gcode");
                int i = s != null ? s.length() : 0;
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.gcodeLevl, i, false) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        super.keyPressed(keyevent);
        try {
            int i = keyevent.getKeyCode();
            if (i == 120) {
                ErpPubl.filterTable(this, null, "\u8fc7\u6ee4", this.parmHash, null);
            }
            if (keyevent.isControlDown()) {
                switch (i) {
                    case 76: {
                        ErpPubl.locateTable(this, this.parmHash);
                        break;
                    }
                    case 90: {
                        ErpPubl.filterTable(this, null);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void find() {
        try {
            ErpPubl.locateTable(this, null, "\u5b9a\u4f4d", this.parmHash);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    protected String getRowErrorText() {
        String s1;
        String s;
        block13: {
            s = super.getRowErrorText();
            if (s != null) {
                return s;
            }
            s = "";
            s1 = this.dataSet.getString("gcode");
            if (this.gcodePtn == null || Utilities.likeOneOf(s1, this.gcodePtn)) break block13;
            return "\u5546\u54c1\u7801\u4e0e\u9009\u9879\u5b9a\u4e49\u4e2d\u7684\u5339\u914d\u4e32\u4e0d\u76f8\u7b26\uff01";
        }
        try {
            if (this.levl < 0) {
                s = String.valueOf(s) + "\u5546\u54c1\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldGCode)) {
                String s3;
                DataSet dataset = ErpPubl.getSharedTblDataSet('g');
                if (Utilities.seekDataSet(dataset, "gcode", s1)) {
                    s = String.valueOf(s) + "\u5546\u54c1\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s3 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.gcodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u5546\u54c1\u7801" + s3 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
            String s2 = this.dataSet.getString("gname");
            if (!this.bQuery && (ErpConfig.getOtherOption() & 0x10) != 0 && !s2.equals(this.oldGName)) {
                this.row.setString("gname", s2);
                if (this.pDataSet.lookup((ReadRow)this.row, null, 32)) {
                    s = String.valueOf(s) + "\u5546\u54c1\u540d\u91cd\u590d\uff01\n";
                }
            }
            if ((ErpConfig.getOtherOption() & 1) != 0 && this.dataSet.getString("gcode2").length() <= 0) {
                s = String.valueOf(s) + "05\u8868\u7f16\u7801\u8f93\u5165\u4e3a\u7a7a\uff01";
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupGCode(boolean flag) throws DataSetException {
        String s2;
        TableColumn tablecolumn;
        ErpGCodeTable snagcodetable = new ErpGCodeTable(flag);
        snagcodetable.setLeftFixedColumns(2);
        snagcodetable.setDatasetTablename("gcode");
        snagcodetable.gcodeColumn = tablecolumn = new TableColumn("gcode", "\u5546\u54c1\u7801");
        tablecolumn.setOptions(0x308000, true);
        tablecolumn.setDisplayWidth(120);
        snagcodetable.addColumn(tablecolumn);
        tablecolumn = new TableColumn("gname", "\u5546\u54c1\u540d");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(160);
        snagcodetable.addColumn(tablecolumn);
        tablecolumn = new TableColumn("gcode2", "05\u8868\u7f16\u7801");
        tablecolumn.setDisplayWidth(120);
        snagcodetable.addColumn(tablecolumn);
        tablecolumn = new TableColumn("qtyunit", "\u8ba1\u91cf");
        tablecolumn.setOptions(32768, true);
        snagcodetable.addColumn(tablecolumn);
        String s = ErpConfig.getQtxTitle();
        if (s != null) {
            tablecolumn = new TableColumn("qtxunit", String.valueOf(s) + "\u5355\u4f4d");
            snagcodetable.addColumn(tablecolumn);
        }
        tablecolumn = new TableColumn("taxrate", "\u589e\u503c\u7a0e\u7387");
        ErpPubl.setScale(tablecolumn, "taxrate");
        tablecolumn.setDisplayWidth(96);
        snagcodetable.addColumn(tablecolumn);
        tablecolumn = new TableColumn("taxrate2", "\u9000\u7a0e\u7387");
        ErpPubl.setScale(tablecolumn, "taxrate2");
        tablecolumn.setDisplayWidth(96);
        snagcodetable.addColumn(tablecolumn);
        tablecolumn = new TableColumn("shortcode", "\u7b80\u7801");
        tablecolumn.setDisplayWidth(64);
        snagcodetable.addColumn(tablecolumn);
        String s1 = ErpConfig.getGCodePrice1Title();
        if (s1 != null) {
            TableColumn tablecolumn1 = new TableColumn("upric1", s1);
            ErpPubl.setScale(tablecolumn1, "upric1");
            snagcodetable.addColumn(tablecolumn1);
        }
        if ((s2 = ErpConfig.getGCodePrice2Title()) != null) {
            TableColumn tablecolumn2 = new TableColumn("upric2", s2);
            ErpPubl.setScale(tablecolumn2, "upric2");
            snagcodetable.addColumn(tablecolumn2);
        }
        if ((ErpConfig.getOtherOption() & 4) != 0) {
            TableColumn tablecolumn3 = new TableColumn("ulimit", "\u5e93\u5b58\u4e0a\u9650");
            ErpPubl.setScale(tablecolumn3, "ulimit");
            snagcodetable.addColumn(tablecolumn3);
            tablecolumn3 = new TableColumn("llimit", "\u5e93\u5b58\u4e0b\u9650");
            ErpPubl.setScale(tablecolumn3, "llimit");
            snagcodetable.addColumn(tablecolumn3);
        }
        DataSet dataset = ErpPubl.getSharedTblDataSet("gcode");
        if (!flag && (ErpConfig.getOtherOption() & 0x10) != 0) {
            snagcodetable.pDataSet = dataset;
            snagcodetable.row = new DataRow(dataset, "gname");
        }
        Column column = dataset.getColumn("levl");
        snagcodetable.levlDataType = column.getDataType();
        snagcodetable.dataRowFilter = new ErpRowFilter(7, "gcode", snagcodetable, null);
        snagcodetable.dataRowFilter.setCodePtn(null);
        ErpPubl.addYmdepcAndUCodeFilterColumn(snagcodetable, dataset);
        if (ErpPubl.getAppOptionAsText(2202, 7) == null && ErpPubl.getAppOptionAsText(2202, 8) == null) {
            ErpPubl.addExtraTableColumn(snagcodetable, 12, 101);
        }
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        try {
            datasetview.addRowFilterListener((RowFilterListener)snagcodetable.dataRowFilter);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame("\u7269\u54c1\u3001\u5546\u54c1", snagcodetable, (DataSet)datasetview, true);
    }

    public static void productManage() {
        try {
            ErpdataDataWindow sndatadatawindow = new ErpdataDataWindow();
            DataSet dataset = ErpPubl.getSharedTblDataSet('g');
            JTree jtree = ErpPubl.createCodeTree(dataset, "\u56fe\u4e66\u8d44\u6599");
            jtree.setSelectionRow(0);
            final ErpRowFilter rowFilter = new ErpRowFilter(1, "gcode", "%");
            final DataSetView gcodeDataSetView = new DataSetView();
            GCodeRecordTable gcoderecordtable = new GCodeRecordTable();
            final ErpGCodeTable table = new ErpGCodeTable(false);
            jtree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeselectionevent) {
                    TreePath treepath = treeselectionevent.getNewLeadSelectionPath();
                    if (treepath == null) {
                        return;
                    }
                    String s = treepath.getLastPathComponent().toString();
                    if (s == null || s.indexOf(":") <= 0) {
                        rowFilter.setCodePtn("%");
                    } else {
                        rowFilter.setCodePtn(String.valueOf(s.substring(0, s.indexOf(":"))) + "%");
                    }
                    try {
                        gcodeDataSetView.refilter();
                        table.onRowNavigated(false);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(Message.out);
                    }
                }
            });
            table.setDatasetTablename("gcode");
            gcodeDataSetView.setStorageDataSet((StorageDataSet)dataset);
            try {
                gcodeDataSetView.addRowFilterListener((RowFilterListener)rowFilter);
            }
            catch (Exception exception1) {
                exception1.printStackTrace(Message.out);
            }
            gcodeDataSetView.setSort(dataset.getSort());
            CreateDataTable createdatatable = new CreateDataTable(sndatadatawindow);
            CreateDataTable.CreateInfo createinfo = new CreateDataTable.CreateInfo();
            createdatatable.createTable(new int[]{230300}, table, 0, createinfo);
            createdatatable.setTableTac(createinfo.id, table, createinfo.dtName, new CreateDataTable.CreateInfo[]{createinfo});
            table.addPopupMenuByTac(table.getInterposeTac());
            table.setDataSet((DataSet)gcodeDataSetView);
            table.openQueryDataSet((DataWindow)sndatadatawindow, true);
            ErpGCodeTable.setDivvyModeColumn(table.getColumn("divvymode"));
            gcoderecordtable.setDatasetTablename("gcode");
            createdatatable.createTable(new int[]{230302}, gcoderecordtable, 0, createinfo);
            createdatatable.setTableTac(createinfo.id, gcoderecordtable, createinfo.dtName, new CreateDataTable.CreateInfo[]{createinfo});
            gcoderecordtable.addPopupMenuByTac(gcoderecordtable.getInterposeTac());
            gcoderecordtable.setDataSet((DataSet)gcodeDataSetView);
            gcoderecordtable.openQueryDataSet(sndatadatawindow, null, null, createinfo.defaultValueColumns, createinfo.defaultValues, true);
            ErpGCodeTable.setDivvyModeColumn(gcoderecordtable.getColumn("divvymode"));
            JScrollPane jscrollpane = new JScrollPane(jtree);
            ScrollBarPanel scrollbarpanel = new ScrollBarPanel(table, 3);
            JSplitPane jsplitpane = new JSplitPane(1);
            jsplitpane.setLeftComponent(jscrollpane);
            jsplitpane.setRightComponent(scrollbarpanel);
            jsplitpane.setDividerSize(3);
            jsplitpane.setDividerLocation(300);
            JSplitPane jsplitpane1 = new JSplitPane(0);
            jsplitpane1.setTopComponent(jsplitpane);
            jsplitpane1.setBottomComponent(new ScrollBarPanel(gcoderecordtable, 3));
            jsplitpane1.setDividerSize(3);
            jsplitpane1.setDividerLocation(300);
            jsplitpane.setUI(new NoKeyActionsSplitPaneUI());
            gcoderecordtable.setFindStyle(2);
            gcoderecordtable.setFindKeys(new String[]{"gcode", "gname", "shortcode"});
            table.setFindStyle(2);
            table.setFindKeys(new String[]{"gcode", "gname", "shortcode"});
            JInternalFrame jinternalframe = sndatadatawindow.createSqlInternalFrame("\u56fe\u4e66\u8d44\u6599", jsplitpane1, null);
            jinternalframe.setSize(new Dimension(950, 600));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void setDivvyModeColumn(TableColumn tablecolumn) throws SQLException {
        if (tablecolumn == null) {
            return;
        }
        tablecolumn.setDisplayWidth(48);
        int i = MainApp.getAppIntOption(2201, 2);
        String s = JDBC.sqlSelectString("select vtext from sysoptions2 where grp=2201 and ord = 2");
        if (i == 0 || s == null) {
            tablecolumn.createIntStringMap(new int[1], new String[1]);
            return;
        }
        String[] as = Utilities.splitString(s, ';');
        int j = 1;
        int k = 0;
        while (k < as.length) {
            if ((i & 1 << k) != 0) {
                ++j;
            }
            ++k;
        }
        int[] ai = new int[j];
        String[] as1 = new String[j];
        ai[0] = 0;
        as1[0] = null;
        int l = 0;
        int i1 = 1;
        while (l < as.length) {
            if ((i & 1 << l) != 0) {
                as1[i1] = as[l];
                ai[i1] = l + 1;
                ++i1;
            }
            ++l;
        }
        tablecolumn.createIntStringMap(ai, as1);
    }

    public static class GCodeRecordTable
    extends RecordTable {
        protected String getRowErrorText() {
            block6: {
                String s = super.getRowErrorText();
                if (s != null) {
                    return s;
                }
                try {
                    Variant variant1 = new Variant();
                    this.dataSet.getVariant("cbdate", variant1);
                    if (!variant1.isNull()) {
                        Timestamp timestamp = variant1.getTimestamp();
                        Variant variant2 = new Variant();
                        this.dataSet.getVariant("ygdate", variant2);
                        if (!variant2.isNull()) {
                            Timestamp timestamp1 = variant2.getTimestamp();
                            if (timestamp.getTime() <= timestamp1.getTime()) {
                                return "\u9884\u544a\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u51fa\u7248\u65e5\u671f!";
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!MainApp.isDebug) break block6;
                    exception.printStackTrace(Message.out);
                }
            }
            return null;
        }

        protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
            super.onPostEditingValue(dataset, tablecolumn);
            try {
                if ((MainApp.getAppIntOption(2301, 28) & 0x40) != 0 && (tablecolumn.cellId.equals("nthversion") || tablecolumn.cellId.equals("nthprint") || tablecolumn.cellId.equals("gcode"))) {
                    if (!dataset.isEditingNewRow()) {
                        return;
                    }
                    String s = dataset.getString("gcode");
                    if (s.length() == 0) {
                        return;
                    }
                    Variant variant1 = new Variant();
                    dataset.getVariant("nthversion", variant1);
                    int i = variant1.getAsInt();
                    if (i == 0) {
                        return;
                    }
                    String s1 = "." + i;
                    dataset.getVariant("nthprint", variant1);
                    int j = variant1.getAsInt();
                    if (j == 0) {
                        return;
                    }
                    s1 = String.valueOf(s1) + "." + j;
                    int k = s.indexOf(46);
                    if (k > 0) {
                        s = s.substring(0, k);
                    }
                    dataset.setString("gcode", String.valueOf(s) + s1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }
}

