/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import softcore.awt.NoKeyActionsSplitPaneUI;
import softcore.awt.ScrollBarPanel;
import softcore.table.GridTable;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softface.MainFrame;
import softoperation.finance.erpa.ErpBnkDialogPanel;
import softoperation.finance.erpa.ErpBnkMonthCellDataAccess;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpTableVouTypeVouNoCellDataAccess;
import softoperation.finance.erpdata.ErpdataDataWindow;
import softoperation.finance.erpdata.TableDebitCreditCellDataAccess;

public class ErpManualBnkCheck
extends ErpdataDataWindow {
    int year;
    int month;
    int bMonth = 1;
    int autoCheckedWord;
    int manualCheckedWord;
    boolean onlyDispUncheckItem;
    boolean enableSeek = true;
    boolean curSeeked = false;
    String where;
    String fldname;
    GridTable sheetTable;
    GridTable ldgTable;
    QueryDataSet sheetDataSet;
    QueryDataSet ldgDataSet;
    JButton checkButton;
    JButton uncheckButton;
    BigDecimal sheetDebit;
    BigDecimal sheetCredit;
    BigDecimal ldgDebit;
    BigDecimal ldgCredit;
    TableColumn ldgCheckColumn;
    TableColumn sheetCheckColumn;
    int vmonthDataType;
    private Variant variant = new Variant();
    private BigDecimal zeroBigDecimal = new BigDecimal(0.0);

    public ErpManualBnkCheck(int i, int j, String s, String s1, String s2, boolean flag) {
        this.year = i;
        this.month = j;
        this.autoCheckedWord = (i - 1900) * 16 + j;
        this.manualCheckedWord = this.autoCheckedWord + 16384;
        this.onlyDispUncheckItem = flag;
        this.fldname = s2 == null ? "rmb" : "fcy";
        this.where = "(acode='" + s + "')";
        if (s1 != null) {
            this.where = String.valueOf(this.where) + " and (bcode like '" + s1 + "%')";
        }
        if (s2 != null) {
            this.where = String.valueOf(this.where) + " and (fcode = '" + s2 + "')";
        }
        this.initTrackValue();
        try {
            String s3 = "select vmonth from banksheet where year=" + i + " and month=0 and dc=0";
            s3 = String.valueOf(s3) + " and " + this.where;
            Object obj = JDBC.sqlSelect1(null, s3);
            if (obj != null) {
                this.bMonth = ((Number)obj).intValue();
            }
            this.initLdgTable();
            this.initSheetTable();
            try {
                this.sheetDataSet.first();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    void initTrackValue() {
        this.sheetDebit = this.zeroBigDecimal;
        this.sheetCredit = this.zeroBigDecimal;
        this.ldgDebit = this.zeroBigDecimal;
        this.ldgCredit = this.zeroBigDecimal;
    }

    boolean seek(DataSet dataset, int i, BigDecimal bigdecimal, boolean flag) throws DataSetException {
        BigDecimal bigdecimal1;
        int j;
        if (bigdecimal == null) {
            bigdecimal = this.zeroBigDecimal;
        }
        if ((j = this.seek(dataset, i, bigdecimal)) < 0) {
            bigdecimal = bigdecimal.negate();
            j = this.seek(dataset, i *= -1, bigdecimal);
        }
        if (j < 0) {
            return false;
        }
        String s = dataset != this.ldgDataSet ? "vmonth" : "bankmonth";
        String s1 = dataset != this.ldgDataSet ? "dc" : "vdc";
        int k = dataset.getRowCount();
        int l = j;
        do {
            dataset.getVariant(s, l, this.variant);
            if ((!this.variant.isNull() && this.variant.getAsInt() != 0) == flag) {
                j = l;
                break;
            }
            if (++l >= k) break;
            dataset.getVariant(s1, l, this.variant);
            if (this.variant.getAsInt() != i) break;
            dataset.getVariant(this.fldname, l, this.variant);
        } while ((bigdecimal1 = this.variant.isNull() ? this.zeroBigDecimal : this.variant.getAsBigDecimal()).compareTo(bigdecimal) == 0);
        dataset.goToRow(j);
        return true;
    }

    int seek(DataSet dataset, int i, BigDecimal bigdecimal) throws DataSetException {
        String s;
        String string = s = dataset != this.ldgDataSet ? "dc" : "vdc";
        if (bigdecimal == null) {
            bigdecimal = this.zeroBigDecimal;
        }
        if (i == -1) {
            i = 2;
        }
        int j = 0;
        int k = dataset.getRowCount() - 1;
        while (j <= k) {
            int k1;
            int l = (j + k) / 2;
            dataset.getVariant(s, l, this.variant);
            int i1 = this.variant.getAsInt();
            if (i1 == -1) {
                i1 = 2;
            }
            if ((k1 = i1 - i) == 0) {
                dataset.getVariant(this.fldname, l, this.variant);
                BigDecimal bigdecimal1 = this.variant.isNull() ? this.zeroBigDecimal : this.variant.getAsBigDecimal();
                k1 = bigdecimal1.compareTo(bigdecimal);
            }
            if (k1 < 0) {
                j = l + 1;
                continue;
            }
            if (k1 > 0) {
                k = l - 1;
                continue;
            }
            int l1 = l - 1;
            if (i == 2) {
                i = -1;
            }
            while (l1 >= 0) {
                BigDecimal bigdecimal2;
                dataset.getVariant(s, l1, this.variant);
                int j1 = this.variant.getAsInt();
                if (j1 != i) break;
                dataset.getVariant(this.fldname, l1, this.variant);
                BigDecimal bigDecimal = bigdecimal2 = this.variant.isNull() ? this.zeroBigDecimal : this.variant.getAsBigDecimal();
                if (bigdecimal2.compareTo(bigdecimal) != 0) break;
                --l1;
            }
            return l1 + 1;
        }
        return -1;
    }

    void enableToolBarButton(boolean flag) throws DataSetException {
        if (this.checkButton == null) {
            this.checkButton = MainFrame.getAppToolBar().findButtonByActionCommand("check");
        }
        if (this.uncheckButton == null) {
            this.uncheckButton = MainFrame.getAppToolBar().findButtonByActionCommand("uncheck");
        }
        boolean flag1 = false;
        boolean flag2 = false;
        if (flag) {
            boolean flag4;
            Object obj = this.sheetTable.getCellValue(-1, this.sheetCheckColumn);
            boolean flag3 = obj != null && obj instanceof Boolean && (Boolean)obj != false;
            obj = this.ldgTable.getCellValue(-1, this.ldgCheckColumn);
            boolean bl = flag4 = obj != null && obj instanceof Boolean && (Boolean)obj != false;
            if (flag3 == flag4) {
                if (flag3) {
                    flag2 = true;
                }
                if (!flag3) {
                    flag1 = true;
                }
            }
        }
        this.checkButton.setEnabled(flag1);
        this.uncheckButton.setEnabled(flag2);
    }

    void trackTotalValue(DataSet dataset) throws DataSetException {
        BigDecimal bigdecimal;
        String s = dataset != this.sheetDataSet ? "vdc" : "dc";
        String s1 = dataset != this.sheetDataSet ? "bankmonth" : "vmonth";
        dataset.getVariant(s, this.variant);
        int i = this.variant.getAsInt();
        dataset.getVariant(s1, this.variant);
        boolean flag = !this.variant.isNull() && this.variant.getAsInt() != 0;
        dataset.getVariant(this.fldname, this.variant);
        BigDecimal bigDecimal = bigdecimal = this.variant.isNull() ? this.zeroBigDecimal : this.variant.getAsBigDecimal();
        if (!flag) {
            bigdecimal = bigdecimal.negate();
        }
        if (i == 1) {
            if (dataset == this.sheetDataSet) {
                this.sheetDebit = this.sheetDebit.add(bigdecimal);
            } else {
                this.ldgDebit = this.ldgDebit.add(bigdecimal);
            }
        } else if (dataset == this.sheetDataSet) {
            this.sheetCredit = this.sheetCredit.add(bigdecimal);
        } else {
            this.ldgCredit = this.ldgCredit.add(bigdecimal);
        }
    }

    String getErrorText() {
        BigDecimal bigdecimal1;
        if (!this.sheetTable.postPendingValue() || !this.ldgTable.postPendingValue()) {
            return "\u5b58\u76d8\u5931\u8d25\uff01";
        }
        BigDecimal bigdecimal = this.sheetDebit.subtract(this.sheetCredit).setScale(2, 4);
        if (bigdecimal.compareTo(bigdecimal1 = this.ldgDebit.subtract(this.ldgCredit).setScale(2, 4)) != 0) {
            String s = "\u624b\u5de5\u5bf9\u5e10\u4e0d\u5e73\uff0c\u7cfb\u7edf\u5c06\u65e0\u6cd5\u5b58\u76d8\u3002\u5176\u4e2d\uff1a\n\u3000\u3000\u5bf9\u5e10\u5355\uff1a\u6536\u65b9(" + Utilities.format(this.sheetDebit, 2, 2, true) + ")\uff0d\u4ed8\u65b9(" + Utilities.format(this.sheetCredit, 2, 2, true) + ")\uff1d" + Utilities.format(bigdecimal, 2, 2, true);
            s = String.valueOf(s) + "\n\u3000\u3000\u94f6\u884c\u5e10\uff1a\u501f\u65b9(" + Utilities.format(this.ldgDebit, 2, 2, true) + ")\uff0d\u8d37\u65b9(" + Utilities.format(this.ldgCredit, 2, 2, true) + ")\uff1d" + Utilities.format(bigdecimal1, 2, 2, true);
            return s;
        }
        return null;
    }

    void saveAllChanges() throws DataSetException {
        String s = this.getErrorText();
        if (s != null) {
            throw new DataSetException(s);
        }
        this.sheetDataSet.saveChanges();
        this.ldgDataSet.saveChanges();
        this.initTrackValue();
        this.sheetTable.setDataSetChanged(false);
        this.ldgTable.setDataSetChanged(false);
    }

    void onActionPerformed(ActionEvent actionevent) {
        if (actionevent.getActionCommand().equals("check")) {
            try {
                this.sheetTable.postPendingValue();
                this.sheetTable.stopEdit();
                this.ldgTable.postPendingValue();
                this.ldgTable.stopEdit();
                Utilities.setIntToVariant(this.manualCheckedWord, this.variant, this.vmonthDataType);
                this.sheetDataSet.setVariant("vmonth", this.variant);
                this.sheetTable.setDataSetChanged(true);
                this.ldgDataSet.setVariant("bankmonth", this.variant);
                this.ldgTable.setDataSetChanged(true);
                this.trackTotalValue((DataSet)this.sheetDataSet);
                this.trackTotalValue((DataSet)this.ldgDataSet);
                this.enableToolBarButton(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        } else if (actionevent.getActionCommand().equals("uncheck")) {
            try {
                this.sheetTable.postPendingValue();
                this.sheetTable.stopEdit();
                this.ldgTable.postPendingValue();
                this.ldgTable.stopEdit();
                this.variant.setAssignedNull();
                this.sheetDataSet.setVariant("vmonth", this.variant);
                this.sheetTable.setDataSetChanged(true);
                this.ldgDataSet.setVariant("bankmonth", this.variant);
                this.ldgTable.setDataSetChanged(true);
                this.trackTotalValue((DataSet)this.sheetDataSet);
                this.trackTotalValue((DataSet)this.ldgDataSet);
                this.enableToolBarButton(true);
            }
            catch (Exception exception1) {
                exception1.printStackTrace(Message.out);
            }
        }
    }

    void rowNavigated(Table table, Table table1, DataSet dataset, DataSet dataset1) {
        if (table1 == null) {
            return;
        }
        if (!this.enableSeek) {
            return;
        }
        table1.postPendingValue();
        table1.stopEdit();
        String s = dataset != this.sheetDataSet ? "vdc" : "dc";
        String s1 = dataset != this.sheetDataSet ? "bankmonth" : "vmonth";
        try {
            table.fireEnableDataSetEvent(false, dataset);
            int i = dataset1.getRow();
            this.enableSeek = false;
            dataset.getVariant(s, this.variant);
            int j = this.variant.getAsInt();
            dataset.getVariant(s1, this.variant);
            this.curSeeked = this.seek(dataset1, j, dataset.getBigDecimal(this.fldname), !this.variant.isNull() && this.variant.getAsInt() != 0);
            this.enableToolBarButton(this.curSeeked);
            this.enableSeek = true;
            int k = table.getFlagSelectedOptions();
            byte byte0 = (byte)(this.curSeeked ? 51 : 3);
            if (k != byte0) {
                table.setFlagSelectedOptions(byte0);
                table.drawSelectedRow();
                table.repaint();
            }
            table1.setFlagSelectedOptions(byte0);
            table1.drawRow(i);
            table1.drawSelectedRow();
            table1.repaint();
            table.fireEnableDataSetEvent(true, dataset);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    void initSheetTable() throws DataSetException {
        this.sheetDataSet = new QueryDataSet();
        String s = "select id,bkdate,qcode,expl,dc,vmonth," + this.fldname + " from banksheet where (dc<>0) and (year=" + this.year + ") and ((month=0) or (month>=" + this.bMonth + " and month<=" + this.month + "))";
        s = String.valueOf(s) + " and " + this.where;
        s = this.onlyDispUncheckItem ? String.valueOf(s) + " and ((vmonth is null) or (vmonth=0))" : String.valueOf(s) + " and ((vmonth is null) or (vmonth=0) or (vmonth=" + this.autoCheckedWord + ") or (vmonth=" + this.manualCheckedWord + "))";
        this.sheetDataSet.setQuery(new QueryDescriptor(ErpPubl.database, s, null, true, false));
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.sheetDataSet.setSort(new SortDescriptor(null, new String[]{"dc", this.fldname}, blArray, true, false, null));
        this.sheetDataSet.open();
        ErpPubl.setSearchableByRowId((DataSet)this.sheetDataSet);
        this.sheetTable = new GridTable(){

            public void actionPerformed(ActionEvent actionevent) {
                super.actionPerformed(actionevent);
                ErpManualBnkCheck.this.onActionPerformed(actionevent);
            }

            protected void saveDataSetChanges() throws DataSetException {
                ErpManualBnkCheck.this.saveAllChanges();
            }

            protected void editingValueChanged() {
                super.editingValueChanged();
                try {
                    if (ErpManualBnkCheck.this.sheetCheckColumn == this.getSelectedColumn()) {
                        ErpManualBnkCheck.this.enableToolBarButton(ErpManualBnkCheck.this.curSeeked);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(Message.out);
                }
            }

            protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn1) {
                super.onPostEditingValue(dataset, tablecolumn1);
                if (tablecolumn1.cellId.equals("sheetcheck")) {
                    try {
                        ErpManualBnkCheck.this.trackTotalValue(dataset);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Message.out);
                    }
                }
            }

            protected void onRowNavigated(boolean flag) {
                super.onRowNavigated(flag);
                ErpManualBnkCheck.this.rowNavigated(this, ErpManualBnkCheck.this.ldgTable, this.dataSet, (DataSet)ErpManualBnkCheck.this.ldgDataSet);
            }

            public void focusGained(FocusEvent focusevent) {
                super.focusGained(focusevent);
                try {
                    ErpManualBnkCheck.this.enableToolBarButton(ErpManualBnkCheck.this.curSeeked);
                }
                catch (Exception exception) {
                    exception.printStackTrace(Message.out);
                }
            }
        };
        this.sheetTable.addColumns(new String[]{"bkdate", "qcode", "expl", String.valueOf(this.fldname) + "debit", String.valueOf(this.fldname) + "credit", "sheetcheck"}, new String[]{"\u65e5\u671f", "\u652f\u7968\u53f7", "\u6458\u8981", "\u6536\u65b9", "\u4ed8\u65b9", "\u5bf9"});
        this.sheetTable.setRwFlags(60, true);
        this.sheetTable.setAcceptActionCommands(new String[]{"check", "uncheck"});
        TableColumn tablecolumn = this.sheetTable.getColumn("bkdate");
        tablecolumn.setOptions(256, true);
        tablecolumn = this.sheetTable.getColumn("qcode");
        tablecolumn.setOptions(256, true);
        tablecolumn = this.sheetTable.getColumn("expl");
        tablecolumn.setOptions(256, true);
        if (this.ldgTable != null) {
            tablecolumn.setDisplayWidth(this.ldgTable.getColumn("expl").getDisplayWidth() + this.ldgTable.getColumn("svno").getDisplayWidth());
        }
        tablecolumn = this.sheetTable.getColumn(String.valueOf(this.fldname) + "debit");
        tablecolumn.setOptions(256, true);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fldname, "dc", 1));
        tablecolumn = this.sheetTable.getColumn(String.valueOf(this.fldname) + "credit");
        tablecolumn.setOptions(256, true);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fldname, "dc", -1));
        this.sheetCheckColumn = tablecolumn = this.sheetTable.getColumn("sheetcheck");
        tablecolumn.setDataType(11);
        tablecolumn.setTableCellDataAccess(new ErpBnkMonthCellDataAccess("vmonth", this.manualCheckedWord, this.vmonthDataType));
        this.sheetTable.setDataSet((DataSet)this.sheetDataSet);
        this.sheetTable.initial();
    }

    void initLdgTable() throws DataSetException {
        this.ldgDataSet = new QueryDataSet();
        String s = (ErpConfig.getBnkCheckOption() & 8) != 0 ? "select year,month,vtype,vno,ino,vdate,qcode,expl,odate,vdc,bankmonth,vtypeno," + this.fldname + " from ivoucher where (year=" + this.year + ") and ((month=0) or (month>=" + this.bMonth + " and month<=" + this.month + "))" : "select year,month,vtype,vno,ino,vdate,qcode,expl,odate,vdc,bankmonth,vtypeno," + this.fldname + " from ivoucher where (kept is not null) and (kept<>0) and (year=" + this.year + ") and ((month=0) or (month>=" + this.bMonth + " and month<=" + this.month + "))";
        s = String.valueOf(s) + " and " + this.where;
        s = this.onlyDispUncheckItem ? String.valueOf(s) + " and ((bankmonth is null) or (bankmonth=0))" : String.valueOf(s) + " and ((bankmonth is null) or (bankmonth=0) or (bankmonth=" + this.autoCheckedWord + ") or (bankmonth=" + this.manualCheckedWord + "))";
        this.ldgDataSet.setQuery(new QueryDescriptor(ErpPubl.database, s, null, true, false));
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.ldgDataSet.setSort(new SortDescriptor(null, new String[]{"vdc", this.fldname}, blArray, true, false, null));
        this.ldgDataSet.open();
        Column column = this.ldgDataSet.getColumn("bankmonth");
        this.vmonthDataType = column.getDataType();
        ErpPubl.setSearchableByRowId((DataSet)this.ldgDataSet);
        this.ldgTable = new GridTable(){

            public void actionPerformed(ActionEvent actionevent) {
                super.actionPerformed(actionevent);
                ErpManualBnkCheck.this.onActionPerformed(actionevent);
            }

            protected void editingValueChanged() {
                super.editingValueChanged();
                try {
                    if (ErpManualBnkCheck.this.ldgCheckColumn == this.getSelectedColumn()) {
                        ErpManualBnkCheck.this.enableToolBarButton(ErpManualBnkCheck.this.curSeeked);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(Message.out);
                }
            }

            protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn1) {
                super.onPostEditingValue(dataset, tablecolumn1);
                if (tablecolumn1.cellId.equals("ldgcheck")) {
                    try {
                        ErpManualBnkCheck.this.trackTotalValue(dataset);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Message.out);
                    }
                }
            }

            protected void saveDataSetChanges() throws DataSetException {
                ErpManualBnkCheck.this.saveAllChanges();
            }

            protected void onRowNavigated(boolean flag) {
                super.onRowNavigated(flag);
                ErpManualBnkCheck.this.rowNavigated(this, ErpManualBnkCheck.this.sheetTable, this.dataSet, (DataSet)ErpManualBnkCheck.this.sheetDataSet);
            }

            public void focusGained(FocusEvent focusevent) {
                super.focusGained(focusevent);
                try {
                    ErpManualBnkCheck.this.enableToolBarButton(ErpManualBnkCheck.this.curSeeked);
                }
                catch (Exception exception) {
                    exception.printStackTrace(Message.out);
                }
            }
        };
        this.ldgTable.addColumns(new String[]{"vdate", "svno", "qcode", "expl", "odate", String.valueOf(this.fldname) + "debit", String.valueOf(this.fldname) + "credit", "ldgcheck"}, new String[]{"\u51ed\u8bc1\u65e5\u671f", "\u51ed\u8bc1\u53f7", "\u652f\u7968\u53f7", "\u6458\u8981", "\u4e1a\u52a1\u53d1\u751f\u65e5\u671f", "\u501f\u65b9", "\u8d37\u65b9", "\u5bf9"});
        this.ldgTable.setRwFlags(60, true);
        this.ldgTable.setAcceptActionCommands(new String[]{"check", "uncheck"});
        TableColumn tablecolumn = this.ldgTable.getColumn("vdate");
        tablecolumn.setOptions(256, true);
        tablecolumn = this.ldgTable.getColumn("svno");
        tablecolumn.setOptions(256, true);
        tablecolumn.setDataType(16);
        tablecolumn.setDisplayWidth(64);
        tablecolumn.setTableCellDataAccess(new ErpTableVouTypeVouNoCellDataAccess("vtypeno"));
        tablecolumn = this.ldgTable.getColumn("qcode");
        tablecolumn.setOptions(256, true);
        tablecolumn = this.ldgTable.getColumn("expl");
        tablecolumn.setOptions(256, true);
        tablecolumn = this.ldgTable.getColumn(String.valueOf(this.fldname) + "debit");
        tablecolumn.setOptions(256, true);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fldname, "vdc", 1));
        tablecolumn = this.ldgTable.getColumn(String.valueOf(this.fldname) + "credit");
        tablecolumn.setOptions(256, true);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fldname, "vdc", -1));
        this.ldgCheckColumn = tablecolumn = this.ldgTable.getColumn("ldgcheck");
        tablecolumn.setDataType(11);
        tablecolumn.setTableCellDataAccess(new ErpBnkMonthCellDataAccess("bankmonth", this.manualCheckedWord, this.vmonthDataType));
        this.ldgTable.setDataSet((DataSet)this.ldgDataSet);
        this.ldgTable.initial();
    }

    public static void manualBnkCheck() throws DataSetException {
        int i = ErpConfig.getBnkCheckByBCodeLevl();
        if (!ErpBnkDialogPanel.askBnkCheck(i <= 0 ? 3 : 7, false, 3, false, 1, "\u624b\u5de5\u5bf9\u5e10")) {
            return;
        }
        String s = i <= 0 ? null : ErpPubl.bnkBCode;
        String s1 = (ErpPubl.bnkACodeProperty & 0x1000) == 0 ? null : ErpPubl.bnkFCode;
        ErpManualBnkCheck snamanualbnkcheck = new ErpManualBnkCheck(ErpPubl.ymd[0], ErpPubl.ymd[1], ErpPubl.bnkACode, s, s1, (ErpPubl.nBnkOption & 1) != 0);
        snamanualbnkcheck.addDataSet((DataSet)snamanualbnkcheck.sheetDataSet);
        snamanualbnkcheck.addDataSet((DataSet)snamanualbnkcheck.ldgDataSet);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = snamanualbnkcheck.ldgTable.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension1.width, (dimension.height - 180) / 2);
        snamanualbnkcheck.ldgTable.setPreferredSize(dimension2);
        snamanualbnkcheck.sheetTable.setPreferredSize(dimension2);
        String s2 = ErpPubl.ymd[0] + "\u5e74" + ErpPubl.ymd[1] + "\u6708\u624b\u5de5\u5bf9\u5e10[\u5e10\u6237:" + ErpPubl.bnkACode;
        if (s != null) {
            s2 = String.valueOf(s2) + ",\u90e8\u95e8:" + s;
        }
        if (s1 != null) {
            s2 = String.valueOf(s2) + ",\u5e01\u79cd:" + s1;
        }
        s2 = String.valueOf(s2) + ']';
        JSplitPane jsplitpane = new JSplitPane(0, new ScrollBarPanel(snamanualbnkcheck.sheetTable, 3), new ScrollBarPanel(snamanualbnkcheck.ldgTable, 3));
        jsplitpane.setUI(new NoKeyActionsSplitPaneUI());
        if (MainApp.javaVersion >= 304) {
            jsplitpane.setResizeWeight(0.5);
        }
        snamanualbnkcheck.createSqlInternalFrame(s2, jsplitpane, new JComponent[]{snamanualbnkcheck.sheetTable, snamanualbnkcheck.ldgTable}, snamanualbnkcheck.sheetTable);
    }
}

