/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpRowFilter;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class ErpNCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] ncodeLevl;
    private Variant variant = new Variant();
    int levl;
    int levlDataType;
    private Hashtable codeHash;
    private Hashtable parmHash = new Hashtable();
    TableColumn ncodeColumn;
    private String oldNCode = "";

    public ErpNCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u8bb0\u5f55\uff1f");
        this.bQuery = flag;
        if (!flag) {
            try {
                this.ncodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 14 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x200) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x200) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select ncode from balance where ncode<>' ' group by ncode order by ncode", "select ncode from ivoucher where ncode<>' ' group by ncode order by ncode"}, 0, -1, this.ncodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldNCode = this.dataSet.getString("ncode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldNCode = this.dataSet.getString("ncode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldNCode.length() > 0 && this.codeHash.get(this.oldNCode) != null;
        this.setRwFlags(32, flag1);
        if (this.ncodeColumn != null) {
            this.ncodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",nname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void print() {
        try {
            ErpPubl.printTable("NCODE", this.dataSet, 14);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getNCodeTitle());
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getNCodeTitle());
            this.addLoged = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("ncode")) {
            try {
                String s = dataset.getString("ncode");
                int i = s != null ? s.length() : 0;
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.ncodeLevl, i, false) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        super.keyPressed(keyevent);
        try {
            int i = keyevent.getKeyCode();
            if (i == 120) {
                ErpPubl.filterTable(this, null, "\u8fc7\u6ee4", this.parmHash, null);
            }
            if (keyevent.isControlDown()) {
                switch (i) {
                    case 76: {
                        ErpPubl.locateTable(this, this.parmHash);
                        break;
                    }
                    case 90: {
                        ErpPubl.filterTable(this, null);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void find() {
        try {
            ErpPubl.locateTable(this, null, "\u5b9a\u4f4d", this.parmHash);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("ncode");
            if (this.levl < 0) {
                s = String.valueOf(s) + "\u7f16\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldNCode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('n');
                if (Utilities.seekDataSet(dataset, "ncode", s1)) {
                    s = String.valueOf(s) + "\u7f16\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.ncodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u7684\u7f16\u7801" + s2 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupNCode(boolean flag) throws DataSetException {
        ErpNCodeTable snancodetable = new ErpNCodeTable(flag);
        snancodetable.setDatasetTablename("ncode");
        snancodetable.addColumns(new String[]{"ncode", "nname", "shortcode"}, new String[]{"\u7f16\u7801", "\u540d\u79f0", "\u7b80\u7801"});
        TableColumn tablecolumn = snancodetable.getColumn("nname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(240);
        snancodetable.ncodeColumn = snancodetable.getColumn("ncode");
        snancodetable.ncodeColumn.setOptions(32768, true);
        snancodetable.setFlagSelectedOptions(8202);
        DataSet dataset = ErpPubl.getSharedTblDataSet("ncode");
        ErpPubl.addYmdepcAndUCodeFilterColumn(snancodetable, dataset);
        Column column = dataset.getColumn("levl");
        snancodetable.levlDataType = column.getDataType();
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        try {
            ErpRowFilter snarowfilter = new ErpRowFilter(7, "ncode", snancodetable, null);
            snarowfilter.setCodePtn(null);
            datasetview.addRowFilterListener((RowFilterListener)snarowfilter);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame(ErpConfig.getNCodeTitle(), snancodetable, (DataSet)datasetview, true);
    }
}

