/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.StorageDataSet;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class ErpRCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] rcodeLevl;
    private Hashtable codeHash;
    TableColumn rcodeColumn;
    private String oldRCode = "";

    public ErpRCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u73b0\u91d1\u7c7b\u522b\uff1f");
        if (!flag) {
            try {
                this.rcodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 17 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x400) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x400) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select rcode from ivoucher where rcode<>' ' group by rcode order by rcode"}, 0, -1, this.rcodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldRCode = this.dataSet.getString("rcode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldRCode = this.dataSet.getString("rcode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldRCode.length() > 0 && this.codeHash.get(this.oldRCode) != null;
        this.setRwFlags(32, flag1);
        if (this.rcodeColumn != null) {
            this.rcodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",rname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void print() {
        try {
            ErpPubl.printTable("\u73b0\u91d1\u7c7b\u522b", this.dataSet, 17);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u73b0\u91d1\u7c7b\u522b");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u73b0\u91d1\u7c7b\u522b");
            this.addLoged = true;
        }
    }

    public void find() {
        ErpPubl.find(this, "rcode");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("rcode");
            int i = ErpPubl.codeLevlMatched(this.rcodeLevl, s1.trim().length(), false);
            if (i < 0) {
                s = String.valueOf(s) + "\u7f16\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldRCode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('r');
                if (Utilities.seekDataSet(dataset, "rcode", s1)) {
                    s = String.valueOf(s) + "\u7f16\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.rcodeLevl, i)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u7684\u7f16\u7801" + s2 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupRCode(boolean flag) throws DataSetException {
        ErpRCodeTable snarcodetable = new ErpRCodeTable(flag);
        snarcodetable.setDatasetTablename("rcode");
        snarcodetable.addColumns(new String[]{"rcode", "rname", "rdc", "dividecl"}, new String[]{"\u7f16\u7801", "\u8bf4\u660e", "\u6536\u5165\u652f\u51fa", "\u62c6\u5206\u63cf\u8ff0"});
        snarcodetable.rcodeColumn = snarcodetable.getColumn("rcode");
        snarcodetable.rcodeColumn.setOptions(0x308000, true);
        TableColumn tablecolumn = snarcodetable.getColumn("rname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(320);
        tablecolumn = snarcodetable.getColumn("rdc");
        tablecolumn.setDisplayWidth(48);
        tablecolumn.setOptions(0x2000008, true);
        short[] sArray = new short[3];
        sArray[1] = 1;
        sArray[2] = -1;
        String[] stringArray = new String[3];
        stringArray[1] = "\u6536\u5165";
        stringArray[2] = "\u652f\u51fa";
        tablecolumn.createShortStringMap(sArray, stringArray);
        ErpPubl.addExtraTableColumn(snarcodetable, 17, 101);
        DataSet dataset = ErpPubl.getSharedTblDataSet("rcode");
        ErpPubl.addYmdepcAndUCodeFilterColumn(snarcodetable, dataset);
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame("\u73b0\u91d1\u7c7b\u522b", snarcodetable, (DataSet)datasetview, true);
    }
}

