/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.RowFilterResponse;
import com.borland.dx.dataset.Variant;
import softcore.table.CodeNameMap;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.util.Message;
import softcore.util.Utilities;

public class ErpRowFilter
implements RowFilterListener {
    private int filterId;
    private String codePtn;
    private String columnName;
    private int levlid = 0;
    private int property = 0;
    private int equalValue;
    private Table table;
    public Object[][] filters;
    private String[] codePtns;
    private Variant variant = new Variant();

    public void setCodePtn(String s) {
        this.codePtn = s;
    }

    public void setCodePtns(String[] as) {
        this.codePtns = as;
    }

    public void setCodePtn(String s, Object[][] aobj) {
        this.codePtn = s;
        this.filters = aobj;
    }

    public void setColumnName(String s) {
        this.columnName = s;
    }

    public void setLevlid(int i) {
        this.levlid = i;
    }

    public void setEqualValue(int i) {
        this.equalValue = i;
    }

    public String getCodePtn() {
        return this.codePtn;
    }

    public ErpRowFilter(int i, String s, String s1) {
        this.filterId = i;
        this.columnName = s;
        this.codePtn = s1;
    }

    public ErpRowFilter(int i, String s) {
        this.filterId = i;
        this.columnName = s;
    }

    public ErpRowFilter(int i, String s, Table table1, Object[][] aobj) {
        this.filterId = i;
        this.columnName = s;
        this.table = table1;
        this.filters = aobj;
    }

    public ErpRowFilter(int i, String s, int j) {
        this.filterId = i;
        this.columnName = s;
        this.property = j;
    }

    public ErpRowFilter(int i) {
        this.filterId = i;
    }

    public void setRowFilter(int i, String s) {
        if (i >= 0) {
            this.filterId = i;
        }
        if (s != null) {
            this.columnName = s;
        }
    }

    private boolean match(ReadRow readrow) {
        if (this.filters == null) {
            return true;
        }
        boolean flag = true;
        int i = 0;
        while (i < this.filters.length) {
            String s = (String)this.filters[i][0];
            boolean flag1 = false;
            if (s.charAt(0) == ',') {
                flag1 = true;
                s = s.substring(1);
            }
            String s1 = null;
            try {
                s1 = readrow.getString(s);
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
            if (flag1) {
                TableColumn tablecolumn = this.table.getColumn(s);
                CodeNameMap codenamemap = tablecolumn.getCodeNameMap();
                String s2 = null;
                if (codenamemap != null) {
                    s2 = (tablecolumn.options & 0x400) != 0 ? Utilities.findFullname(codenamemap, s1) : codenamemap.getNameByCode(s1);
                }
                if (s2 == null || s2.indexOf((String)this.filters[i][1]) < 0) {
                    flag = false;
                }
            } else if (s.endsWith("code") && (s1 == null || !s1.startsWith((String)this.filters[i][1]))) {
                flag = false;
            } else if (s1 == null || s1.indexOf((String)this.filters[i][1]) < 0) {
                flag = false;
            }
            if (!flag) break;
            ++i;
        }
        return flag;
    }

    public boolean levlCodeMatch(String s, int i) {
        if (this.codePtns == null || this.codePtns.length == 0) {
            return this.likeCodePtn(s) && i <= this.levlid;
        }
        if (i > this.levlid) {
            return false;
        }
        if (this.likeCodePtn(s)) {
            return true;
        }
        int j = 0;
        while (j < this.codePtns.length) {
            int k = s.length();
            if (k <= this.codePtns[j].length() && s.equals(this.codePtns[j].substring(0, k))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void filterRow(ReadRow readrow, RowFilterResponse rowfilterresponse) {
        boolean flag = true;
        try {
            if (this.filterId == 1) {
                flag = this.likeCodePtn(readrow.getString(this.columnName));
            } else if (this.filterId == 2) {
                readrow.getVariant("levl", this.variant);
                int i = this.variant.isNull() ? 0 : this.variant.getAsInt();
                flag = this.levlCodeMatch(readrow.getString(this.columnName), i);
            } else if (this.filterId == 3) {
                readrow.getVariant(this.columnName, this.variant);
                int j = this.variant.isNull() ? 0 : this.variant.getAsInt();
                flag = (j & this.property) != 0;
            } else if (this.filterId == 4) {
                readrow.getVariant(this.columnName, this.variant);
                int k = this.variant.isNull() ? 0 : this.variant.getAsInt();
                flag = k == this.equalValue;
            } else if (this.filterId == 5) {
                readrow.getVariant(this.columnName, this.variant);
                flag = !this.codePtn.equals(this.variant.getString());
            } else if (this.filterId == 6) {
                readrow.getVariant("levl", this.variant);
                int l = this.variant.isNull() ? 0 : this.variant.getAsInt();
                readrow.getVariant("ymdeprecated", this.variant);
                flag = (this.variant.isNull() || this.variant.getAsInt() > this.equalValue) && this.levlCodeMatch(readrow.getString(this.columnName), l);
            } else if (this.filterId == 7) {
                flag = this.likeCodePtn(readrow.getString(this.columnName)) && this.match(readrow);
            } else if (this.filterId == 100) {
                String s = readrow.getString(this.columnName);
                flag = this.codePtn == null || this.codePtn.length() == 0 || s != null && s.startsWith(this.codePtn) && s.length() > this.codePtn.length();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        if (flag) {
            rowfilterresponse.add();
        } else {
            rowfilterresponse.ignore();
        }
    }

    boolean likeCodePtn(String s) {
        if (this.codePtn == null || this.codePtn.length() <= 0) {
            return true;
        }
        return Utilities.likeOneOf(s, this.codePtn, false);
    }
}

