/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpdata;

import com.borland.dx.sql.dataset.Database;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.PreprocessedTextReader;
import softcore.util.Utilities;
import softcore.yacc.Yacc;
import softface.MainApp;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;
import softoperation.finance.erpdata.CreateDatabase;
import softoperation.finance.erpdata.Erpdata;

public class ErpdataConfig
implements Cloneable {
    public static ErpdataConfig currentConfig;
    public static Database database;
    final Hashtable configProperties = new Hashtable();
    public static String IPAdress;
    public int idSystem;
    public String nameSystem;
    public String idWorkSpace;
    public String nameWorkSpace;
    public String curUserCode;
    public String userName;
    public String curUserBcode;
    public String userPcode;
    public boolean userWRLimit;
    public String curBCode;
    public String fullUserName;
    public String userPassword;
    public boolean bAdministrator = false;
    public String curWCode;
    public String curBCodeLimit;
    public String curVTypeLimit;
    public int sndataVersion;
    public String dataSrvIP;
    public String dataSrvDBName;

    public static void setCurrentConfig(ErpdataConfig sndataconfig, boolean flag) {
        currentConfig = sndataconfig;
        if (flag) {
            JDBC.defaultJdbcConnection = currentConfig.getDefaultJdbcConection();
        }
        if (database == null) {
            database = new Database();
        }
        database.setJdbcConnection(JDBC.defaultJdbcConnection);
        JDBC.currentDatabaseType = Utilities.findAtStringArray(JDBC.supportedDatabaseTypeName, sndataconfig.getConfigProperty("DatabaseType"));
        if (JDBC.currentDatabaseType < 0) {
            throw new RuntimeException("Unknown DatabaseType");
        }
    }

    public static ErpdataConfig getCurrentConfig() {
        return currentConfig;
    }

    public static boolean sureCurrentConfigOk() {
        return ErpdataConfig.sureCurrentConfigOk(2);
    }

    public static boolean sureCurrentConfigOk(int i) {
        if (currentConfig == null) {
            if ((i & 1) != 0) {
                Message.out.println("\u767b\u5f55\u540e\u624d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002");
            }
            if ((i & 2) != 0) {
                Message.showInformationDialog("\u672a\u767b\u5f55", "\u767b\u5f55\u540e\u624d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002");
            }
            return false;
        }
        return true;
    }

    public Dictionary getConfigProperties() {
        return this.configProperties;
    }

    public String getConfigProperty(String s) {
        return (String)this.configProperties.get(s);
    }

    public String toString() {
        return "SNDATACONFIG:idSystem=" + this.idSystem + ",idWorkSpace=" + this.idWorkSpace + ",userName=" + this.userName + ",curUserCode=" + this.curUserCode + ",curBCodeLimit=" + this.curBCodeLimit + ",curVTypeLimit=" + this.curVTypeLimit;
    }

    public ErpdataConfig cloneObject() throws CloneNotSupportedException {
        return (ErpdataConfig)this.clone();
    }

    public String getAppTitle(String s) {
        if (s == null) {
            s = MainApp.getAppName();
        }
        return String.valueOf(s) + '\uff0d' + this.idWorkSpace + ':' + this.nameWorkSpace + '\uff0d' + (this.fullUserName != null ? this.fullUserName : this.userName);
    }

    public String getPromptText() {
        return String.valueOf(this.nameSystem) + '\n' + this.idWorkSpace + ':' + this.nameWorkSpace + '\n' + (this.fullUserName != null ? this.fullUserName : this.userName);
    }

    public void configWorkSpace(String s1, String s2, String s3, String s4, Vector vector) {
        this.nameWorkSpace = s2;
        this.idWorkSpace = s1;
        this.curUserCode = s3;
        this.userName = s4;
        this.configProperties.clear();
        int j = s1.length() + 1;
        s1 = String.valueOf(s1) + '.';
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int k;
            String s5 = (String)enumeration.nextElement();
            if (!s5.startsWith(s1) || (k = s5.indexOf(61)) <= 0) continue;
            this.configProperties.put(s5.substring(j, k), s5.substring(k + 1));
        }
    }

    public Connection getJdbcConection() throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        return ErpdataConfig.getJdbcConection(this.configProperties, true);
    }

    static Connection getJdbcConection(Dictionary dictionary) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        return ErpdataConfig.getJdbcConection(dictionary, true);
    }

    static Connection getJdbcConection(Dictionary dictionary, boolean flag) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String[] as = ErpdataConfig.parseDatabaseDriver(dictionary);
        if (as == null) {
            return null;
        }
        Class.forName(as[0]);
        return JDBC.getConnection(as[1], flag);
    }

    public Connection getDefaultJdbcConection() {
        try {
            return this.getJdbcConection();
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
            return null;
        }
    }

    public static Connection getJdbcConnectionOfWorkSpace(String s, Dictionary dictionary) throws IOException, Yacc.YaccErrorException, ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        return ErpdataConfig.getJdbcConnectionOfWorkSpace(s, dictionary, true);
    }

    public static Connection getJdbcConnectionOfWorkSpace(String s, Dictionary dictionary, boolean flag) throws IOException, Yacc.YaccErrorException, ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        if (currentConfig != null && ErpdataConfig.currentConfig.idWorkSpace.equals(s)) {
            if (dictionary != null) {
                Utilities.dupDictionary(dictionary, ErpdataConfig.currentConfig.configProperties);
            }
            return ErpdataConfig.getJdbcConection(ErpdataConfig.currentConfig.configProperties, flag);
        }
        return (dictionary = ErpdataConfig.loadWorkSpaceAsDictionary(s, dictionary)) != null ? ErpdataConfig.getJdbcConection(dictionary, flag) : null;
    }

    public static Connection getJdbcConnectionOfWorkSpace(String s) throws IOException, Yacc.YaccErrorException, ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        return ErpdataConfig.getJdbcConnectionOfWorkSpace(s, null);
    }

    public static String[] parseDatabaseDriver(Dictionary dictionary) {
        String s4;
        String s = (String)dictionary.get("DatabaseDriver");
        if (s != null && s.startsWith("JdbcDriver.")) {
            s = CreateDatabase.dbProperties.getProperty(s);
        }
        if (s == null) {
            throw new RuntimeException("DatabaseDriver not defined.");
        }
        s = Utilities.removeBrackets(s, '\"', '\"');
        int i = s.indexOf(59);
        String s1 = (String)dictionary.get("RmiJdbcHost");
        String s2 = Utilities.removeBrackets((String)dictionary.get("HttpUrl"), '\"', '\"');
        if ("*".equals(s2)) {
            s2 = null;
            String s3 = Utilities.getUrlSimpleServer();
            if (s3 != null) {
                try {
                    URL url = new URL(s3);
                    s2 = "http://" + url.getHost() + ":" + url.getPort() + "/h9soft";
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
        }
        if (s2 != null && s2.trim().length() == 0) {
            s2 = null;
        }
        if ((s4 = s.substring(0, i)).equals("JdbcOdbcDriver")) {
            s4 = "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        String s5 = s4;
        if (s1 != null) {
            s4 = "RmiJdbc.RJDriver";
        }
        if (s2 != null) {
            s4 = "h9soft.HttpJdbc.HJDriver";
        }
        Dictionary dictionary1 = Utilities.dupDictionary(null, dictionary);
        String s6 = (String)dictionary1.get("ServerAddr");
        try {
            s6 = Utilities.convertPasswordString(s6, false);
            if (s6 != null) {
                dictionary1.put("ServerAddr", s6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String s7 = (String)dictionary1.get("DatabaseName");
        try {
            s7 = Utilities.convertPasswordString(s7, false);
            if (s7 != null) {
                dictionary1.put("DatabaseName", s7);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String s8 = (String)dictionary1.get("DatabaseUser");
        try {
            s8 = Utilities.convertPasswordString(s8, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dictionary1.put("DatabaseUser", s8 != null ? s8 : "");
        String s9 = (String)dictionary1.get("DatabasePassword");
        try {
            s9 = Utilities.convertPasswordString(s9, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dictionary1.put("DatabasePassword", s9 != null ? s9 : "");
        String s10 = Utilities.macroReplace(s.substring(i + 1), dictionary1, '[', ']');
        if (s2 != null) {
            s10 = "jdbc:" + s2 + "/jdbc?" + s10;
        } else if (s1 != null) {
            s10 = "jdbc:rmi://" + s1 + "/" + s10;
        }
        return new String[]{s4, s10};
    }

    public static ErpdataConfig newErpdataConfig(String accountNO, String accountNanme, String bcode, String wname, Vector accountVector) {
        ErpdataConfig sndataconfig = new ErpdataConfig();
        sndataconfig.configWorkSpace(accountNO, accountNanme, bcode, wname, accountVector);
        return sndataconfig;
    }

    static boolean forceLoadWsFromURL() {
        try {
            return "true".equalsIgnoreCase(System.getProperty("FORCELOADWSFROMURL"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean loadWorkSpace(String s, Vector vector, Dictionary dictionary) throws IOException, Yacc.YaccErrorException {
        boolean bl;
        InputStream obj;
        Socket socket;
        block40: {
            boolean flag;
            block39: {
                File file;
                String s2;
                block38: {
                    socket = null;
                    obj = null;
                    try {
                        s2 = Utilities.getUserDir();
                        s2 = String.valueOf(s2) + "/cdata";
                        file = new File(String.valueOf(s2) + "/h9WorkSpace.txt");
                        Utilities.makeDirForFilename(file.getAbsolutePath());
                        obj = file.toURL().openStream();
                    }
                    catch (Exception exception) {
                        if (!MainApp.isDebug) break block38;
                        exception.printStackTrace(Message.out);
                    }
                }
                if (!"true".equalsIgnoreCase(System.getProperty("LOCALWORKSPC")) && (obj == null || ErpdataConfig.forceLoadWsFromURL())) {
                    String s1 = MainApp.guessDefaultWebURL();
                    System.out.println("Load " + s1 + "/h9WorkSpace.txt");
                    if (s1 != null) {
                        URL url = new URL(String.valueOf(s1) + "/h9WorkSpace.txt");
                        URLConnection urlconnection = url.openConnection();
                        obj = urlconnection.getInputStream();
                    }
                }
                if (obj == null) {
                    try {
                        s2 = System.getProperty("WSPATH");
                        if (s2 != null) {
                            file = new File(String.valueOf(s2) + "/h9WorkSpace.txt");
                            System.out.println("Load " + file.getAbsolutePath());
                            obj = new FileInputStream(file);
                        }
                    }
                    catch (Exception exception1) {
                        if (!MainApp.isDebug) break block39;
                        exception1.printStackTrace(Message.out);
                    }
                }
            }
            if (obj != null) break block40;
            Message.out.println("\u4e0d\u80fd\u88c5\u8f7d\u8d26\u5957\u914d\u7f6e\u6587\u4ef6.");
            boolean bl2 = flag = false;
            Object var13_14 = null;
            try {
                ((InputStream)obj).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception throwable) {
                    // empty catch block
                }
            }
            return bl2;
        }
        try {
            boolean flag1;
            String s4;
            PreprocessedTextReader preprocessedtextreader = new PreprocessedTextReader(new InputStreamReader(obj));
            String s3 = null;
            int i = 0;
            while ((s4 = preprocessedtextreader.readLine()) != null) {
                int k;
                int j = Utilities.startWithInt(s4 = s4.trim(), ':', false);
                if (j > 0) {
                    String s6;
                    s3 = s4.substring(0, j);
                    int l = s4.indexOf(9);
                    String s8 = null;
                    if (l > 0) {
                        s6 = s4.substring(j + 1, l);
                        s8 = s4.substring(l + 1);
                    } else {
                        s6 = s4.substring(j + 1);
                    }
                    if (s == null) {
                        if (vector != null) {
                            vector.addElement(String.valueOf(s3) + ".ALIASID=" + s6);
                            if (s8 != null) {
                                vector.addElement(String.valueOf(s3) + ".NAME=" + s8);
                            }
                        }
                        if (dictionary != null) {
                            dictionary.put(String.valueOf(s3) + ".ALIASID", s6);
                            if (s8 != null) {
                                dictionary.put(String.valueOf(s3) + ".NAME", s8);
                            }
                        }
                    } else if (s.equals(s3)) {
                        if (vector != null) {
                            vector.addElement("ALIASID=" + s6);
                            if (s8 != null) {
                                vector.addElement("NAME=" + s8);
                            }
                        }
                        if (dictionary != null) {
                            dictionary.put("ALIASID", s6);
                            if (s8 != null) {
                                dictionary.put("NAME", s8);
                            }
                        }
                    }
                    ++i;
                    continue;
                }
                if (s3 == null || s != null && !s.equals(s3) || (k = s4.indexOf(61)) <= 0) continue;
                String s5 = s4.substring(0, k).trim();
                String s7 = s4.substring(k + 1).trim();
                if (vector != null) {
                    vector.addElement(String.valueOf(s != null ? s5 : String.valueOf(s3) + '.' + s5) + '=' + s7);
                }
                if (dictionary == null) continue;
                dictionary.put(s != null ? s5 : String.valueOf(s3) + '.' + s5, s7);
            }
            if (i == 0) {
                Message.out.println("\u4e0d\u80fd\u88c5\u8f7d\u8d26\u5957\u914d\u7f6e\u6587\u4ef6.");
            }
            bl = flag1 = i > 0;
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            block45: {
                Object var13_16 = null;
                try {
                    ((InputStream)obj).close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (socket == null) break block45;
                try {
                    socket.close();
                }
                catch (Exception throwable2) {}
            }
            throw throwable;
        }
        try {
            obj.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    public static Vector loadWorkSpace(String s) throws IOException, Yacc.YaccErrorException {
        Vector vector = new Vector();
        return ErpdataConfig.loadWorkSpace(s, vector, null) ? vector : null;
    }

    public static Dictionary loadWorkSpaceAsDictionary(String s, Dictionary dictionary) throws IOException, Yacc.YaccErrorException {
        if (dictionary == null) {
            dictionary = new Hashtable();
        }
        return ErpdataConfig.loadWorkSpace(s, null, dictionary) ? dictionary : null;
    }

    public static String getConnectUrlByWorkSpace(String s) throws IOException, Yacc.YaccErrorException, ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        if (s == null && currentConfig != null) {
            s = ErpdataConfig.currentConfig.idWorkSpace;
        }
        Hashtable hashtable = new Hashtable();
        ErpdataConfig.loadWorkSpaceAsDictionary(s, hashtable);
        String[] as = ErpdataConfig.parseDatabaseDriver(hashtable);
        if (as == null) {
            return null;
        }
        return as[1];
    }

    static int guessConnectFailReason(String s) {
        Connection connection;
        Hashtable hashtable = new Hashtable();
        try {
            ErpdataConfig.loadWorkSpaceAsDictionary(s, hashtable);
        }
        catch (Exception exception) {
            return 0;
        }
        String[] as = ErpdataConfig.parseDatabaseDriver(hashtable);
        if (as == null || !"SqlServer".equals(hashtable.get("DatabaseType"))) {
            return 0;
        }
        String[] as1 = CreateDatabase.replaceSqlServerUrlToMaster(as[1]);
        if (as1 == null) {
            return 0;
        }
        String s1 = as1[0];
        String s2 = as1[1];
        try {
            System.out.println("masterUrl=" + s2);
            connection = JDBC.getConnection(s2);
        }
        catch (SQLException sqlexception) {
            return 1;
        }
        try {
            String s3 = "select count(*) from sysdatabases where LOWER(name)='" + s1.toLowerCase() + "'";
            System.out.println(s3);
            if (JDBC.sqlSelectInt(connection, s3) == 0) {
                return 2;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public static String getCurrentUserName() {
        return currentConfig == null ? null : ErpdataConfig.currentConfig.userName;
    }

    public static String getCurrentUserCode() {
        return currentConfig == null ? null : ErpdataConfig.currentConfig.curUserCode;
    }

    public static int getCurrentIdSystem() {
        return currentConfig == null ? -1 : ErpdataConfig.currentConfig.idSystem;
    }

    public static String getCurrentIdWorkSpace() {
        return currentConfig == null ? null : ErpdataConfig.currentConfig.idWorkSpace;
    }

    public static String getCurrentNameWorkSpace() {
        return currentConfig == null ? null : ErpdataConfig.currentConfig.nameWorkSpace;
    }

    public static String getCurrentUserInfo(String s) throws SQLException {
        if (currentConfig == null) {
            return null;
        }
        String s1 = ErpdataConfig.currentConfig.curUserCode;
        if (Erpdata.isAppLoginUserFromBCode(ErpdataConfig.currentConfig.idSystem)) {
            s1 = ErpdataConfig.currentConfig.curWCode;
        }
        return JDBC.sqlSelectString("select " + s + " from users where usercode='" + s1 + "'");
    }

    public static void onCurrentErpdataConfigChanged(ErpdataConfig sndataconfig) {
        if (currentConfig == null) {
            return;
        }
        int i = sndataconfig != null ? sndataconfig.idSystem : 0;
        Frame frame = MainFrame.getMainAppFrame();
        if (frame != null) {
            frame.setTitle(currentConfig.getAppTitle(null));
        }
        JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
        int j = currentConfig != null ? ErpdataConfig.currentConfig.idSystem : 0;
        MainFrame.treePanel.init(j, 1);
    }

    public static void saveCurrentConfigToFile() {
        String s = Utilities.getUserDir();
        if (currentConfig != null && s != null) {
            Properties properties = new Properties();
            ErpdataConfig.loadCurrentConfigFromFile(properties);
            properties.put("last.sysid", "" + ErpdataConfig.currentConfig.idSystem);
            properties.put("last.wordapc", ErpdataConfig.currentConfig.idWorkSpace);
            properties.put("last.usercode", ErpdataConfig.currentConfig.curUserCode);
            properties.put("last.username", ErpdataConfig.currentConfig.userName);
            try {
                properties.put("last.lookAndFeel", UIManager.getLookAndFeel().getClass().getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ErpdataConfig.saveCurrentConfigToFile(properties);
        }
    }

    public static void saveCurrentConfigToFile(Properties properties) {
        String s = Utilities.getUserDir();
        if (currentConfig != null && s != null) {
            try {
                String s1 = String.valueOf(s) + System.getProperty("file.separator") + "CurrentConfig.properties";
                FileWriter filewriter = new FileWriter(s1);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    Object obj1 = properties.get(obj);
                    filewriter.write(obj + "=" + obj1 + "\r\n");
                }
                filewriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean loadCurrentConfigFromFile(Properties properties) {
        String s = Utilities.getUserDir();
        if (s != null) {
            try {
                String s1 = String.valueOf(s) + System.getProperty("file.separator") + "CurrentConfig.properties";
                Utilities.loadProperties((Dictionary)properties, new FileInputStream(s1));
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

