/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpdata;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Variant;
import softcore.table.TableCellDataAccess;
import softcore.table.TableColumn;
import softcore.util.Message;
import softcore.util.Utilities;
import softoperation.finance.erpdata.Erpdata;

public class TableYearMonthCellDataAccess
implements TableCellDataAccess {
    private final String dataColumnName;
    private final int maxAccountMonth;

    public TableYearMonthCellDataAccess() {
        this("ymdeprecated");
    }

    public TableYearMonthCellDataAccess(String s) {
        int i;
        this.dataColumnName = s;
        try {
            i = Erpdata.getMaxAccountMonth();
        }
        catch (Exception exception) {
            i = 12;
        }
        this.maxAccountMonth = i;
    }

    public boolean getTableCellData(DataSet dataset, int i, TableColumn tablecolumn, Variant variant) throws DataSetException {
        if (i < 0) {
            dataset.getVariant(this.dataColumnName, variant);
        } else {
            dataset.getVariant(this.dataColumnName, i, variant);
        }
        if (!variant.isNull()) {
            int j = variant.getAsInt();
            int k = j / 16 + 1900;
            int l = j & 0xF;
            variant.setString("" + k + '-' + l);
        }
        return true;
    }

    public boolean setTableCellData(DataSet dataset, TableColumn tablecolumn, Variant variant) throws DataSetException {
        if (!variant.isNull()) {
            int[] ai;
            String s = String.valueOf(variant.getString()) + "-1";
            if (!Utilities.parseDate(s, ai = new int[3])) {
                Message.showErrorDialog("\u9519\u8bef", "\u5e74\u6708\u683c\u5f0f\u5e94\u4e3ayyyy-mm\uff01");
                return false;
            }
            if (ai[0] < 1901) {
                Message.showErrorDialog("\u9519\u8bef", "\u5e74\u4efd\u8f93\u5165\u9519\u8bef\uff01");
                return false;
            }
            if (ai[1] < 1 || ai[1] > this.maxAccountMonth) {
                Message.showErrorDialog("\u9519\u8bef", "\u6708\u4efd\u8f93\u5165\u9519\u8bef\uff01");
                return false;
            }
            Utilities.setNumberToDataSetColumn((ReadWriteRow)dataset, this.dataColumnName, (Number)new Short((short)((ai[0] - 1900) * 16 + ai[1])));
        } else {
            dataset.setVariant(this.dataColumnName, variant);
        }
        return true;
    }
}

