/*
 * Decompiled with CFR 0.152.
 */
package softoperation.tool;

import java.io.Serializable;
import java.util.GregorianCalendar;

public class Day
implements Cloneable,
Serializable {
    public static int SUNDAY = 1;
    public static int MONDAY = 2;
    public static int TUESDAY = 3;
    public static int WEDNESDAY = 4;
    public static int THURSDAY = 5;
    public static int FRIDAY = 6;
    public static int SATURDAY = 7;
    private int day;
    private int month;
    private int year;

    public Day() {
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        this.year = gregoriancalendar.get(1);
        this.month = gregoriancalendar.get(2) + 1;
        this.day = gregoriancalendar.get(5);
    }

    public Day(int i, int j, int k) {
        this.year = i;
        this.month = j;
        this.day = k;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    public void advance(int i) {
        this.fromJulian(this.toJulian() + i);
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int weekday() {
        return (this.toJulian() + 1) % 7 + 1;
    }

    public int daysBetween(Day day1) {
        return this.toJulian() - day1.toJulian();
    }

    public String toString() {
        return this.year + "-" + this.month + "-" + this.day;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Day day1 = (Day)obj;
        return this.day == day1.day && this.month == day1.month && this.year == day1.year;
    }

    private boolean isValid() {
        Day day1 = new Day();
        day1.fromJulian(this.toJulian());
        return day1.day == this.day && day1.month == this.month && day1.year == this.year;
    }

    private int toJulian() {
        int i = this.year;
        if (this.year < 0) {
            ++i;
        }
        int j = this.month;
        if (this.month > 2) {
            ++j;
        } else {
            --i;
            j += 13;
        }
        int k = (int)(Math.floor(365.25 * (double)i) + Math.floor(30.6001 * (double)j) + (double)this.day + 1720995.0);
        int l = 588829;
        if (this.day + 31 * (this.month + 12 * this.year) >= l) {
            int i1 = (int)(0.01 * (double)i);
            k += 2 - i1 + (int)(0.25 * (double)i1);
        }
        return k;
    }

    private void fromJulian(int i) {
        int j = i;
        int k = 2299161;
        if (i >= k) {
            int l = (int)(((double)(i - 1867216) - 0.25) / 36524.25);
            j += 1 + l - (int)(0.25 * (double)l);
        }
        int i1 = j + 1524;
        int j1 = (int)(6680.0 + ((double)(i1 - 2439870) - 122.1) / 365.25);
        int k1 = (int)((double)(365 * j1) + 0.25 * (double)j1);
        int l1 = (int)((double)(i1 - k1) / 30.6001);
        this.day = i1 - k1 - (int)(30.6001 * (double)l1);
        this.month = l1 - 1;
        if (this.month > 12) {
            this.month -= 12;
        }
        this.year = j1 - 4715;
        if (this.month > 2) {
            --this.year;
        }
        if (this.year <= 0) {
            --this.year;
        }
    }
}

