/*
 * Decompiled with CFR 0.152.
 */
package softoperation.tool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import softcore.awt.DialogPanel;
import softcore.util.AidInputer;
import softcore.util.Message;
import softcore.util.Utilities;
import softoperation.tool.Day;

public class DayPanel
extends DialogPanel
implements MouseMotionListener,
MouseListener,
KeyListener,
AidInputer {
    GridBagLayout gridBagLayout1;
    int[] days;
    String[] title = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    int width = 48;
    int height = 28;
    int top = 50;
    int year;
    int month;
    int day;
    int maxday;
    Font f;
    Font f0;
    FontMetrics fm;
    Day today;
    private JButton yButtonUp;
    private JButton yButtonDown;
    private JButton mButtonUp;
    private JButton mButtonDown;
    private JLabel dateLabel;

    public DayPanel(String s) {
        this.gridBagLayout1 = new GridBagLayout();
        this.days = new int[42];
        this.today = new Day();
        this.yButtonUp = new JButton("\u4e0a\u5e74");
        this.yButtonDown = new JButton("\u4e0b\u5e74");
        this.mButtonUp = new JButton("\u4e0a\u6708");
        this.mButtonDown = new JButton("\u4e0b\u6708");
        this.dateLabel = new JLabel();
        int[] ai = new int[3];
        if (s != null && s.length() > 0) {
            Utilities.parseDate(s, ai);
        } else {
            this.today = new Day();
            ai[0] = this.today.getYear();
            ai[1] = this.today.getMonth();
            ai[2] = this.today.getDay();
        }
        this.setDayPanel(ai[0], ai[1], ai[2]);
    }

    public DayPanel(int i, int j, int k) {
        this.gridBagLayout1 = new GridBagLayout();
        this.days = new int[42];
        this.today = new Day();
        this.yButtonUp = new JButton("\u4e0a\u5e74");
        this.yButtonDown = new JButton("\u4e0b\u5e74");
        this.mButtonUp = new JButton("\u4e0a\u6708");
        this.mButtonDown = new JButton("\u4e0b\u6708");
        this.dateLabel = new JLabel();
        this.setDayPanel(i, j, k);
    }

    public void setDayPanel(int i, int j, int k) {
        this.nPosOption = 8;
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.f = new Font("Dialog", 2, 14);
        this.loadMonthDays(i, j, k);
        JPanel jpanel = new JPanel(new FlowLayout(1));
        jpanel.setLayout(new GridBagLayout());
        this.f0 = new Font("Dialog", 0, 11);
        Dimension dimension = new Dimension(56, 30);
        doListen dolisten = new doListen();
        this.yButtonUp.setFont(this.f0);
        this.yButtonUp.setPreferredSize(dimension);
        this.yButtonUp.setActionCommand("yButtonUp");
        this.mButtonUp.setFont(this.f0);
        this.mButtonUp.setPreferredSize(dimension);
        this.mButtonUp.setActionCommand("mButtonUp");
        this.yButtonDown.setFont(this.f0);
        this.yButtonDown.setPreferredSize(dimension);
        this.yButtonDown.setActionCommand("yButtonDown");
        this.mButtonDown.setFont(this.f0);
        this.mButtonDown.setPreferredSize(dimension);
        this.mButtonDown.setActionCommand("mButtonDown");
        this.yButtonUp.addActionListener(dolisten);
        this.mButtonUp.addActionListener(dolisten);
        this.yButtonDown.addActionListener(dolisten);
        this.mButtonDown.addActionListener(dolisten);
        jpanel.add((Component)this.yButtonUp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 2), 0, 0));
        jpanel.add((Component)this.mButtonUp, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 4), 0, 0));
        jpanel.add((Component)this.dateLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 10, new Insets(0, 2, 0, 2), 0, 0));
        jpanel.add((Component)this.yButtonDown, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 2), 0, 0));
        jpanel.add((Component)this.mButtonDown, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 4), 0, 0));
        this.dateLabel.setFont(this.f);
        this.dateLabel.setPreferredSize(new Dimension(80, 30));
        this.dateLabel.setForeground(Color.red);
        this.add(jpanel);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setPreferredSize(new Dimension(this.width * 7, this.top + this.height * 7));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.fm = g.getFontMetrics(this.f);
        int i = 0;
        while (i < 7) {
            g.setColor(Color.black);
            g.drawRect(this.width * i, this.top + 0, this.width, this.height);
            g.setColor(Color.green);
            g.fillRect(this.width * i + 1, this.top + 1, this.width - 2, this.height - 2);
            g.setColor(Color.red);
            g.setFont(this.f);
            g.drawString(this.title[i], this.width * i + 14, this.top + 18);
            ++i;
        }
        this.onPaintDays(g);
        this.dateLabel.setText(String.valueOf(this.year) + "-" + (this.month <= 9 ? "0" : "") + this.month + "-" + (this.day <= 9 ? "0" : "") + this.day);
    }

    private void onPaintDays(Graphics g) {
        int k = 0;
        while (k < 42) {
            int i = k % 7;
            int j = k / 7 + 1;
            g.setColor(Color.black);
            g.drawRect(this.width * i, this.top + 0, this.width, this.height * (j + 1));
            if (this.days[k] == this.day) {
                g.setColor(Color.blue);
                g.fillRect(this.width * i + 1, this.top + this.height * j + 1, this.width - 1, this.height - 1);
                g.setColor(Color.white);
            } else {
                g.setColor(i != 0 && i != 6 ? Color.black : Color.red);
            }
            g.setFont(this.f);
            int l = this.fm.stringWidth("0");
            int i1 = this.width / 2 - l;
            int j1 = this.fm.getAscent() / 2 + 2;
            if (this.days[k] > 0) {
                g.drawString("" + this.days[k], (this.days[k] >= 10 ? 0 : l) + this.width * i + i1, this.top + this.height * (j + 1) - j1);
            } else {
                g.setColor(Color.lightGray);
                g.fillRect(this.width * i + 1, this.top + this.height * j + 1, this.width - 1, this.height - 1);
            }
            ++k;
        }
    }

    private void loadMonthDays(int i, int j, int k) {
        this.days = new int[42];
        this.year = i;
        this.month = j;
        this.day = k;
        Day day1 = new Day(i, j, 1);
        int l = day1.weekday() - 1;
        while (day1.getMonth() == j) {
            this.days[l] = day1.getDay();
            this.maxday = this.days[l];
            day1.advance(1);
            ++l;
        }
        if (this.day > this.maxday) {
            this.day = this.maxday;
        }
    }

    private int getThisDay(int i, int j) {
        int i1 = 0;
        while (i1 < 42) {
            int k = i1 % 7;
            int l = i1 / 7 + 1;
            if (i >= this.width * k && i <= this.width * k + this.width && j >= this.top + this.height * l && j <= this.top + this.height * l + this.height) {
                return i1;
            }
            ++i1;
        }
        return -1;
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
    }

    public void keyReleased(KeyEvent keyevent) {
        int i = keyevent.getKeyCode();
        Message.out.println("today:" + i);
        if (i == 37 || i == 38) {
            Message.out.println("today:" + this.today.toString());
        }
        if (i == 39 || i == 40) {
            Message.out.println("today:" + this.today.toString());
        }
        if (i != 33 || !keyevent.isControlDown()) {
            // empty if block
        }
        if (i != 34 || !keyevent.isControlDown()) {
            // empty if block
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if (mouseevent.getModifiers() == 16 && mouseevent.getClickCount() == 2) {
            int i = this.getThisDay(mouseevent.getX(), mouseevent.getY());
            if (i < 0) {
                return;
            }
            this.closeFrame();
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        int i = this.getThisDay(mouseevent.getX(), mouseevent.getY());
        if (i < 0) {
            return;
        }
        if (this.days[i] > 0) {
            if (this.days[i] == this.day) {
                return;
            }
            this.day = this.days[i];
            this.today = new Day(this.year, this.month, this.day);
            this.repaint();
        } else if (i < 15) {
            --this.month;
            if (this.month < 1) {
                this.month = 12;
                --this.year;
            }
            this.loadMonthDays(this.year, this.month, this.day);
            this.repaint();
        } else if (i > 15) {
            ++this.month;
            if (this.month > 12) {
                this.month = 1;
                ++this.year;
            }
            this.loadMonthDays(this.year, this.month, this.day);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        int i = this.getThisDay(mouseevent.getX(), mouseevent.getY());
        if (i < 0) {
            return;
        }
        if (this.days[i] > 0) {
            if (this.days[i] == this.day) {
                return;
            }
            this.day = this.days[i];
            this.today = new Day(this.year, this.month, this.days[i]);
            this.repaint();
        }
    }

    public String doAidInput(Component component, String s, int i) {
        int[] ai = new int[3];
        if (s != null && s.length() > 0) {
            Utilities.parseDate(s, ai);
        } else {
            this.today = new Day();
            ai[0] = this.today.getYear();
            ai[1] = this.today.getMonth();
            ai[2] = this.today.getDay();
        }
        DayPanel daypanel = new DayPanel(ai[0], ai[1], ai[2]);
        daypanel.defaultExitButton = -1;
        daypanel.showDialog("\u65e5\u671f");
        return String.valueOf(daypanel.year) + "-" + daypanel.month + "-" + daypanel.day;
    }

    public static void showDay() {
        DayPanel daypanel = new DayPanel(2001, 3, 5);
        daypanel.defaultExitButton = -1;
        if (daypanel.showDialog("\u65e5\u671f") == 0) {
            return;
        }
    }

    class doListen
    implements ActionListener {
        public void actionPerformed(ActionEvent actionevent) {
            if ("yButtonUp".equals(actionevent.getActionCommand())) {
                --DayPanel.this.year;
            } else if ("mButtonUp".equals(actionevent.getActionCommand())) {
                --DayPanel.this.month;
                if (DayPanel.this.month < 1) {
                    DayPanel.this.month = 12;
                    --DayPanel.this.year;
                }
            } else if ("yButtonDown".equals(actionevent.getActionCommand())) {
                ++DayPanel.this.year;
            } else if ("mButtonDown".equals(actionevent.getActionCommand())) {
                ++DayPanel.this.month;
                if (DayPanel.this.month > 12) {
                    DayPanel.this.month = 1;
                    ++DayPanel.this.year;
                }
            }
            DayPanel.this.loadMonthDays(DayPanel.this.year, DayPanel.this.month, DayPanel.this.day);
            DayPanel.this.repaint();
        }

        doListen() {
        }
    }
}

