/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.TableScrollPaneLayout;
import com.borland.dbswing.plaf.basic.BasicJdbTableScrollBarUI;
import com.borland.dbswing.plaf.metal.MetalJdbTableScrollBarUI;
import com.borland.dbswing.plaf.motif.MotifJdbTableScrollBarUI;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class TableScrollPane
extends JScrollPane {
    private boolean paintVerticalDrag = true;
    private boolean verticalScrollSpeedUp = true;

    public TableScrollPane() {
        this(null, 20, 30);
    }

    public TableScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public TableScrollPane(Component view) {
        this(view, 20, 30);
    }

    public TableScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        this.setLayout(new TableScrollPaneLayout());
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (view != null) {
            this.setViewportView(view);
        }
        JLabel upperLeftCorner = new JLabel();
        upperLeftCorner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setCorner("UPPER_LEFT_CORNER", upperLeftCorner);
        this.updateUI();
    }

    public void setPaintDuringVerticalDrag(boolean paintVerticalDrag) {
        this.paintVerticalDrag = paintVerticalDrag;
        if (this.getVerticalScrollBar() != null && this.getVerticalScrollBar() instanceof TableScrollBar) {
            ((TableScrollBar)this.getVerticalScrollBar()).setPaintDuringDrag(paintVerticalDrag);
        }
    }

    public boolean isPaintDuringVerticalDrag() {
        return this.paintVerticalDrag;
    }

    public void setAutoVerticalScrollSpeedUp(boolean verticalScrollSpeedUp) {
        this.verticalScrollSpeedUp = verticalScrollSpeedUp;
        if (this.getVerticalScrollBar() != null && this.getVerticalScrollBar() instanceof TableScrollBar) {
            ((TableScrollBar)this.getVerticalScrollBar()).setAutoScrollSpeedUp(verticalScrollSpeedUp);
        }
    }

    public boolean isAutoVerticalScrollSpeedUp() {
        return this.verticalScrollSpeedUp;
    }

    public JScrollBar createVerticalScrollBar() {
        return new TableScrollBar(this, 1);
    }

    public class TableScrollBar
    extends JScrollPane.ScrollBar {
        private boolean paintDuringDrag = true;
        private boolean autoSpeedUp = true;

        public TableScrollBar(TableScrollPane this$0, int orientation) {
            super(this$0, orientation);
        }

        public void updateUI() {
            String currentLookAndFeel = UIManager.getLookAndFeel().getID();
            if (currentLookAndFeel.equals("Motif")) {
                this.setUI(MotifJdbTableScrollBarUI.createUI(this));
            } else if (currentLookAndFeel.equals("Metal")) {
                this.setUI(MetalJdbTableScrollBarUI.createUI(this));
            } else if (currentLookAndFeel.startsWith("Mac")) {
                super.updateUI();
            } else if (currentLookAndFeel.startsWith("Borland")) {
                super.updateUI();
            } else {
                this.setUI(BasicJdbTableScrollBarUI.createUI(this));
            }
        }

        public void setAutoScrollSpeedUp(boolean autoSpeedUp) {
            this.autoSpeedUp = autoSpeedUp;
        }

        public boolean isAutoScrollSpeedUp() {
            return this.autoSpeedUp;
        }

        public void setPaintDuringDrag(boolean paintDuringDrag) {
            this.paintDuringDrag = paintDuringDrag;
        }

        public boolean isPaintDuringDrag() {
            return this.paintDuringDrag;
        }
    }
}

