/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.orbutil.Element;
import com.sun.corba.se.internal.orbutil.ORBUtility;

public final class TransientObjectManager {
    private ORB orb;
    private int maxSize = 128;
    private Element[] elementArray = new Element[this.maxSize];
    private Element freeList;

    public TransientObjectManager() {
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (int i2 = this.maxSize - 2; i2 >= 0; --i2) {
            this.elementArray[i2] = new Element(i2, this.elementArray[i2 + 1]);
        }
        this.freeList = this.elementArray[0];
    }

    private void doubleSize() {
        int n2;
        Element[] elementArray = this.elementArray;
        int n3 = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        for (n2 = 0; n2 < n3; ++n2) {
            this.elementArray[n2] = elementArray[n2];
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (n2 = this.maxSize - 2; n2 >= n3; --n2) {
            this.elementArray[n2] = new Element(n2, this.elementArray[n2 + 1]);
        }
        this.freeList = this.elementArray[n3];
    }

    public synchronized void deleteServant(byte[] byArray) {
        int n2 = ORBUtility.bytesToInt(byArray, 0);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("deleting servant at index=" + n2);
        }
        this.elementArray[n2].delete(this.freeList);
        this.freeList = this.elementArray[n2];
    }

    public void setOrb(ORB oRB) {
        this.orb = oRB;
    }

    public synchronized byte[] getKey(Object object) {
        for (int i2 = 0; i2 < this.maxSize; ++i2) {
            if (!this.elementArray[i2].valid || this.elementArray[i2].servant != object) continue;
            return this.elementArray[i2].toBytes();
        }
        return null;
    }

    public synchronized Object lookupServant(byte[] byArray) {
        int n2 = ORBUtility.bytesToInt(byArray, 0);
        int n3 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServant called with index=" + n2 + ", counter=" + n3);
        }
        if (this.elementArray[n2].counter == n3 && this.elementArray[n2].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n2].servant;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] byArray) {
        int n2 = ORBUtility.bytesToInt(byArray, 0);
        int n3 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServantData called with index=" + n2 + ", counter=" + n3);
        }
        if (this.elementArray[n2].counter == n3 && this.elementArray[n2].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n2].servantData;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public synchronized byte[] storeServant(Object object, Object object2) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        byte[] byArray = element.getKey(object, object2);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("storeServant returns key for element " + element);
        }
        return byArray;
    }
}

