/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

class COMMarkerSegment
extends MarkerSegment {
    private static final String ENCODING = "ISO-8859-1";

    void print() {
        this.printTag("COM");
        System.out.println("<" + this.getComment() + ">");
    }

    COMMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        this.loadData(jPEGBuffer);
    }

    String getComment() {
        try {
            return new String(this.data, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    COMMarkerSegment(String string) {
        super(254);
        this.data = string.getBytes();
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("com");
        iIOMetadataNode.setAttribute("comment", this.getComment());
        if (this.data != null) {
            iIOMetadataNode.setUserObject(this.data.clone());
        }
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
        this.length = 2 + this.data.length;
        this.writeTag(imageOutputStream);
        imageOutputStream.write(this.data);
    }

    COMMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(254);
        Object object;
        if (node instanceof IIOMetadataNode) {
            object = (IIOMetadataNode)node;
            this.data = (byte[])((IIOMetadataNode)object).getUserObject();
        }
        if (this.data == null) {
            object = node.getAttributes().getNamedItem("comment").getNodeValue();
            if (object != null) {
                this.data = ((String)object).getBytes();
            } else {
                throw new IIOInvalidTreeException("Empty comment node!", node);
            }
        }
    }
}

