/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.net.ConnectionResetException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private PlainSocketImpl impl = null;
    private byte[] temp;
    private Socket socket = null;
    private boolean closing = false;

    public int available() throws IOException {
        return this.impl.available();
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n2 = this.read(this.temp, 0, 1);
        if (n2 <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    static {
        SocketInputStream.init();
    }

    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    protected void finalize() {
    }

    private static native void init();

    public long skip(long l2) throws IOException {
        int n2;
        long l3;
        if (l2 <= 0L) {
            return 0L;
        }
        int n3 = (int)Math.min(1024L, l3);
        byte[] byArray = new byte[n3];
        for (l3 = l2; l3 > 0L && (n2 = this.read(byArray, 0, (int)Math.min((long)n3, l3))) >= 0; l3 -= (long)n2) {
        }
        return l2 - l3;
    }

    void setEOF(boolean bl2) {
        this.eof = bl2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.eof) {
            return -1;
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        if (n3 <= 0 || n2 < 0 || n2 + n3 > byArray.length) {
            if (n3 == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean bl2 = false;
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            n4 = this.socketRead0(fileDescriptor, byArray, n2, n3, this.impl.getTimeout());
            if (n4 > 0) {
                int n5 = n4;
                return n5;
            }
        }
        catch (ConnectionResetException connectionResetException) {
            bl2 = true;
        }
        finally {
            this.impl.releaseFD();
        }
        if (bl2) {
            this.impl.setConnectionResetPending();
            this.impl.acquireFD();
            try {
                n4 = this.socketRead0(fileDescriptor, byArray, n2, n3, this.impl.getTimeout());
                if (n4 > 0) {
                    int n6 = n4;
                    return n6;
                }
            }
            catch (ConnectionResetException connectionResetException) {
            }
            finally {
                this.impl.releaseFD();
            }
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (this.impl.isConnectionResetPending()) {
            this.impl.setConnectionReset();
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        this.eof = true;
        return -1;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    SocketInputStream(PlainSocketImpl plainSocketImpl) throws IOException {
        super(plainSocketImpl.getFileDescriptor());
        this.impl = plainSocketImpl;
        this.socket = plainSocketImpl.getSocket();
    }

    public final FileChannel getChannel() {
        return null;
    }
}

