/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.TimerQueue;
import javax.swing.event.EventListenerList;

public class Timer
implements Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean notify = false;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    Runnable doPostEvent = null;
    private static boolean logTimers;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public int getDelay() {
        return this.delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    synchronized void cancelEvent() {
        this.notify = false;
    }

    synchronized void post() {
        if (!this.notify || !this.coalesce) {
            this.notify = true;
            SwingUtilities.invokeLater(this.doPostEvent);
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void setDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid delay: " + n2);
        }
        this.delay = n2;
    }

    public void setInitialDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + n2);
        }
        this.initialDelay = n2;
    }

    public void setCoalesce(boolean bl2) {
        boolean bl3 = this.coalesce;
        this.coalesce = bl2;
        if (!bl3 && this.coalesce) {
            this.cancelEvent();
        }
    }

    public static void setLogTimers(boolean bl2) {
        logTimers = bl2;
    }

    public void setRepeats(boolean bl2) {
        this.repeats = bl2;
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ActionListener == null ? Timer.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public Timer(int n2, ActionListener actionListener) {
        this.delay = n2;
        this.initialDelay = n2;
        this.doPostEvent = new DoPostEvent();
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        public void run() {
            if (logTimers) {
                System.out.println("Timer ringing: " + Timer.this);
            }
            if (Timer.this.notify) {
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this, 0, null, System.currentTimeMillis(), 0));
                if (Timer.this.coalesce) {
                    Timer.this.cancelEvent();
                }
            }
        }

        Timer getTimer() {
            return Timer.this;
        }

        DoPostEvent() {
        }
    }
}

