/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MetalTreeUI
extends BasicTreeUI {
    private static Color lineColor;
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 2;
    private PropertyChangeListener lineStyleListener = new LineListener();

    protected int getHorizontalLegBuffer() {
        return 4;
    }

    protected boolean isLocationInExpandControl(int n2, int n3, int n4, int n5) {
        if (this.tree != null && !this.isLeaf(n2)) {
            int n6 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() + 6 : 8;
            Insets insets = this.tree.getInsets();
            int n7 = insets != null ? insets.left : 0;
            int n8 = (n7 += (n3 + this.depthOffset - 1) * this.totalChildIndent + this.getLeftChildIndent() - n6 / 2) + n6;
            return n4 >= n7 && n4 <= n8;
        }
        return false;
    }

    protected void decodeLineStyle(Object object) {
        if (object == null || object.equals(LEG_LINE_STYLE_STRING)) {
            this.lineStyle = 2;
        } else if (object.equals(NO_STYLE_STRING)) {
            this.lineStyle = 0;
        } else if (object.equals(HORIZ_STYLE_STRING)) {
            this.lineStyle = 1;
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        lineColor = UIManager.getColor("Tree.line");
        Object object = jComponent.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(object);
        jComponent.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(lineColor);
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n3 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n2 <= -1 || n3 <= -1) {
            return;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            Rectangle rectangle2;
            TreePath treePath = this.getPathForRow(this.tree, i2);
            if (treePath == null || treePath.getPathCount() != 2 || (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i2))) == null) continue;
            graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTreeUI();
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n2, bl2, bl3, bl4);
        }
    }

    class LineListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(MetalTreeUI.LINE_STYLE)) {
                MetalTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            }
        }

        LineListener() {
        }
    }
}

