/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

public class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private long hwnd = 0L;
    private WComponentPeer parent;
    private FilenameFilter fileFilter;

    static {
        WFileDialogPeer.initIDs();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
            String string = resourceBundle.getString("allFiles");
            WFileDialogPeer.setFilterString(string);
        }
        catch (MissingResourceException missingResourceException) {
            WFileDialogPeer.setFilterString("All Files");
        }
    }

    private native void _dispose();

    private native void _hide();

    private native void _show();

    public void disable() {
    }

    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void enable() {
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.setFile(null);
                fileDialog.hide();
            }
        });
    }

    public void hide() {
        WToolkit.getWToolkit().notifyModalityChange(1301);
        this._hide();
    }

    private static native void initIDs();

    void initialize() {
    }

    public void show() {
        new Thread(new Runnable(){

            public void run() {
                WFileDialogPeer.this._show();
                WToolkit.getWToolkit().notifyModalityChange(1300);
            }
        }).start();
    }

    void start() {
    }

    public void toBack() {
    }

    public void toFront() {
    }

    void invalidate(int n2, int n3, int n4, int n5) {
    }

    public void reshape(int n2, int n3, int n4, int n5) {
    }

    public void setResizable(boolean bl2) {
    }

    public boolean requestFocus(boolean bl2, boolean bl3) {
        return false;
    }

    public void setBackground(Color color) {
    }

    public void setForeground(Color color) {
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    WFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
    }

    public void setFont(Font font) {
    }

    public void addDropTarget(DropTarget dropTarget) {
    }

    public void removeDropTarget(DropTarget dropTarget) {
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileFilter = filenameFilter;
    }

    void handleSelected(final String string) {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                String string2;
                int n2 = string.lastIndexOf(File.separatorChar);
                if (n2 == -1) {
                    string2 = "." + File.separator;
                    fileDialog.setFile(string);
                } else {
                    string2 = string.substring(0, n2 + 1);
                    fileDialog.setFile(string.substring(n2 + 1));
                }
                fileDialog.setDirectory(string2);
                fileDialog.hide();
            }
        });
    }

    public void setDirectory(String string) {
    }

    public void setFile(String string) {
    }

    private static native void setFilterString(String var0);

    public void setTitle(String string) {
    }

    boolean checkFilenameFilter(String string) {
        FileDialog fileDialog = (FileDialog)this.target;
        if (this.fileFilter == null) {
            return true;
        }
        File file = new File(string);
        return this.fileFilter.accept(new File(file.getParent()), file.getName());
    }

    void create(WComponentPeer wComponentPeer) {
        this.parent = wComponentPeer;
    }
}

