/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.VariantFormatter;
import java.awt.Component;
import java.io.Serializable;

public class DBColumnAwareSupport
implements AccessListener,
DataChangeListener,
ColumnAware,
Serializable {
    private DataChangeListener dataChangeListener;
    private AccessListener accessListener;
    DataSet dataSet;
    boolean dataSetChanged = false;
    boolean columnChanged = false;
    String columnName;
    int columnOrdinal = -1;
    private Variant value = new Variant();
    boolean liveProperties = false;

    public DBColumnAwareSupport(ColumnAware columnAwareObject) {
        if (columnAwareObject instanceof AccessListener) {
            this.accessListener = (AccessListener)columnAwareObject;
        }
        if (columnAwareObject instanceof DataChangeListener) {
            this.dataChangeListener = (DataChangeListener)columnAwareObject;
        }
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != dataSet) {
            if (this.dataSet != null) {
                this.dataSet.removeAccessListener((AccessListener)this);
                this.dataSet.removeDataChangeListener((DataChangeListener)this);
            }
            this.dataSet = dataSet;
            if (dataSet != null) {
                dataSet.addAccessListener((AccessListener)this);
                dataSet.addDataChangeListener((DataChangeListener)this);
            }
            this.dataSetChanged = true;
            if (this.liveProperties) {
                this.lazyOpen();
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setColumnName(String columnName) {
        if (this.columnName == null || !this.columnName.equals(columnName)) {
            this.columnName = columnName;
            this.columnChanged = true;
            if (this.liveProperties) {
                this.lazyOpen();
            }
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected void lazyOpen() {
        this.liveProperties = true;
        if (this.dataSetChanged || this.columnChanged) {
            if (this.dataSetChanged && this.dataSet != null) {
                try {
                    if (!this.dataSet.isOpen()) {
                        this.dataSet.open();
                    }
                }
                catch (DataSetException e) {
                    this.columnOrdinal = -1;
                    this.dataSetChanged = false;
                    DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
                    return;
                }
            }
            if (this.dataSetChanged || this.columnChanged) {
                this.columnOrdinal = -1;
                if (this.dataSet != null && this.columnName != null) {
                    try {
                        Column column = this.dataSet.hasColumn(this.columnName);
                        if (column != null) {
                            this.columnOrdinal = this.dataSet.getColumn(this.columnName).getOrdinal();
                        }
                    }
                    catch (DataSetException e) {
                        this.columnChanged = false;
                        DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
                        return;
                    }
                }
                this.columnChanged = false;
            }
            this.dataSetChanged = false;
        }
    }

    public boolean isValidDataSetState() {
        return this.dataSet != null && this.dataSet.isOpen() && this.columnOrdinal != -1;
    }

    public Variant getVariant() {
        this.lazyOpen();
        Variant v = new Variant();
        try {
            this.dataSet.getDisplayVariant(this.columnOrdinal, this.dataSet.getRow(), v);
            Variant variant = v;
            return variant;
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
            v.setAssignedNull();
            return v;
        }
    }

    public void setVariant(Variant value) {
        this.lazyOpen();
        try {
            this.dataSet.setDisplayVariant(this.columnOrdinal, value);
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
        }
    }

    public void setObject(Object object) {
        this.lazyOpen();
        try {
            this.value.setAsObject(object, this.getColumn().getDataType());
            this.dataSet.setDisplayVariant(this.columnOrdinal, this.value);
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
        }
    }

    public boolean setFromString(String string) {
        return this.setFromString(string, null);
    }

    public boolean setFromString(String string, Component focusedComponent) {
        this.lazyOpen();
        try {
            this.getColumn().getFormatter().parse(string, this.value);
            this.dataSet.setDisplayVariant(this.columnOrdinal, this.value);
        }
        catch (Exception e) {
            block4: {
                try {
                    ValidationException.invalidFormat((Exception)e, null, null);
                }
                catch (Exception ex) {
                    DBExceptionHandler.handleException(this.dataSet, focusedComponent, ex);
                    if (focusedComponent == null) break block4;
                    focusedComponent.requestFocus();
                }
            }
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setFromString2(String string, Component focusedComponent, DBColumnAwareSupport columnAwareSupport) throws Exception {
        this.lazyOpen();
        try {
            this.getColumn().getFormatter().parse(string, this.value);
            this.dataSet.setDisplayVariant(this.columnOrdinal, this.value);
        }
        catch (Exception e) {
            if (focusedComponent != null) {
                focusedComponent.requestFocus();
            }
            ValidationException.invalidFormat((Exception)e, null, null);
        }
    }

    public int getColumnOrdinal() {
        return this.columnOrdinal;
    }

    public Column getColumn() {
        this.lazyOpen();
        Column column = null;
        try {
            if (this.columnOrdinal == -1) {
                Column column2 = null;
                return column2;
            }
            column = this.dataSet.getColumn(this.columnOrdinal);
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
        }
        return column;
    }

    public void resetValue() {
        this.lazyOpen();
        try {
            this.dataSet.setUnassignedNull(this.columnName);
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
        }
    }

    public boolean isNull() {
        this.lazyOpen();
        try {
            boolean bl = this.dataSet.isNull(this.columnName);
            return bl;
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
            return true;
        }
    }

    public String getFormattedString() {
        VariantFormatter formatter;
        this.lazyOpen();
        Variant data = this.getVariant();
        String text = data.toString();
        Column column = this.getColumn();
        if (column != null && (formatter = column.getFormatter()) != null) {
            try {
                text = formatter.format((Object)data);
            }
            catch (InvalidFormatException e) {
                DBExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return text;
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            this.dataSetChanged = true;
            this.columnChanged = true;
            if (this.liveProperties) {
                this.lazyOpen();
            }
        }
        if (this.accessListener != null) {
            this.accessListener.accessChange(event);
        }
    }

    public void dataChanged(DataChangeEvent event) {
        if (this.dataChangeListener != null) {
            this.dataChangeListener.dataChanged(event);
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
        this.dataChangeListener.postRow(event);
    }
}

