/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBButtonDataBinder;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBLabelDataBinder;
import com.borland.dbswing.DBListDataBinder;
import com.borland.dbswing.DBSliderDataBinder;
import com.borland.dbswing.DBTextDataBinder;
import com.borland.dbswing.DBTreeNavBinder;
import com.borland.dbswing.DBUtilities;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Store;
import com.borland.dx.sql.dataset.Database;
import com.borland.dx.sql.dataset.QueryDataSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.reflect.Method;

public class DBDisposeMonitor
implements WindowListener,
ComponentListener,
Designable,
Serializable {
    private Container container;
    private boolean registeredAsWindowListener;
    private DataSetAware[] dataAwareComponents;
    private boolean closeDataStores = true;
    private boolean closeConnections = true;
    private boolean doOnClosing = true;
    private boolean alreadyCleanedUp = false;

    public void setDataAwareComponentContainer(Container container) {
        if (this.container != container && this.container != null) {
            this.container.removeComponentListener(this);
        }
        this.container = container;
        this.registeredAsWindowListener = false;
        if (container != null) {
            container.addComponentListener(this);
        }
    }

    public Container getDataAwareComponentContainer() {
        return this.container;
    }

    public void setDataSetAwareComponents(DataSetAware[] dataAwareComponents) {
        int i;
        if (this.dataAwareComponents != dataAwareComponents && this.dataAwareComponents != null) {
            for (i = 0; i < this.dataAwareComponents.length; ++i) {
                if (!(this.dataAwareComponents[i] instanceof Component)) continue;
                ((Component)this.dataAwareComponents[i]).removeComponentListener(this);
            }
        }
        this.dataAwareComponents = dataAwareComponents;
        this.registeredAsWindowListener = false;
        for (i = 0; i < dataAwareComponents.length; ++i) {
            if (!(dataAwareComponents[i] instanceof Component)) continue;
            ((Component)dataAwareComponents[i]).addComponentListener(this);
        }
    }

    public DataSetAware[] getDataSetAwareComponents() {
        return this.dataAwareComponents;
    }

    public void setCloseDataStores(boolean closeDataStores) {
        this.closeDataStores = closeDataStores;
    }

    public boolean isCloseDataStores() {
        return this.closeDataStores;
    }

    public void setCloseConnections(boolean closeConnections) {
        this.closeConnections = closeConnections;
    }

    public boolean isCloseConnections() {
        return this.closeConnections;
    }

    public void setExecuteOnWindowClosing(boolean doOnClosing) {
        this.doOnClosing = doOnClosing;
    }

    public boolean isExecuteOnWindowClosing() {
        return this.doOnClosing;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.componentShown(e);
    }

    public void componentShown(ComponentEvent e) {
        if (!this.registeredAsWindowListener) {
            Component c;
            for (c = (Component)e.getSource(); c != null && !(c instanceof Window); c = c.getParent()) {
            }
            if (c != null) {
                ((Window)c).addWindowListener(this);
                this.registeredAsWindowListener = true;
            }
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.doOnClosing) {
            this.doDisposal();
        }
    }

    public void windowClosed(WindowEvent e) {
        this.doDisposal();
    }

    void doDisposal() {
        if (this.alreadyCleanedUp) {
            return;
        }
        if (this.container != null) {
            this.dataAwareComponents = DBUtilities.findDataAwareChildren(this.container);
        }
        DataSet dataSet = null;
        StorageDataSet storageDataSet = null;
        try {
            for (int index = 0; index < this.dataAwareComponents.length; ++index) {
                Database database;
                Method isOpenMethod;
                boolean isOpen;
                Store store;
                if (this.dataAwareComponents[index] == null) continue;
                dataSet = this.dataAwareComponents[index].getDataSet();
                if (dataSet != null) {
                    storageDataSet = dataSet.getStorageDataSet();
                }
                if (this.closeDataStores && storageDataSet instanceof StorageDataSet && (store = storageDataSet.getStore()) != null && store.getClass().getName().equals("com.borland.datastore.DataStore") && (isOpen = ((Boolean)(isOpenMethod = store.getClass().getMethod("isOpen", null)).invoke((Object)store, null)).booleanValue())) {
                    Method closeMethod = store.getClass().getMethod("close", null);
                    closeMethod.invoke((Object)store, null);
                }
                if (this.closeConnections && storageDataSet instanceof QueryDataSet && (database = ((QueryDataSet)storageDataSet).getDatabase()) != null && database.isOpen()) {
                    database.closeConnection();
                }
                this.dataAwareComponents[index].setDataSet(null);
                if (this.dataAwareComponents[index] instanceof DBTextDataBinder) {
                    ((DBTextDataBinder)this.dataAwareComponents[index]).setJTextComponent(null);
                    continue;
                }
                if (this.dataAwareComponents[index] instanceof DBButtonDataBinder) {
                    ((DBButtonDataBinder)this.dataAwareComponents[index]).setAbstractButton(null);
                    continue;
                }
                if (this.dataAwareComponents[index] instanceof DBLabelDataBinder) {
                    ((DBLabelDataBinder)this.dataAwareComponents[index]).setJLabel(null);
                    continue;
                }
                if (this.dataAwareComponents[index] instanceof DBListDataBinder) {
                    ((DBListDataBinder)this.dataAwareComponents[index]).setJList(null);
                    continue;
                }
                if (this.dataAwareComponents[index] instanceof DBSliderDataBinder) {
                    ((DBSliderDataBinder)this.dataAwareComponents[index]).setJSlider(null);
                    continue;
                }
                if (!(this.dataAwareComponents[index] instanceof DBTreeNavBinder)) continue;
                ((DBTreeNavBinder)this.dataAwareComponents[index]).setJTree(null);
            }
        }
        catch (Exception e) {
            DBExceptionHandler.handleException(dataSet, e);
        }
        this.alreadyCleanedUp = true;
    }
}

