/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBLabelSupport;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.ImageFileFilter;
import com.borland.dbswing.ImagePreviewer;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.plaf.UIResource;

public class DBLabelDataBinder
implements PropertyChangeListener,
AccessListener,
DataChangeListener,
NavigationListener,
ColumnAware,
Designable,
MouseListener,
Serializable,
FocusListener {
    private JLabel label;
    private JLabel oldLabel;
    private DBLabelSupport labelSupport = new DBLabelSupport(this);
    private boolean iconEditable = false;
    private JFileChooser fileChooser;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public DBLabelDataBinder() {
    }

    public DBLabelDataBinder(JLabel label) {
        this.setJLabel(label);
    }

    public void setJLabel(JLabel label) {
        if (this.label != null && this.label != label) {
            this.label.removePropertyChangeListener(this);
            this.label.removeMouseListener(this);
        }
        this.label = label;
        if (label != null) {
            label.addPropertyChangeListener(this);
        }
        this.bindColumnProperties();
    }

    public JLabel getJLabel() {
        return this.label;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.labelSupport.dataSet != null) {
            this.labelSupport.dataSet.removeNavigationListener((NavigationListener)this);
        }
        this.labelSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.labelSupport.dataSet.addNavigationListener((NavigationListener)this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.labelSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.labelSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.labelSupport.columnName;
    }

    public void setColumnNameIcon(String columnNameIcon) {
        this.labelSupport.setColumnNameIcon(columnNameIcon);
        this.bindColumnProperties();
    }

    public String getColumnNameIcon() {
        return this.labelSupport.columnNameIcon;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
    }

    public void putIcon(InputStream inputStream) {
        try {
            if (this.canPutIcon()) {
                this.labelSupport.putIcon(inputStream);
            }
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, (Exception)((Object)e));
        }
    }

    private boolean canPutIcon() throws DataSetException {
        return this.labelSupport.isValidDataSetState() && this.labelSupport.columnOrdinalIcon != -1 && this.labelSupport.dataSet.getColumn(this.labelSupport.columnNameIcon).isEditable();
    }

    private void updateLabelDisplay() {
        if (this.labelSupport.isValidDataSetState()) {
            if (this.labelSupport.columnOrdinal != -1) {
                this.label.setText(this.labelSupport.getFormattedString());
            }
            if (this.labelSupport.columnOrdinalIcon != -1) {
                this.label.setIcon(this.labelSupport.getIcon());
            }
        }
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateLabelDisplay();
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.labelSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateLabelDisplay();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldLabel != null) {
            this.oldLabel.removeFocusListener(this);
            this.oldLabel = null;
        }
        if (this.label != null && this.label.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.labelSupport.lazyOpen();
            this.updateLabelDisplay();
            if (this.labelSupport.isValidDataSetState()) {
                this.label.addFocusListener(this);
                this.oldLabel = this.label;
                if (this.labelSupport.columnOrdinal != -1) {
                    Column column = this.labelSupport.getColumn();
                    if (this.label.getHorizontalAlignment() == 2) {
                        this.label.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), true));
                    }
                    if (this.label.getVerticalAlignment() == 0) {
                        this.label.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), false));
                    }
                    if (this.isDefaultProperty(this.label.getBackground()) && column.getBackground() != null) {
                        this.label.setBackground(column.getBackground());
                    }
                    if (this.isDefaultProperty(this.label.getForeground()) && column.getForeground() != null) {
                        this.label.setForeground(column.getForeground());
                    }
                    if (this.isDefaultProperty(this.label.getFont()) && column.getFont() != null) {
                        this.label.setFont(column.getFont());
                    }
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            } else {
                this.updateLabelDisplay();
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            this.dataSetEventsEnabled = true;
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }

    public void setIconEditable(boolean iconEditable) {
        if (this.iconEditable != iconEditable) {
            this.iconEditable = iconEditable;
            if (iconEditable) {
                if (this.label != null) {
                    this.label.addMouseListener(this);
                }
            } else if (this.label != null) {
                this.label.removeMouseListener(this);
            }
        }
    }

    public boolean isIconEditable() {
        return this.iconEditable;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * Loose catch block
     */
    public void mouseClicked(MouseEvent e) {
        block22: {
            try {
                if (e.getClickCount() != 2 || !this.iconEditable) break block22;
                if (this.fileChooser == null) {
                    Frame frame = DBUtilities.getFrame(this.label);
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    this.fileChooser = new JFileChooser();
                    this.fileChooser.setAccessory(new ImagePreviewer(this.fileChooser, frame));
                    this.fileChooser.setMultiSelectionEnabled(false);
                    this.fileChooser.resetChoosableFileFilters();
                    ImageFileFilter fileFilter = new ImageFileFilter();
                    this.fileChooser.addChoosableFileFilter(fileFilter);
                    this.fileChooser.setFileFilter(fileFilter);
                    this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
                    this.fileChooser.setApproveButtonText(Res._LoadImageFile);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (this.fileChooser.showOpenDialog(this.label) != 0) break block22;
                File file = this.fileChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    Frame frame = DBUtilities.getFrame(this.label);
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    BufferedInputStream inputStream = null;
                    try {
                        block23: {
                            inputStream = new BufferedInputStream(new FileInputStream(file));
                            boolean bmpFile = DBUtilities.isBMPFile(inputStream);
                            if (bmpFile || DBUtilities.isGIForJPGFile(inputStream)) {
                                if (this.canPutIcon()) {
                                    this.labelSupport.putIcon(inputStream);
                                } else if (bmpFile) {
                                    Image bmpImage = DBUtilities.makeBMPImage(inputStream);
                                    if (bmpImage != null) {
                                        this.label.setIcon(new ImageIcon(bmpImage));
                                    } else {
                                        JOptionPane.showMessageDialog(this.label, Res._InvalidImageFile, null, 1);
                                    }
                                } else {
                                    this.label.setIcon(new ImageIcon(file.getCanonicalPath()));
                                }
                                break block23;
                            }
                            JOptionPane.showMessageDialog(this.label, Res._InvalidImageFile, null, 1);
                        }
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    if (inputStream != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                    {
                        catch (Exception ex) {
                            DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, ex);
                            Object var8_10 = null;
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                            if (inputStream != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block22;
                        }
                    }
                }
                JOptionPane.showMessageDialog(this.label, Res._FileNotExist, "", 0);
                this.label.repaint();
            }
            catch (Exception ex) {
                DBExceptionHandler.handleException(this.labelSupport.dataSet, this.label, ex);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        DBUtilities.updateCurrentDataSet(this.label, this.labelSupport.dataSet);
    }

    public void focusLost(FocusEvent e) {
    }
}

