/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBDataBinder;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.Variant;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DBTreeNavBinder
implements TreeSelectionListener,
AccessListener,
PropertyChangeListener,
NavigationListener,
DataChangeListener,
ColumnAware,
TreeModelListener,
Designable,
DBDataBinder,
Serializable,
FocusListener {
    private JTree jTree;
    private JTree oldJTree;
    private DataRow locateRow;
    private Variant variant;
    protected TreeSelectionModel treeSelectionModel;
    protected TreeModel treeModel;
    DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    protected boolean ignoreValueChange;
    protected int mode = 0;
    private boolean rebindColumnProperties;
    private boolean useLeafNodesOnly;
    private boolean dataSetEventsEnabled = true;

    public DBTreeNavBinder() {
    }

    public DBTreeNavBinder(JTree jTree) {
        this.setJTree(jTree);
    }

    public void setJTree(JTree jTree) {
        if (this.jTree != null && this.jTree != jTree) {
            this.jTree.removePropertyChangeListener(this);
        }
        this.jTree = jTree;
        if (jTree == null) {
            this.setTreeSelectionModel(null);
            this.setTreeModel(null);
        } else {
            jTree.addPropertyChangeListener(this);
            this.setTreeSelectionModel(jTree.getSelectionModel());
            this.setTreeModel(jTree.getModel());
        }
    }

    public JTree getJTree() {
        return this.jTree;
    }

    public void setTreeSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (treeSelectionModel != null) {
            treeSelectionModel.addTreeSelectionListener(this);
        }
        this.bindColumnProperties();
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.treeSelectionModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this);
        }
        this.treeModel = treeModel;
        if (treeModel != null) {
            treeModel.addTreeModelListener(this);
        }
        this.bindColumnProperties();
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener((NavigationListener)this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener((NavigationListener)this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void setUseLeafNodesOnly(boolean useLeafNodesOnly) {
        this.useLeafNodesOnly = useLeafNodesOnly;
    }

    public boolean isUseLeafNodesOnly() {
        return this.useLeafNodesOnly;
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateSelectedTreeValue();
    }

    protected void updateSelectedTreeValue() {
        if (!this.ignoreValueChange) {
            this.ignoreValueChange = true;
            if (this.columnAwareSupport.isValidDataSetState()) {
                TreeNode node;
                TreePath selectionPath = this.findUserObject((DefaultMutableTreeNode)this.treeModel.getRoot(), this.columnAwareSupport.getVariant().getAsObject());
                if (selectionPath != null && !(node = (TreeNode)selectionPath.getLastPathComponent()).isLeaf() && this.isUseLeafNodesOnly()) {
                    selectionPath = null;
                }
                if (selectionPath == null) {
                    if (this.mode == 2 && !this.columnAwareSupport.isNull()) {
                        this.columnAwareSupport.lazyOpen();
                        this.columnAwareSupport.resetValue();
                    } else if (this.mode == 1) {
                        if (this.jTree != null && !this.columnAwareSupport.getVariant().isUnassignedNull()) {
                            this.jTree.setEnabled(false);
                        }
                    } else {
                        this.treeSelectionModel.clearSelection();
                    }
                } else {
                    if (this.mode == 1 && this.jTree != null && !this.jTree.isEnabled()) {
                        this.jTree.setEnabled(true);
                    }
                    this.treeSelectionModel.setSelectionPath(selectionPath);
                    if (this.jTree != null) {
                        this.jTree.scrollPathToVisible(selectionPath);
                    }
                }
            } else if (this.treeSelectionModel != null) {
                this.treeSelectionModel.clearSelection();
            }
            this.ignoreValueChange = false;
        }
    }

    protected TreePath findUserObject(DefaultMutableTreeNode node, Object object) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject().equals(object)) {
            TreePath path = new TreePath(node.getPath());
            return path;
        }
        Enumeration<TreeNode> nodes = node.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode compareNode = (DefaultMutableTreeNode)nodes.nextElement();
            if (!compareNode.getUserObject().equals(object)) continue;
            TreePath path = new TreePath(compareNode.getPath());
            return path;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreeNode node;
        if (!this.ignoreValueChange && e.getNewLeadSelectionPath() != null && (node = (TreeNode)this.treeSelectionModel.getSelectionPath().getLastPathComponent()) instanceof DefaultMutableTreeNode && (!this.isUseLeafNodesOnly() || node.isLeaf())) {
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState()) {
                try {
                    if (this.locateRow == null) {
                        this.locateRow = new DataRow(this.columnAwareSupport.dataSet, this.columnAwareSupport.getColumnName());
                        this.variant = new Variant();
                    }
                    this.variant.setAsObject(((DefaultMutableTreeNode)node).getUserObject(), this.columnAwareSupport.getColumn().getDataType());
                    this.locateRow.setVariant(this.columnAwareSupport.getColumnName(), this.variant);
                    if (!this.columnAwareSupport.dataSet.locate((ReadRow)this.locateRow, 32)) {
                        JOptionPane.showMessageDialog(this.jTree, Res._NavLocateFailed, null, 1);
                    }
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, (Exception)((Object)ex));
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            this.treeSelectionModel.clearSelection();
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            this.dataSetEventsEnabled = true;
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
        if (e.getPropertyName().equals("selectionModel")) {
            this.setTreeSelectionModel((TreeSelectionModel)e.getNewValue());
        } else if (e.getPropertyName().equals("model")) {
            this.setTreeModel((TreeModel)e.getNewValue());
        }
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateSelectedTreeValue();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    protected void bindColumnProperties() {
        if (this.oldJTree != null) {
            this.oldJTree.removeFocusListener(this);
            this.oldJTree = null;
        }
        if (this.jTree != null && this.jTree.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            this.updateSelectedTreeValue();
            if (this.columnAwareSupport.isValidDataSetState()) {
                this.jTree.addFocusListener(this);
                this.oldJTree = this.jTree;
                Column column = this.columnAwareSupport.getColumn();
                if (this.isDefaultProperty(this.jTree.getBackground()) && column.getBackground() != null) {
                    this.jTree.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.jTree.getForeground()) && column.getForeground() != null) {
                    this.jTree.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.jTree.getFont()) && column.getFont() != null) {
                    this.jTree.setFont(column.getFont());
                }
                if (this.jTree.getCellEditor() == null && column.getItemEditor() instanceof TreeCellEditor) {
                    this.jTree.setCellEditor((TreeCellEditor)column.getItemEditor());
                }
                if (this.jTree.getCellRenderer() == null && column.getItemPainter() instanceof TreeCellRenderer) {
                    this.jTree.setCellRenderer((TreeCellRenderer)column.getItemPainter());
                }
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        if (this.jTree != null && e.getTreePath().equals(this.jTree.getSelectionPath().getParentPath())) {
            int targetIndex = ((TreeNode)this.jTree.getSelectionPath().getParentPath().getLastPathComponent()).getIndex((TreeNode)this.jTree.getSelectionPath().getLastPathComponent());
            int[] childIndices = e.getChildIndices();
            for (int i = 0; i < childIndices.length; ++i) {
                if (childIndices[i] != targetIndex) continue;
                this.valueChanged(new TreeSelectionEvent((Object)this, this.jTree.getSelectionPath(), false, this.jTree.getSelectionPath(), this.jTree.getSelectionPath()));
                break;
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void focusGained(FocusEvent e) {
        DBUtilities.updateCurrentDataSet(this.jTree, this.columnAwareSupport.dataSet);
    }

    public void focusLost(FocusEvent e) {
    }
}

