/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing.plaf.metal;

import com.borland.dbswing.TableScrollPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class MetalJdbTableScrollBarUI
extends MetalScrollBarUI {
    private int speedUpCounter1 = 1;
    private int speedUpCounter2 = 1;
    private TableScrollPane.TableScrollBar tableScrollBar;
    private TableScrollPane tableScrollPane;

    public static ComponentUI createUI(JComponent c) {
        return new MetalJdbTableScrollBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.tableScrollBar = (TableScrollPane.TableScrollBar)c;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new TableTrackListener();
    }

    protected BasicScrollBarUI.ScrollListener createScrollListener() {
        return new TableScrollListener();
    }

    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new TableArrowButtonListener();
    }

    protected boolean isDragging() {
        return this.isDragging;
    }

    protected JScrollBar getScrollBar() {
        return this.scrollbar;
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected JButton getDecrButton() {
        return this.decrButton;
    }

    protected JButton getIncrButton() {
        return this.incrButton;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void scrollByUnit(int direction) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int newValue = delta + this.scrollbar.getValue();
            newValue -= newValue % delta;
            this.scrollbar.setValue(newValue);
        }
    }

    protected void scrollByBlock(int direction) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int oldValue = this.scrollbar.getValue();
            int blockIncrement = this.scrollbar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            int newValue = oldValue + delta;
            newValue -= newValue % this.scrollbar.getUnitIncrement(direction);
            this.scrollbar.setValue(newValue);
            this.trackHighlight = direction > 0 ? 2 : 1;
            Rectangle dirtyRect = this.getTrackBounds();
            this.scrollbar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
        }
    }

    protected BasicScrollBarUI.TrackListener getTrackListener() {
        return this.trackListener;
    }

    protected class TableArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        protected TableArrowButtonListener() {
            super(MetalJdbTableScrollBarUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            MetalJdbTableScrollBarUI.this.speedUpCounter1 = 1;
            MetalJdbTableScrollBarUI.this.speedUpCounter2 = 1;
            super.mouseReleased(e);
        }
    }

    protected class TableScrollListener
    extends BasicScrollBarUI.ScrollListener {
        protected int direction = 1;
        protected boolean useBlockIncrement;

        public TableScrollListener() {
            this(1, false);
        }

        public TableScrollListener(int dir, boolean block) {
            super(MetalJdbTableScrollBarUI.this);
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        public boolean isScrollByBlock() {
            return this.useBlockIncrement;
        }

        public void actionPerformed(ActionEvent e) {
            if (MetalJdbTableScrollBarUI.this.tableScrollBar.isAutoScrollSpeedUp()) {
                int sum = MetalJdbTableScrollBarUI.this.speedUpCounter1 + MetalJdbTableScrollBarUI.this.speedUpCounter2;
                MetalJdbTableScrollBarUI.this.speedUpCounter1 = MetalJdbTableScrollBarUI.this.speedUpCounter2;
                MetalJdbTableScrollBarUI.this.speedUpCounter2 = sum;
            }
            for (int i = 0; i < MetalJdbTableScrollBarUI.this.speedUpCounter1; ++i) {
                if (this.isScrollByBlock()) {
                    MetalJdbTableScrollBarUI.this.scrollByBlock(this.direction);
                    if (MetalJdbTableScrollBarUI.this.getScrollBar().getOrientation() == 1) {
                        if (this.direction > 0) {
                            if (MetalJdbTableScrollBarUI.this.getThumbBounds().y + MetalJdbTableScrollBarUI.this.getThumbBounds().height >= ((TableTrackListener)MetalJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseY()) {
                                ((Timer)e.getSource()).stop();
                                break;
                            }
                        } else if (MetalJdbTableScrollBarUI.this.getThumbBounds().y <= ((TableTrackListener)MetalJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseY()) {
                            ((Timer)e.getSource()).stop();
                            break;
                        }
                    } else if (this.direction > 0) {
                        if (MetalJdbTableScrollBarUI.this.getThumbBounds().x + MetalJdbTableScrollBarUI.this.getThumbBounds().width >= ((TableTrackListener)MetalJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseX()) {
                            ((Timer)e.getSource()).stop();
                            break;
                        }
                    } else if (MetalJdbTableScrollBarUI.this.getThumbBounds().x <= ((TableTrackListener)MetalJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseX()) {
                        ((Timer)e.getSource()).stop();
                        break;
                    }
                } else {
                    MetalJdbTableScrollBarUI.this.scrollByUnit(this.direction);
                }
                if (this.direction > 0 && MetalJdbTableScrollBarUI.this.getScrollBar().getValue() + MetalJdbTableScrollBarUI.this.getScrollBar().getVisibleAmount() >= MetalJdbTableScrollBarUI.this.getScrollBar().getMaximum()) {
                    ((Timer)e.getSource()).stop();
                    break;
                }
                if (this.direction >= 0 || MetalJdbTableScrollBarUI.this.getScrollBar().getValue() > MetalJdbTableScrollBarUI.this.getScrollBar().getMinimum()) continue;
                ((Timer)e.getSource()).stop();
                break;
            }
        }
    }

    protected class TableTrackListener
    extends BasicScrollBarUI.TrackListener {
        int lastDraggedY;

        protected TableTrackListener() {
            super(MetalJdbTableScrollBarUI.this);
        }

        public int getCurrentMouseY() {
            return this.currentMouseY;
        }

        public int getCurrentMouseX() {
            return this.currentMouseX;
        }

        public void mouseDragged(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            if (!MetalJdbTableScrollBarUI.this.getScrollBar().isEnabled() || !MetalJdbTableScrollBarUI.this.isDragging()) {
                return;
            }
            BoundedRangeModel model = MetalJdbTableScrollBarUI.this.getScrollBar().getModel();
            Rectangle thumbR = MetalJdbTableScrollBarUI.this.getThumbBounds();
            if (MetalJdbTableScrollBarUI.this.getScrollBar().getOrientation() == 1) {
                thumbMin = MetalJdbTableScrollBarUI.this.getDecrButton().getY() + MetalJdbTableScrollBarUI.this.getDecrButton().getHeight();
                thumbMax = MetalJdbTableScrollBarUI.this.getIncrButton().getY() - MetalJdbTableScrollBarUI.this.getThumbBounds().height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                MetalJdbTableScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
                float trackLength = MetalJdbTableScrollBarUI.this.getTrackBounds().height;
            } else {
                thumbMin = MetalJdbTableScrollBarUI.this.getDecrButton().getX() + MetalJdbTableScrollBarUI.this.getDecrButton().getWidth();
                thumbMax = MetalJdbTableScrollBarUI.this.getIncrButton().getX() - MetalJdbTableScrollBarUI.this.getThumbBounds().width;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                MetalJdbTableScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
                float trackLength = MetalJdbTableScrollBarUI.this.getTrackBounds().width;
            }
            if (thumbPos == thumbMax) {
                if (MetalJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                    MetalJdbTableScrollBarUI.this.getScrollBar().setValue(model.getMaximum() - model.getExtent());
                } else {
                    this.lastDraggedY = model.getMaximum() - model.getExtent();
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                this.lastDraggedY = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                if (MetalJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                    MetalJdbTableScrollBarUI.this.getScrollBar().setValue(this.lastDraggedY + model.getMinimum());
                } else {
                    this.lastDraggedY -= this.lastDraggedY % MetalJdbTableScrollBarUI.this.getScrollBar().getUnitIncrement(1);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!MetalJdbTableScrollBarUI.this.getScrollBar().isEnabled()) {
                return;
            }
            if (MetalJdbTableScrollBarUI.this.isDragging() && !MetalJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                MetalJdbTableScrollBarUI.this.getScrollBar().setValue(this.lastDraggedY);
            }
            MetalJdbTableScrollBarUI.this.speedUpCounter1 = 1;
            MetalJdbTableScrollBarUI.this.speedUpCounter2 = 1;
            super.mouseReleased(e);
        }
    }
}

