/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

class SynthProgressBarUI
extends ProgressBarUI
implements SynthUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 16);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(16, 146);
    private SynthStyle style;
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean isIndeterminate = false;
    private Animator animator;
    private PropertyChangeListener propertyListener;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    private int animationIndex = 0;
    private int numFrames;
    private int repaintInterval;
    private int cycleTime;
    private static boolean ADJUSTTIMER = true;
    private static boolean DEBUGALL = false;
    private static boolean DEBUGTIMER = false;
    private static boolean BASICDEBUG = false;
    private static boolean LOGSTATS = false;
    private long startTime = 0L;
    private long lastLoopTime = 0L;
    private int numLoops = 0;
    private Rectangle boxRect;
    private Rectangle nextPaintRect;
    private Rectangle componentInnards;
    private Rectangle oldComponentInnards;
    private double delta = 0.0;
    private int maxPosition = 0;

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    private int getCycleTime() {
        return this.cycleTime;
    }

    private int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initCycleTime() {
        this.cycleTime = UIManager.getInt("ProgressBar.cycleTime");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.cycleTime is " + this.cycleTime);
        }
        return this.cycleTime;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.repaintInterval is " + this.repaintInterval);
        }
        return this.repaintInterval;
    }

    SynthProgressBarUI() {
    }

    private void cleanUpIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin cleanUpIndeterminateValues----");
        }
        this.repaintInterval = 0;
        this.cycleTime = 0;
        this.animationIndex = 0;
        this.numFrames = 0;
        this.maxPosition = 0;
        this.delta = 0.0;
        this.nextPaintRect = null;
        this.boxRect = null;
        this.oldComponentInnards = null;
        this.componentInnards = null;
        if (LOGSTATS) {
            this.numLoops = 0;
            this.startTime = this.lastLoopTime = (long)0;
        }
        if (DEBUGALL) {
            System.out.println("----end cleanUpIndeterminateValues----");
        }
    }

    protected void incrementAnimationIndex() {
        int n2 = this.getAnimationIndex() + 1;
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin incrementAnimationIndex----");
            System.out.println("    newValue = " + n2);
            System.out.println("    numFrames = " + this.numFrames);
        }
        if (n2 < this.numFrames) {
            this.setAnimationIndex(n2);
        } else {
            this.setAnimationIndex(0);
            if (LOGSTATS) {
                ++this.numLoops;
                long l2 = System.currentTimeMillis();
                System.out.println("Loop #" + this.numLoops + ": " + (l2 - this.lastLoopTime) + " (" + (l2 - this.startTime) + " total)");
                this.lastLoopTime = l2;
            }
        }
        if (DEBUGALL) {
            System.out.println("----end incrementAnimationIndex----");
        }
    }

    private void initAnimationIndex() {
        if (this.progressBar.getOrientation() == 0 && SynthLookAndFeel.isLeftToRight(this.progressBar)) {
            this.setAnimationIndex(0);
        } else {
            this.setAnimationIndex(this.numFrames / 2);
        }
    }

    private void initIndeterminateDefaults() {
        if (DEBUGALL) {
            System.out.println("----begin initIndeterminateDefaults----");
        }
        this.initRepaintInterval();
        this.initCycleTime();
        if (this.repaintInterval <= 0) {
            this.repaintInterval = 100;
        }
        if (this.repaintInterval > this.cycleTime) {
            this.cycleTime = this.repaintInterval * 20;
            if (DEBUGALL) {
                System.out.println("cycleTime changed to " + this.cycleTime);
            }
        } else {
            int n2;
            int n3 = (int)Math.ceil((double)this.cycleTime / ((double)this.repaintInterval * 2.0));
            if (DEBUGALL && this.cycleTime != (n2 = this.repaintInterval * n3 * 2)) {
                System.out.println("cycleTime being changed to " + n2);
            }
            this.cycleTime = this.repaintInterval * n3 * 2;
        }
        if (BASICDEBUG) {
            System.out.println("    cycle length: " + this.cycleTime);
            System.out.println("    repaint interval: " + this.repaintInterval);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateDefaults----");
        }
    }

    private void initIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin initIndeterminateValues----");
        }
        if (LOGSTATS) {
            this.startTime = this.lastLoopTime = System.currentTimeMillis();
            this.numLoops = 0;
        }
        if (BASICDEBUG) {
            System.out.println("ADJUSTTIMER = " + ADJUSTTIMER);
        }
        this.initIndeterminateDefaults();
        this.numFrames = this.cycleTime / this.repaintInterval;
        this.initAnimationIndex();
        this.boxRect = new Rectangle();
        this.nextPaintRect = new Rectangle();
        this.componentInnards = new Rectangle();
        this.oldComponentInnards = new Rectangle();
        if (BASICDEBUG) {
            System.out.println("    numFrames: " + this.numFrames);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateValues----");
        }
    }

    protected void installDefaults() {
        this.fetchStyle(this.progressBar);
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.progressBar.addChangeListener(this.changeListener);
        this.propertyListener = new PropertyChangeHandler();
        this.progressBar.addPropertyChangeListener(this.propertyListener);
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start(this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
    }

    private void updateSizes() {
        if (DEBUGALL) {
            System.out.println("----begin updateSizes----");
        }
        int n2 = 0;
        if (this.progressBar.getOrientation() == 0) {
            n2 = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            this.maxPosition = this.componentInnards.x + this.componentInnards.width - n2;
        } else {
            n2 = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            this.maxPosition = this.componentInnards.y + this.componentInnards.height - n2;
        }
        if (DEBUGALL) {
            System.out.println("    Updating delta.");
        }
        this.delta = 2.0 * (double)this.maxPosition / (double)this.numFrames;
        if (BASICDEBUG) {
            System.out.println("    delta: " + this.delta);
            System.out.println("    maxPosition: " + this.maxPosition);
        }
        if (DEBUGALL) {
            System.out.println("----end updateSizes----");
        }
    }

    private boolean sizeChanged() {
        if (this.oldComponentInnards == null || this.componentInnards == null) {
            return true;
        }
        this.oldComponentInnards.setRect(this.componentInnards);
        this.componentInnards = SwingUtilities.calculateInnerArea(this.progressBar, this.componentInnards);
        return !this.oldComponentInnards.equals(this.componentInnards);
    }

    protected void setAnimationIndex(int n2) {
        if (DEBUGALL) {
            System.out.println("----begin setAnimationIndex----");
            System.out.println("    argument = " + n2);
        }
        if (this.animationIndex != n2) {
            if (DEBUGALL) {
                System.out.println("    Changing animation index from " + this.animationIndex + " to " + n2);
            }
            if (this.sizeChanged()) {
                if (DEBUGALL) {
                    System.out.println("    size changed; resetting maxPosition, delta");
                }
                this.animationIndex = n2;
                this.maxPosition = 0;
                this.delta = 0.0;
                this.progressBar.repaint();
                return;
            }
            this.nextPaintRect = this.getBox(this.nextPaintRect);
            if (DEBUGALL) {
                System.out.println("    previous paint rect =  " + this.nextPaintRect);
                System.out.println("    before setting, boxRect =  " + this.boxRect);
            }
            this.animationIndex = n2;
            if (this.nextPaintRect != null) {
                this.boxRect = this.getBox(this.boxRect);
                if (this.boxRect != null) {
                    this.nextPaintRect.add(this.boxRect);
                }
            }
            if (DEBUGALL) {
                System.out.println("    after setting, boxRect =  " + this.boxRect);
                System.out.println("    after setting, nextPaintRect =  " + this.nextPaintRect);
            }
        } else {
            if (DEBUGALL) {
                System.out.println("    No change in value");
                System.out.println("----end setAnimationIndex----");
            }
            return;
        }
        if (this.nextPaintRect != null) {
            this.progressBar.repaint(this.nextPaintRect);
        } else {
            this.progressBar.repaint();
            if (DEBUGALL) {
                System.out.println("    repaint without args");
            }
        }
        if (DEBUGALL) {
            System.out.println("----end setAnimationIndex----");
        }
    }

    private void setCachedPercent(int n2) {
        this.cachedPercent = n2;
    }

    protected void setCellLength(int n2) {
        this.cellLength = n2;
    }

    protected void setCellSpacing(int n2) {
        this.cellSpacing = n2;
    }

    private int getBoxLength(int n2, int n3) {
        return (int)Math.round((double)n2 / 6.0);
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    protected int getAmountFull(Insets insets, int n2, int n3) {
        int n4 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n4 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n2 * this.progressBar.getPercentComplete()) : (int)Math.round((double)n3 * this.progressBar.getPercentComplete());
        }
        return n4;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    private void fetchStyle(JProgressBar jProgressBar) {
        SynthContext synthContext = this.getContext(jProgressBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.cellLength = UIManager.getInt("ProgressBar.cellLength");
            this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
            this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
            this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
        }
        synthContext.dispose();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int n2;
                String string = this.progressBar.getString();
                int n3 = fontMetrics.stringWidth(string);
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                if ((n2 = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n2;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int n4;
                String string = this.progressBar.getString();
                int n5 = fontMetrics.getHeight() + fontMetrics.getDescent();
                if (n5 > dimension.width) {
                    dimension.width = n5;
                }
                if ((n4 = fontMetrics.stringWidth(string)) > dimension.height) {
                    dimension.height = n4;
                }
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        Rectangle rectangle = new Rectangle();
        if (!jProgressBar.isIndeterminate()) {
            Insets insets = jProgressBar.getInsets();
            double d2 = jProgressBar.getPercentComplete();
            if (d2 != 0.0) {
                if (jProgressBar.getOrientation() == 0) {
                    rectangle.x = insets.left;
                    rectangle.y = insets.top;
                    rectangle.width = (int)(d2 * (double)(jProgressBar.getWidth() - (insets.left + 1 + insets.right + 1)));
                    rectangle.height = jProgressBar.getHeight() - (insets.top + 1 + insets.bottom + 1);
                    if (!SynthLookAndFeel.isLeftToRight(jProgressBar)) {
                        rectangle.x = jProgressBar.getWidth() - insets.left - insets.right - rectangle.width;
                    }
                } else {
                    rectangle.x = insets.left;
                    rectangle.width = jProgressBar.getWidth() - (insets.left + 1 + insets.right + 1);
                    rectangle.height = (int)(d2 * (double)(jProgressBar.getHeight() - (insets.top + 1 + insets.bottom + 1)));
                    rectangle.y = jProgressBar.getHeight() - insets.top - insets.bottom - rectangle.height;
                }
            }
        } else {
            rectangle = this.getBox(this.boxRect);
        }
        SynthLookAndFeel.paintForeground(synthContext, graphics, rectangle);
        if (jProgressBar.isStringPainted() && !this.isIndeterminate) {
            this.paintText(synthContext, graphics, jProgressBar.getString());
        }
    }

    public Rectangle getBox(Rectangle rectangle) {
        int n2 = this.getAnimationIndex();
        int n3 = this.numFrames / 2;
        if (DEBUGALL) {
            System.out.println("----begin getBox----");
            System.out.println("    getBox argument: " + rectangle);
            System.out.println("    currentFrame = " + n2);
            System.out.println("    middleFrame = " + n3);
        }
        if (this.sizeChanged() || this.delta == 0.0 || (double)this.maxPosition == 0.0) {
            this.updateSizes();
        }
        if ((rectangle = this.getGenericBox(rectangle)) == null) {
            if (DEBUGALL) {
                System.out.println("    Exiting because r is null");
            }
            return null;
        }
        if (n3 <= 0) {
            if (DEBUGALL) {
                System.out.println("    Exiting because middleFrame <= 0.");
            }
            return null;
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.x = n2 < n3 ? this.componentInnards.x + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        } else {
            rectangle.y = n2 < n3 ? this.componentInnards.y + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        }
        if (DEBUGALL) {
            System.out.println("    getBox return value: " + rectangle);
            System.out.println("----end getBox----");
        }
        return rectangle;
    }

    private Rectangle getGenericBox(Rectangle rectangle) {
        if (DEBUGALL) {
            System.out.println("----begin getGenericBox----");
            System.out.println("    argument: " + rectangle);
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.width = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            if (rectangle.width < 0) {
                rectangle = null;
            } else {
                rectangle.height = this.componentInnards.height;
                rectangle.height -= 2;
                rectangle.width -= 2;
                rectangle.y = this.componentInnards.y;
            }
        } else {
            rectangle.height = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            if (rectangle.height < 0) {
                rectangle = null;
            } else {
                rectangle.width = this.componentInnards.width;
                rectangle.height -= 2;
                rectangle.width -= 2;
                rectangle.x = this.componentInnards.x;
            }
        }
        if (DEBUGALL) {
            System.out.println("    getGenericBox returns: " + rectangle);
            System.out.println("----end getGenericBox----");
        }
        return rectangle;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthProgressBarUI();
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, String string) {
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (this.progressBar.isStringPainted()) {
            String string2 = this.progressBar.getString();
            Rectangle rectangle = this.progressBar.getBounds();
            int n2 = fontMetrics.stringWidth(string2);
            Rectangle rectangle2 = new Rectangle(rectangle.width / 2 - n2 / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2, 0, 0);
            if (rectangle2.y < 0) {
                return;
            }
            SynthStyle synthStyle = synthContext.getStyle();
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle.getFont(synthContext));
            synthStyle.getSynthGraphics(synthContext).paintText(synthContext, graphics, string, rectangle2.x, rectangle2.y, -1);
        }
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY = 5;

        private void stop() {
            this.timer.stop();
        }

        private void start(int n2) {
            this.previousDelay = n2;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(n2, this);
            } else {
                this.timer.setDelay(n2);
            }
            if (ADJUSTTIMER) {
                this.timer.setRepeats(false);
                this.timer.setCoalesce(false);
            }
            this.timer.start();
        }

        private Animator() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ADJUSTTIMER) {
                long l2 = System.currentTimeMillis();
                if (this.lastCall > 0L) {
                    int n2 = (int)(this.previousDelay - l2 + this.lastCall + (long)SynthProgressBarUI.this.getRepaintInterval());
                    if (n2 < this.MINIMUM_DELAY) {
                        n2 = this.MINIMUM_DELAY;
                    }
                    this.timer.setInitialDelay(n2);
                    this.previousDelay = n2;
                    if (DEBUGTIMER) {
                        System.out.println("---------------------");
                        System.out.println("actual delay = " + (l2 - this.lastCall));
                        System.out.println("next delay = " + n2);
                    }
                }
                this.timer.start();
                this.lastCall = l2;
            }
            SynthProgressBarUI.this.incrementAnimationIndex();
        }
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            BoundedRangeModel boundedRangeModel = SynthProgressBarUI.this.progressBar.getModel();
            int n3 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n4 = n3 > 0 ? (int)(100L * (long)boundedRangeModel.getValue() / (long)n3) : 0;
            if (n4 != (n2 = SynthProgressBarUI.this.getCachedPercent())) {
                SynthProgressBarUI.this.setCachedPercent(n4);
                SynthProgressBarUI.this.progressBar.repaint();
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthProgressBarUI.this.fetchStyle((JProgressBar)propertyChangeEvent.getSource());
            }
            if ("indeterminate".equals(string)) {
                SynthProgressBarUI.this.isIndeterminate = SynthProgressBarUI.this.progressBar.isIndeterminate();
                if (SynthProgressBarUI.this.isIndeterminate) {
                    SynthProgressBarUI.this.initIndeterminateValues();
                    SynthProgressBarUI.this.startAnimationTimer();
                } else {
                    SynthProgressBarUI.this.stopAnimationTimer();
                    SynthProgressBarUI.this.cleanUpIndeterminateValues();
                }
                SynthProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

