/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.util.Hashtable;

public class PropertyEditorManager {
    private static String[] searchPath = new String[]{"sun.beans.editors"};
    private static Hashtable registry;

    private static synchronized void initialize() {
        if (registry != null) {
            return;
        }
        registry = new Hashtable();
        PropertyEditorManager.load(Byte.TYPE, "ByteEditor");
        PropertyEditorManager.load(Short.TYPE, "ShortEditor");
        PropertyEditorManager.load(Integer.TYPE, "IntEditor");
        PropertyEditorManager.load(Long.TYPE, "LongEditor");
        PropertyEditorManager.load(Boolean.TYPE, "BoolEditor");
        PropertyEditorManager.load(Float.TYPE, "FloatEditor");
        PropertyEditorManager.load(Double.TYPE, "DoubleEditor");
    }

    public static synchronized String[] getEditorSearchPath() {
        String[] stringArray = new String[searchPath.length];
        for (int i2 = 0; i2 < searchPath.length; ++i2) {
            stringArray[i2] = searchPath[i2];
        }
        return stringArray;
    }

    public static synchronized void setEditorSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        searchPath = stringArray;
    }

    public static synchronized PropertyEditor findEditor(Class clazz) {
        PropertyEditorManager.initialize();
        Class clazz2 = (Class)registry.get(clazz);
        if (clazz2 != null) {
            try {
                Object object = clazz2.newInstance();
                return (PropertyEditor)object;
            }
            catch (Exception exception) {
                System.err.println("Couldn't instantiate type editor \"" + clazz2.getName() + "\" : " + exception);
            }
        }
        String string = clazz.getName() + "Editor";
        try {
            return (PropertyEditor)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            string = clazz.getName();
            while (string.indexOf(46) > 0) {
                string = string.substring(string.indexOf(46) + 1);
            }
            for (int i2 = 0; i2 < searchPath.length; ++i2) {
                String string2 = searchPath[i2] + "." + string + "Editor";
                try {
                    return (PropertyEditor)Introspector.instantiate(clazz, string2);
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            return null;
        }
    }

    public static void registerEditor(Class clazz, Class clazz2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        PropertyEditorManager.initialize();
        if (clazz2 == null) {
            registry.remove(clazz);
        } else {
            registry.put(clazz, clazz2);
        }
    }

    private static synchronized void load(Class clazz, String string) {
        String string2 = string;
        for (int i2 = 0; i2 < searchPath.length; ++i2) {
            try {
                string2 = searchPath[i2] + "." + string;
                Class clazz2 = Class.forName(string2);
                registry.put(clazz, clazz2);
                return;
            }
            catch (Exception exception) {
                continue;
            }
        }
        System.err.println("load of " + string2 + " failed");
    }
}

