/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public synchronized void write(int n2) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n2;
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 >= this.buf.length) {
            this.flushBuffer();
            this.out.write(byArray, n2, n3);
            return;
        }
        if (n3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count += n3;
    }

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public BufferedOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n2];
    }
}

