/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRS;
import java.nio.LongBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferS
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public long address() {
        return this.address;
    }

    public long get() {
        return Bits.swap(unsafe.getLong(this.ix(this.nextGetIndex())));
    }

    static {
        $assertionsDisabled = !DirectLongBufferS.class.desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public long get(int n2) {
        return Bits.swap(unsafe.getLong(this.ix(this.checkIndex(n2))));
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 3);
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 3);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public LongBuffer duplicate() {
        return new DirectLongBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 3;
        return new DirectLongBufferS(this, -1, 0, n4, n4, n5);
    }

    public LongBuffer put(int n2, long l2) {
        unsafe.putLong(this.ix(this.checkIndex(n2)), Bits.swap(l2));
        return this;
    }

    public LongBuffer put(long l2) {
        unsafe.putLong(this.ix(this.nextPutIndex()), Bits.swap(l2));
        return this;
    }

    public LongBuffer get(long[] lArray, int n2, int n3) {
        if (n3 << 3 > 6) {
            int n4;
            DirectLongBufferS.checkBounds(n2, n3, lArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(n5), lArray, n2 << 3, n3 << 3);
            } else {
                Bits.copyToByteArray(this.ix(n5), lArray, n2 << 3, n3 << 3);
            }
            this.position(n5 + n3);
        } else {
            super.get(lArray, n2, n3);
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n2, int n3) {
        if (n3 << 3 > 6) {
            int n4;
            DirectLongBufferS.checkBounds(n2, n3, lArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(lArray, n2 << 3, this.ix(n5), n3 << 3);
            } else {
                Bits.copyFromByteArray(lArray, n2 << 3, this.ix(n5), n3 << 3);
            }
            this.position(n5 + n3);
        } else {
            super.put(lArray, n2, n3);
        }
        return this;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferS(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.viewedBuffer = directBuffer;
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferS) {
            int n2;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferS directLongBufferS = (DirectLongBufferS)longBuffer;
            int n3 = directLongBufferS.position();
            int n4 = directLongBufferS.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directLongBufferS.ix(n3), this.ix(n6), n5 << 3);
            directLongBufferS.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!longBuffer.isDirect()) {
            int n9 = longBuffer.position();
            int n10 = longBuffer.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(longBuffer.hb, longBuffer.offset + n9, n11);
            longBuffer.position(n9 + n11);
        } else {
            super.put(longBuffer);
        }
        return this;
    }
}

