/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapDoubleBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class DoubleBuffer
extends Buffer
implements Comparable {
    final double[] hb;
    final int offset;
    boolean isReadOnly;

    public abstract double get();

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + (int)this.get(i2);
        }
        return n2;
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final double[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public abstract double get(int var1);

    DoubleBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    DoubleBuffer(int n2, int n3, int n4, int n5, double[] dArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = dArray;
        this.offset = n6;
    }

    public int compareTo(Object object) {
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), doubleBuffer.remaining());
        int n3 = this.position();
        int n4 = doubleBuffer.position();
        while (n3 < n2) {
            double d2;
            double d3 = this.get(n3);
            if (d3 != (d2 = doubleBuffer.get(n4)) && (d3 == d3 || d2 == d2)) {
                if (d3 < d2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - doubleBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        if (this.remaining() != doubleBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = doubleBuffer.limit() - 1;
        while (n3 >= n2) {
            double d2;
            double d3 = this.get(n3);
            if (d3 != (d2 = doubleBuffer.get(n4)) && (d3 == d3 || d2 == d2)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteOrder order();

    public abstract DoubleBuffer asReadOnlyBuffer();

    public abstract DoubleBuffer compact();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer put(double var1);

    public static DoubleBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapDoubleBuffer(n2, n2);
    }

    public abstract DoubleBuffer put(int var1, double var2);

    public DoubleBuffer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public final DoubleBuffer put(double[] dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    public static DoubleBuffer wrap(double[] dArray) {
        return DoubleBuffer.wrap(dArray, 0, dArray.length);
    }

    public DoubleBuffer get(double[] dArray, int n2, int n3) {
        DoubleBuffer.checkBounds(n2, n3, dArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            dArray[i2] = this.get();
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n2, int n3) {
        DoubleBuffer.checkBounds(n2, n3, dArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.put(dArray[i2]);
        }
        return this;
    }

    public static DoubleBuffer wrap(double[] dArray, int n2, int n3) {
        try {
            return new HeapDoubleBuffer(dArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = doubleBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(doubleBuffer.get());
        }
        return this;
    }
}

