/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import javax.swing.DebugGraphicsFilter;
import javax.swing.DebugGraphicsInfo;
import javax.swing.DebugGraphicsObserver;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DebugGraphics
extends Graphics {
    Graphics graphics;
    Image buffer = null;
    int debugOptions;
    int graphicsID = graphicsCount++;
    int xOffset = 0;
    int yOffset = 0;
    private static int graphicsCount = 0;
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;
    private static final Class debugGraphicsInfoKey = DebugGraphicsInfo.class;

    static int debugComponentCount() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo != null && debugGraphicsInfo.componentToDebug != null) {
            return debugGraphicsInfo.componentToDebug.size();
        }
        return 0;
    }

    public static int flashCount() {
        return DebugGraphics.info().flashCount;
    }

    public static int flashTime() {
        return DebugGraphics.info().flashTime;
    }

    public int getDebugOptions() {
        return this.debugOptions;
    }

    public DebugGraphics() {
    }

    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public void setPaintMode() {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting paint mode");
        }
        this.graphics.setPaintMode();
    }

    boolean debugBuffered() {
        return (this.debugOptions & 4) == 4;
    }

    boolean debugFlash() {
        return (this.debugOptions & 2) == 2;
    }

    boolean debugLog() {
        return (this.debugOptions & 1) == 1;
    }

    public boolean isDrawingBuffer() {
        return this.buffer != null;
    }

    public void setDebugOptions(int n2) {
        if (n2 != 0) {
            if (n2 == -1) {
                if (this.debugOptions != 0) {
                    System.err.println(this.toShortString() + " Disabling debug");
                    this.debugOptions = 0;
                }
            } else if (this.debugOptions != n2) {
                this.debugOptions |= n2;
                if (this.debugLog()) {
                    System.err.println(this.toShortString() + " Enabling debug");
                }
            }
        }
    }

    public static void setFlashCount(int n2) {
        DebugGraphics.info().flashCount = n2;
    }

    public static void setFlashTime(int n2) {
        DebugGraphics.info().flashTime = n2;
    }

    final void sleep(int n2) {
        try {
            Thread.sleep(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void translate(int n2, int n3) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Translating by: " + new Point(n2, n3));
        }
        this.xOffset += n2;
        this.yOffset += n3;
        this.graphics.translate(n2, n3);
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Clearing rect: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.clearRect(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.clearRect(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.clearRect(n2, n3, n4, n5);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.graphics.clipRect(n2, n3, n4, n5);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting clipRect: " + new Rectangle(n2, n3, n4, n5) + " New clipRect: " + this.graphics.getClip());
        }
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing line: from " + this.pointToString(n2, n3) + " to " + this.pointToString(n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawLine(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawLine(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawLine(n2, n3, n4, n5);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing oval: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawOval(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawOval(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawOval(n2, n3, n4, n5);
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing rect: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRect(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawRect(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRect(n2, n3, n4, n5);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling oval: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillOval(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillOval(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillOval(n2, n3, n4, n5);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling rect: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRect(n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillRect(n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRect(n2, n3, n4, n5);
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.graphics.setClip(n2, n3, n4, n5);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Copying area from: " + new Rectangle(n2, n3, n4, n5) + " to: " + new Point(n6, n7));
        }
        this.graphics.copyArea(n2, n3, n4, n5, n6, n7);
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing arc: " + new Rectangle(n2, n3, n4, n5) + " startAngle: " + n6 + " arcAngle: " + n7);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawArc(n2, n3, n4, n5, n6, n7);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n8 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawArc(n2, n3, n4, n5, n6, n7);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawArc(n2, n3, n4, n5, n6, n7);
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing round rect: " + new Rectangle(n2, n3, n4, n5) + " arcWidth: " + n6 + " archHeight: " + n7);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRoundRect(n2, n3, n4, n5, n6, n7);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n8 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawRoundRect(n2, n3, n4, n5, n6, n7);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling arc: " + new Rectangle(n2, n3, n4, n5) + " startAngle: " + n6 + " arcAngle: " + n7);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillArc(n2, n3, n4, n5, n6, n7);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n8 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillArc(n2, n3, n4, n5, n6, n7);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillArc(n2, n3, n4, n5, n6, n7);
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling round rect: " + new Rectangle(n2, n3, n4, n5) + " arcWidth: " + n6 + " archHeight: " + n7);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRoundRect(n2, n3, n4, n5, n6, n7);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n8 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillRoundRect(n2, n3, n4, n5, n6, n7);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void draw3DRect(int n2, int n3, int n4, int n5, boolean bl2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing 3D rect: " + new Rectangle(n2, n3, n4, n5) + " Raised bezel: " + bl2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.draw3DRect(n2, n3, n4, n5, bl2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.draw3DRect(n2, n3, n4, n5, bl2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.draw3DRect(n2, n3, n4, n5, bl2);
    }

    public void fill3DRect(int n2, int n3, int n4, int n5, boolean bl2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling 3D rect: " + new Rectangle(n2, n3, n4, n5) + " Raised bezel: " + bl2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fill3DRect(n2, n3, n4, n5, bl2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fill3DRect(n2, n3, n4, n5, bl2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fill3DRect(n2, n3, n4, n5, bl2);
    }

    public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing bytes at: " + new Point(n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawBytes(byArray, n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawBytes(byArray, n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawBytes(byArray, n2, n3, n4, n5);
    }

    public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing chars at " + new Point(n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawChars(cArray, n2, n3, n4, n5);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawChars(cArray, n2, n3, n4, n5);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawChars(cArray, n2, n3, n4, n5);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing polygon: " + " nPoints: " + n2 + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawPolygon(nArray, nArray2, n2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawPolygon(nArray, nArray2, n2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawPolygon(nArray, nArray2, n2);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing polyline: " + " nPoints: " + n2 + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawPolyline(nArray, nArray2, n2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawPolyline(nArray, nArray2, n2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawPolyline(nArray, nArray2, n2);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling polygon: " + " nPoints: " + n2 + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillPolygon(nArray, nArray2, n2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillPolygon(nArray, nArray2, n2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillPolygon(nArray, nArray2, n2);
    }

    public static Color flashColor() {
        return DebugGraphics.info().flashColor;
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public void setColor(Color color) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting color: " + color);
        }
        this.graphics.setColor(color);
    }

    public static void setFlashColor(Color color) {
        DebugGraphics.info().flashColor = color;
    }

    public void setXORMode(Color color) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting XOR mode: " + color);
        }
        this.graphics.setXORMode(color);
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public void setFont(Font font) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting font: " + font);
        }
        this.graphics.setFont(font);
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public Graphics create() {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create();
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        return debugGraphics;
    }

    private Graphics debugGraphics() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo.debugFrame == null) {
            debugGraphicsInfo.debugFrame = new JFrame();
            debugGraphicsInfo.debugFrame.setSize(500, 500);
        }
        JFrame jFrame = debugGraphicsInfo.debugFrame;
        jFrame.show();
        DebugGraphics debugGraphics = new DebugGraphics(jFrame.getGraphics());
        debugGraphics.setFont(this.getFont());
        debugGraphics.setColor(this.getColor());
        debugGraphics.translate(this.xOffset, this.yOffset);
        debugGraphics.setClip(this.getClipBounds());
        if (this.debugFlash()) {
            debugGraphics.setDebugOptions(2);
        }
        return debugGraphics;
    }

    public Graphics create(int n2, int n3, int n4, int n5) {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create(n2, n3, n4, n5);
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        debugGraphics.xOffset = this.xOffset + n2;
        debugGraphics.yOffset = this.yOffset + n3;
        return debugGraphics;
    }

    public DebugGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public void setClip(Shape shape) {
        this.graphics.setClip(shape);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    public static PrintStream logStream() {
        return DebugGraphics.info().stream;
    }

    public static void setLogStream(PrintStream printStream) {
        DebugGraphics.info().stream = printStream;
    }

    String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("Graphics" + (this.isDrawingBuffer() ? "<B>" : "") + "(" + this.graphicsID + "-" + this.debugOptions + ")");
        return stringBuffer.toString();
    }

    String pointToString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer("(" + n2 + ", " + n3 + ")");
        return stringBuffer.toString();
    }

    public void drawString(String string, int n2, int n3) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing string: \"" + string + "\" at: " + new Point(n2, n3));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawString(string, n2, n3);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n4 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawString(string, n2, n3);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawString(string, n2, n3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing text: \"" + attributedCharacterIterator + "\" at: " + new Point(n2, n3));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawString(attributedCharacterIterator, n2, n3);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n4 = debugGraphicsInfo.flashCount * 2 - 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                this.graphics.setColor(i2 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawString(attributedCharacterIterator, n2, n3);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawString(attributedCharacterIterator, n2, n3);
    }

    static DebugGraphicsInfo info() {
        DebugGraphicsInfo debugGraphicsInfo = (DebugGraphicsInfo)SwingUtilities.appContextGet(debugGraphicsInfoKey);
        if (debugGraphicsInfo == null) {
            debugGraphicsInfo = new DebugGraphicsInfo();
            SwingUtilities.appContextPut(debugGraphicsInfoKey, debugGraphicsInfo);
        }
        return debugGraphicsInfo;
    }

    static int getDebugOptions(JComponent jComponent) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo == null) {
            return 0;
        }
        return debugGraphicsInfo.getDebugOptions(jComponent);
    }

    static int shouldComponentDebug(JComponent jComponent) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo == null) {
            return 0;
        }
        int n2 = 0;
        for (Container container = jComponent; container != null && container instanceof JComponent; container = container.getParent()) {
            n2 |= debugGraphicsInfo.getDebugOptions((JComponent)container);
        }
        return n2;
    }

    static void setDebugOptions(JComponent jComponent, int n2) {
        DebugGraphics.info().setDebugOptions(jComponent, n2);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " destination: " + new Rectangle(n2, n3, n4, n5) + " source: " + new Rectangle(n6, n7, n8, n9));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n10 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n10; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, n4, n5, n6, n7, n8, n9, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " at: " + new Rectangle(n2, n3, n4, n5));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, n4, n5, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, n4, n5, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " at: " + new Point(n2, n3));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n4 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n4; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, imageObserver);
    }

    public DebugGraphics(Graphics graphics, JComponent jComponent) {
        this(graphics);
        this.setDebugOptions(jComponent.shouldDebugGraphics());
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " destination: " + new Rectangle(n2, n3, n4, n5) + " source: " + new Rectangle(n6, n7, n8, n9) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n10 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n10; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, n4, n5, n6, n7, n8, n9, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " at: " + new Rectangle(n2, n3, n4, n5) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, n4, n5, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n6 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n6; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, n4, n5, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, n4, n5, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(this.toShortString() + " Drawing image: " + image + " at: " + new Point(n2, n3) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n2, n3, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n4 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            for (int i2 = 0; i2 < n4; ++i2) {
                this.graphics.drawImage(i2 % 2 == 0 ? image2 : image, n2, n3, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
            }
        }
        return this.graphics.drawImage(image, n2, n3, color, imageObserver);
    }
}

