/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy = 20;
    protected int hsbPolicy = 30;

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n2) {
        switch (n2) {
            case 30: 
            case 31: 
            case 32: {
                this.hsbPolicy = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
            }
        }
    }

    public void setVerticalScrollBarPolicy(int n2) {
        switch (n2) {
            case 20: 
            case 21: 
            case 22: {
                this.vsbPolicy = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        }
    }

    public void layoutContainer(Container container) {
        boolean bl2;
        boolean bl3;
        Scrollable scrollable;
        boolean bl4;
        Insets insets;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Rectangle rectangle = jScrollPane.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        boolean bl5 = SwingUtilities.isLeftToRight(jScrollPane);
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int n2;
            rectangle2.height = n2 = Math.min(rectangle.height, this.colHead.getPreferredSize().height);
            rectangle.y += n2;
            rectangle.height -= n2;
        }
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n3;
            rectangle3.width = n3 = Math.min(rectangle.width, this.rowHead.getPreferredSize().width);
            rectangle.width -= n3;
            if (bl5) {
                rectangle3.x = rectangle.x;
                rectangle.x += n3;
            } else {
                rectangle3.x = rectangle.x + rectangle.width;
            }
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = bl4 = rectangle.width < 0 || rectangle.height < 0;
        if (!bl4 && component instanceof Scrollable) {
            scrollable = (Scrollable)((Object)component);
            bl6 = scrollable.getScrollableTracksViewportWidth();
            bl7 = scrollable.getScrollableTracksViewportHeight();
        } else {
            scrollable = null;
        }
        Rectangle rectangle4 = new Rectangle(0, rectangle.y - insets.top, 0, 0);
        if (bl4) {
            bl3 = false;
        } else if (this.vsbPolicy == 22) {
            bl3 = true;
        } else if (this.vsbPolicy == 21) {
            bl3 = false;
        } else {
            boolean bl9 = bl3 = !bl7 && dimension.height > dimension2.height;
        }
        if (this.vsb != null && bl3) {
            this.adjustForVSB(true, rectangle, rectangle4, insets, bl5);
            dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
        }
        Rectangle rectangle5 = new Rectangle(rectangle.x - insets.left, 0, 0, 0);
        if (bl4) {
            bl2 = false;
        } else if (this.hsbPolicy == 32) {
            bl2 = true;
        } else if (this.hsbPolicy == 31) {
            bl2 = false;
        } else {
            boolean bl10 = bl2 = !bl6 && dimension.width > dimension2.width;
        }
        if (this.hsb != null && bl2) {
            this.adjustForHSB(true, rectangle, rectangle5, insets);
            if (this.vsb != null && !bl3 && this.vsbPolicy != 21) {
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl11 = bl3 = dimension.height > dimension2.height;
                if (bl3) {
                    this.adjustForVSB(true, rectangle, rectangle4, insets, bl5);
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(rectangle);
            if (scrollable != null) {
                boolean bl12;
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl13 = bl2;
                boolean bl14 = bl3;
                bl6 = scrollable.getScrollableTracksViewportWidth();
                bl7 = scrollable.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20) {
                    boolean bl15 = bl12 = !bl7 && dimension.height > dimension2.height;
                    if (bl12 != bl3) {
                        bl3 = bl12;
                        this.adjustForVSB(bl3, rectangle, rectangle4, insets, bl5);
                        dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30) {
                    boolean bl16 = bl12 = !bl6 && dimension.width > dimension2.width;
                    if (bl12 != bl2) {
                        bl2 = bl12;
                        this.adjustForHSB(bl2, rectangle, rectangle5, insets);
                        if (this.vsb != null && !bl3 && this.vsbPolicy != 21) {
                            dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                            boolean bl17 = bl3 = dimension.height > dimension2.height;
                            if (bl3) {
                                this.adjustForVSB(true, rectangle, rectangle4, insets, bl5);
                            }
                        }
                    }
                }
                if (bl13 != bl2 || bl14 != bl3) {
                    this.viewport.setBounds(rectangle);
                }
            }
        }
        rectangle4.height = rectangle.height + insets.top + insets.bottom;
        rectangle5.width = rectangle.width + insets.left + insets.right;
        rectangle3.height = rectangle.height + insets.top + insets.bottom;
        rectangle3.y = rectangle.y - insets.top;
        rectangle2.width = rectangle.width + insets.left + insets.right;
        rectangle2.x = rectangle.x - insets.left;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rectangle3);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(rectangle2);
        }
        if (this.vsb != null) {
            if (bl3) {
                this.vsb.setVisible(true);
                this.vsb.setBounds(rectangle4);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (bl2) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(rectangle5);
            } else {
                this.hsb.setVisible(false);
            }
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(bl5 ? rectangle3.x : rectangle4.x, rectangle5.y, bl5 ? rectangle3.width : rectangle4.width, rectangle5.height);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(bl5 ? rectangle4.x : rectangle3.x, rectangle5.y, bl5 ? rectangle4.width : rectangle3.width, rectangle5.height);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(bl5 ? rectangle3.x : rectangle4.x, rectangle2.y, bl5 ? rectangle3.width : rectangle4.width, rectangle2.height);
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(bl5 ? rectangle4.x : rectangle3.x, rectangle2.y, bl5 ? rectangle4.width : rectangle3.width, rectangle2.height);
        }
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        this.viewport = jScrollPane.getViewport();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.rowHead = jScrollPane.getRowHeader();
        this.colHead = jScrollPane.getColumnHeader();
        this.lowerLeft = jScrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = jScrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = jScrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = jScrollPane.getCorner("UPPER_RIGHT_CORNER");
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Component getCorner(String string) {
        if (string.equals("LOWER_LEFT_CORNER")) {
            return this.lowerLeft;
        }
        if (string.equals("LOWER_RIGHT_CORNER")) {
            return this.lowerRight;
        }
        if (string.equals("UPPER_LEFT_CORNER")) {
            return this.upperLeft;
        }
        if (string.equals("UPPER_RIGHT_CORNER")) {
            return this.upperRight;
        }
        return null;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("VIEWPORT")) {
            this.viewport = (JViewport)this.addSingletonComponent(this.viewport, component);
        } else if (string.equals("VERTICAL_SCROLLBAR")) {
            this.vsb = (JScrollBar)this.addSingletonComponent(this.vsb, component);
        } else if (string.equals("HORIZONTAL_SCROLLBAR")) {
            this.hsb = (JScrollBar)this.addSingletonComponent(this.hsb, component);
        } else if (string.equals("ROW_HEADER")) {
            this.rowHead = (JViewport)this.addSingletonComponent(this.rowHead, component);
        } else if (string.equals("COLUMN_HEADER")) {
            this.colHead = (JViewport)this.addSingletonComponent(this.colHead, component);
        } else if (string.equals("LOWER_LEFT_CORNER")) {
            this.lowerLeft = this.addSingletonComponent(this.lowerLeft, component);
        } else if (string.equals("LOWER_RIGHT_CORNER")) {
            this.lowerRight = this.addSingletonComponent(this.lowerRight, component);
        } else if (string.equals("UPPER_LEFT_CORNER")) {
            this.upperLeft = this.addSingletonComponent(this.upperLeft, component);
        } else if (string.equals("UPPER_RIGHT_CORNER")) {
            this.upperRight = this.addSingletonComponent(this.upperRight, component);
        } else {
            throw new IllegalArgumentException("invalid layout key " + string);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n2 += ((Dimension)object).width;
            n3 += ((Dimension)object).height;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            cloneable = object.getBorderInsets(container);
            n2 += cloneable.left + cloneable.right;
            n3 += cloneable.top + cloneable.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            cloneable = this.rowHead.getMinimumSize();
            n2 += ((Dimension)cloneable).width;
            n3 = Math.max(n3, ((Dimension)cloneable).height);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            cloneable = this.colHead.getMinimumSize();
            n2 = Math.max(n2, ((Dimension)cloneable).width);
            n3 += ((Dimension)cloneable).height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            cloneable = this.vsb.getMinimumSize();
            n2 += ((Dimension)cloneable).width;
            n3 = Math.max(n3, ((Dimension)cloneable).height);
        }
        if (this.hsb != null && this.hsbPolicy != 21) {
            cloneable = this.hsb.getMinimumSize();
            n2 = Math.max(n2, ((Dimension)cloneable).width);
            n3 += ((Dimension)cloneable).height;
        }
        return new Dimension(n2, n3);
    }

    public Dimension preferredLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n2 += dimension.width;
            n3 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n2 += insets2.left + insets2.right;
            n3 += insets2.top + insets2.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n2 += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n3 += this.colHead.getPreferredSize().height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n2 += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                boolean bl2 = true;
                if (component instanceof Scrollable) {
                    boolean bl3 = bl2 = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight();
                }
                if (bl2 && dimension2.height > dimension.height) {
                    n2 += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n3 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                boolean bl4 = true;
                if (component instanceof Scrollable) {
                    boolean bl5 = bl4 = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                }
                if (bl4 && dimension2.width > dimension.width) {
                    n3 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n2, n3);
    }

    public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
        return jScrollPane.getViewportBorderBounds();
    }

    protected Component addSingletonComponent(Component component, Component component2) {
        if (component != null && component != component2) {
            component.getParent().remove(component);
        }
        return component2;
    }

    private void adjustForHSB(boolean bl2, Rectangle rectangle, Rectangle rectangle2, Insets insets) {
        int n2 = rectangle2.height;
        if (bl2) {
            int n3 = Math.max(0, Math.min(rectangle.height, this.hsb.getPreferredSize().height));
            rectangle.height -= n3;
            rectangle2.y = rectangle.y + rectangle.height + insets.bottom;
            rectangle2.height = n3;
        } else {
            rectangle.height += n2;
        }
    }

    private void adjustForVSB(boolean bl2, Rectangle rectangle, Rectangle rectangle2, Insets insets, boolean bl3) {
        int n2 = rectangle2.width;
        if (bl2) {
            int n3 = Math.max(0, Math.min(this.vsb.getPreferredSize().width, rectangle.width));
            rectangle.width -= n3;
            rectangle2.width = n3;
            if (bl3) {
                rectangle2.x = rectangle.x + rectangle.width + insets.right;
            } else {
                rectangle2.x = rectangle.x - insets.left;
                rectangle.x += n3;
            }
        } else {
            rectangle.width += n2;
        }
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

