/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Polygon;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;

class Map {
    private String name;
    private Vector areaAttributes;
    private Vector areas;

    public Map() {
    }

    protected static int[] extractCoords(Object object) {
        Object object2;
        if (object == null || !(object instanceof String)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", \t\n\r");
        Object object3 = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            int n3;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).endsWith("%")) {
                n3 = -1;
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            } else {
                n3 = 1;
            }
            try {
                int n4 = Integer.parseInt((String)object2);
                if (object3 == null) {
                    object3 = new int[4];
                } else if (n2 == ((Object)object3).length) {
                    int[] nArray = new int[((Object)object3).length * 2];
                    System.arraycopy(object3, 0, nArray, 0, ((Object)object3).length);
                    object3 = nArray;
                }
                object3[n2++] = n4 * n3;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (n2 > 0 && n2 != (object3).length) {
            object2 = new int[n2];
            System.arraycopy(object3, 0, object2, 0, n2);
            object3 = object2;
        }
        return object3;
    }

    public String getName() {
        return this.name;
    }

    public Map(String string) {
        this.name = string;
    }

    public AttributeSet[] getAreas() {
        int n2;
        int n3 = n2 = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (n2 != 0) {
            Object[] objectArray = new AttributeSet[n2];
            this.areaAttributes.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public AttributeSet getArea(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (n6 > 0) {
            int n8;
            int n9 = n8 = this.areas != null ? this.areas.size() : 0;
            if (this.areas == null) {
                this.areas = new Vector(n6);
            }
            for (int i2 = 0; i2 < n6; ++i2) {
                RegionContainment regionContainment;
                if (i2 >= n8) {
                    this.areas.addElement(this.createRegionContainment((AttributeSet)this.areaAttributes.elementAt(i2)));
                }
                if ((regionContainment = (RegionContainment)this.areas.elementAt(i2)) == null || !regionContainment.contains(n2, n3, n4, n5)) continue;
                return (AttributeSet)this.areaAttributes.elementAt(i2);
            }
        }
        return null;
    }

    public void addArea(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (this.areaAttributes == null) {
            this.areaAttributes = new Vector(2);
        }
        this.areaAttributes.addElement(attributeSet.copyAttributes());
    }

    public void removeArea(AttributeSet attributeSet) {
        if (attributeSet != null && this.areaAttributes != null) {
            int n2 = this.areas != null ? this.areas.size() : 0;
            for (int i2 = this.areaAttributes.size() - 1; i2 >= 0; --i2) {
                if (!((AttributeSet)this.areaAttributes.elementAt(i2)).isEqual(attributeSet)) continue;
                this.areaAttributes.removeElementAt(i2);
                if (i2 >= n2) continue;
                this.areas.removeElementAt(i2);
            }
        }
    }

    protected RegionContainment createRegionContainment(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(HTML.Attribute.SHAPE);
        if (object == null) {
            object = "rect";
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            RegionContainment regionContainment = null;
            try {
                if (string.equals("rect")) {
                    regionContainment = new RectangleRegionContainment(attributeSet);
                } else if (string.equals("circle")) {
                    regionContainment = new CircleRegionContainment(attributeSet);
                } else if (string.equals("poly")) {
                    regionContainment = new PolygonRegionContainment(attributeSet);
                } else if (string.equals("default")) {
                    regionContainment = DefaultRegionContainment.sharedInstance();
                }
            }
            catch (RuntimeException runtimeException) {
                regionContainment = null;
            }
            return regionContainment;
        }
        return null;
    }

    static class CircleRegionContainment
    implements RegionContainment {
        int x;
        int y;
        int radiusSquared;
        float[] percentValues;
        int lastWidth;
        int lastHeight;

        public boolean contains(int n2, int n3, int n4, int n5) {
            if (this.percentValues != null && (this.lastWidth != n4 || this.lastHeight != n5)) {
                int n6 = Math.min(n4, n5) / 2;
                this.lastWidth = n4;
                this.lastHeight = n5;
                if (this.percentValues[0] != -1.0f) {
                    this.x = (int)(this.percentValues[0] * (float)n4);
                }
                if (this.percentValues[1] != -1.0f) {
                    this.y = (int)(this.percentValues[1] * (float)n5);
                }
                if (this.percentValues[2] != -1.0f) {
                    this.radiusSquared = (int)(this.percentValues[2] * (float)Math.min(n4, n5));
                    this.radiusSquared *= this.radiusSquared;
                }
            }
            return (n2 - this.x) * (n2 - this.x) + (n3 - this.y) * (n3 - this.y) <= this.radiusSquared;
        }

        public CircleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length != 3) {
                throw new RuntimeException("Unable to parse circular area");
            }
            this.x = nArray[0];
            this.y = nArray[1];
            this.radiusSquared = nArray[2] * nArray[2];
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                this.lastHeight = -1;
                this.lastWidth = -1;
                this.percentValues = new float[3];
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.percentValues[i2] = nArray[i2] < 0 ? (float)nArray[i2] / -100.0f : -1.0f;
                }
            } else {
                this.percentValues = null;
            }
        }
    }

    static class DefaultRegionContainment
    implements RegionContainment {
        static DefaultRegionContainment si = null;

        DefaultRegionContainment() {
        }

        public boolean contains(int n2, int n3, int n4, int n5) {
            return n2 <= n4 && n2 >= 0 && n3 >= 0 && n3 <= n4;
        }

        public static DefaultRegionContainment sharedInstance() {
            if (si == null) {
                si = new DefaultRegionContainment();
            }
            return si;
        }
    }

    static class PolygonRegionContainment
    extends Polygon
    implements RegionContainment {
        float[] percentValues;
        int[] percentIndexs;
        int lastWidth;
        int lastHeight;

        public boolean contains(int n2, int n3, int n4, int n5) {
            if (this.percentValues == null || this.lastWidth == n4 && this.lastHeight == n5) {
                return this.contains(n2, n3);
            }
            this.bounds = null;
            this.lastWidth = n4;
            this.lastHeight = n5;
            float f2 = n4;
            float f3 = n5;
            for (int i2 = this.percentValues.length - 1; i2 >= 0; --i2) {
                if (this.percentIndexs[i2] % 2 == 0) {
                    this.xpoints[this.percentIndexs[i2] / 2] = (int)(this.percentValues[i2] * f2);
                    continue;
                }
                this.ypoints[this.percentIndexs[i2] / 2] = (int)(this.percentValues[i2] * f3);
            }
            return this.contains(n2, n3);
        }

        public PolygonRegionContainment(AttributeSet attributeSet) {
            int n2;
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length == 0 || nArray.length % 2 != 0) {
                throw new RuntimeException("Unable to parse polygon area");
            }
            int n3 = 0;
            this.lastHeight = -1;
            this.lastWidth = -1;
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                if (nArray[n2] >= 0) continue;
                ++n3;
            }
            if (n3 > 0) {
                this.percentIndexs = new int[n3];
                this.percentValues = new float[n3];
                int n4 = 0;
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    if (nArray[n2] >= 0) continue;
                    this.percentValues[n4] = (float)nArray[n2] / -100.0f;
                    this.percentIndexs[n4] = n2;
                    ++n4;
                }
            } else {
                this.percentIndexs = null;
                this.percentValues = null;
            }
            this.npoints = nArray.length / 2;
            this.xpoints = new int[this.npoints];
            this.ypoints = new int[this.npoints];
            for (n2 = 0; n2 < this.npoints; ++n2) {
                this.xpoints[n2] = nArray[n2 + n2];
                this.ypoints[n2] = nArray[n2 + n2 + 1];
            }
        }
    }

    static class RectangleRegionContainment
    implements RegionContainment {
        float[] percents;
        int lastWidth;
        int lastHeight;
        int x0;
        int y0;
        int x1;
        int y1;

        public boolean contains(int n2, int n3) {
            return n2 >= this.x0 && n2 <= this.x1 && n3 >= this.y0 && n3 <= this.y1;
        }

        public boolean contains(int n2, int n3, int n4, int n5) {
            if (this.percents == null) {
                return this.contains(n2, n3);
            }
            if (this.lastWidth != n4 || this.lastHeight != n5) {
                this.lastWidth = n4;
                this.lastHeight = n5;
                if (this.percents[0] != -1.0f) {
                    this.x0 = (int)(this.percents[0] * (float)n4);
                }
                if (this.percents[1] != -1.0f) {
                    this.y0 = (int)(this.percents[1] * (float)n5);
                }
                if (this.percents[2] != -1.0f) {
                    this.x1 = (int)(this.percents[2] * (float)n4);
                }
                if (this.percents[3] != -1.0f) {
                    this.y1 = (int)(this.percents[3] * (float)n5);
                }
            }
            return this.contains(n2, n3);
        }

        public RectangleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = Map.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            this.percents = null;
            if (nArray == null || nArray.length != 4) {
                throw new RuntimeException("Unable to parse rectangular area");
            }
            this.x0 = nArray[0];
            this.y0 = nArray[1];
            this.x1 = nArray[2];
            this.y1 = nArray[3];
            if (this.x0 < 0 || this.y0 < 0 || this.x1 < 0 || this.y1 < 0) {
                this.percents = new float[4];
                this.lastHeight = -1;
                this.lastWidth = -1;
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.percents[i2] = nArray[i2] < 0 ? (float)Math.abs(nArray[i2]) / 100.0f : -1.0f;
                }
            }
        }
    }

    static interface RegionContainment {
        public boolean contains(int var1, int var2, int var3, int var4);
    }
}

