/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMAxisTraverser getAxisTraverser(int n2) {
        DTMAxisTraverser dTMAxisTraverser;
        if (null == this.m_traversers) {
            this.m_traversers = new DTMAxisTraverser[Axis.names.length];
            dTMAxisTraverser = null;
        } else {
            dTMAxisTraverser = this.m_traversers[n2];
            if (dTMAxisTraverser != null) {
                return dTMAxisTraverser;
            }
        }
        switch (n2) {
            case 0: {
                dTMAxisTraverser = new AncestorTraverser();
                break;
            }
            case 1: {
                dTMAxisTraverser = new AncestorOrSelfTraverser();
                break;
            }
            case 2: {
                dTMAxisTraverser = new AttributeTraverser();
                break;
            }
            case 3: {
                dTMAxisTraverser = new ChildTraverser();
                break;
            }
            case 4: {
                dTMAxisTraverser = new DescendantTraverser();
                break;
            }
            case 5: {
                dTMAxisTraverser = new DescendantOrSelfTraverser();
                break;
            }
            case 6: {
                dTMAxisTraverser = new FollowingTraverser();
                break;
            }
            case 7: {
                dTMAxisTraverser = new FollowingSiblingTraverser();
                break;
            }
            case 9: {
                dTMAxisTraverser = new NamespaceTraverser();
                break;
            }
            case 8: {
                dTMAxisTraverser = new NamespaceDeclsTraverser();
                break;
            }
            case 10: {
                dTMAxisTraverser = new ParentTraverser();
                break;
            }
            case 11: {
                dTMAxisTraverser = new PrecedingTraverser();
                break;
            }
            case 12: {
                dTMAxisTraverser = new PrecedingSiblingTraverser();
                break;
            }
            case 13: {
                dTMAxisTraverser = new SelfTraverser();
                break;
            }
            case 16: {
                dTMAxisTraverser = new AllFromRootTraverser();
                break;
            }
            case 14: {
                dTMAxisTraverser = new AllFromNodeTraverser();
                break;
            }
            case 15: {
                dTMAxisTraverser = new PrecedingAndAncestorTraverser();
                break;
            }
            case 17: {
                dTMAxisTraverser = new DescendantFromRootTraverser();
                break;
            }
            case 18: {
                dTMAxisTraverser = new DescendantOrSelfFromRootTraverser();
                break;
            }
            case 19: {
                dTMAxisTraverser = new RootTraverser();
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage("ER_UNKNOWN_AXIS_TYPE", new Object[]{Integer.toString(n2)}));
            }
        }
        if (null == dTMAxisTraverser) {
            throw new DTMException(XSLMessages.createMessage("ER_AXIS_TRAVERSER_NOT_SUPPORTED", new Object[]{Axis.names[n2]}));
        }
        this.m_traversers[n2] = dTMAxisTraverser;
        return dTMAxisTraverser;
    }

    public DTMDefaultBaseTraversers(DTMManager dTMManager, Source source, int n2, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl2) {
        super(dTMManager, source, n2, dTMWSFilter, xMLStringFactory, bl2);
    }

    private class AllFromNodeTraverser
    extends DescendantOrSelfTraverser {
        public int next(int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) + 1;
            DTMDefaultBaseTraversers.this._exptype(n3);
            if (!this.isDescendant(n4, n3)) {
                return -1;
            }
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
        }

        private AllFromNodeTraverser() {
        }
    }

    private class AllFromRootTraverser
    extends AllFromNodeTraverser {
        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getDocumentRoot(n2);
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(DTMDefaultBaseTraversers.this.getDocumentRoot(n2)) == n3 ? n2 : this.next(n2, n2, n3);
        }

        public int next(int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            short s2 = DTMDefaultBaseTraversers.this._type(n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) + 1);
            if (s2 == -1) {
                return -1;
            }
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) + 1;
            int n6;
            while ((n6 = DTMDefaultBaseTraversers.this._exptype(n3)) != -1) {
                if (n6 == n4) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
                }
                ++n3;
            }
            return -1;
        }

        private AllFromRootTraverser() {
        }
    }

    private class AncestorOrSelfTraverser
    extends AncestorTraverser {
        public int first(int n2) {
            return n2;
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) == n3 ? n2 : this.next(n2, n2, n3);
        }

        private AncestorOrSelfTraverser() {
        }
    }

    private class AncestorTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getParent(n3);
        }

        public int next(int n2, int n3, int n4) {
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3);
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n3))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) != n4) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            return -1;
        }

        private AncestorTraverser() {
        }
    }

    private class AttributeTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n2) : DTMDefaultBaseTraversers.this.getNextAttribute(n3);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n2) : DTMDefaultBaseTraversers.this.getNextAttribute(n3);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextAttribute(n3)));
            return -1;
        }

        private AttributeTraverser() {
        }
    }

    private class ChildTraverser
    extends DTMAxisTraverser {
        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getFirstChild(n2);
        }

        public int first(int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            int n5 = this.getNextIndexed(n4, DTMDefaultBaseTraversers.this._firstch(n4), n3);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n5);
        }

        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n3);
        }

        protected int getNextIndexed(int n2, int n3, int n4) {
            int n5 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getNamespaceID(n4);
            int n6 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getLocalNameID(n4);
            while (true) {
                int n7;
                if (-2 != (n7 = DTMDefaultBaseTraversers.this.findElementFromIndex(n5, n6, n3))) {
                    int n8 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n7);
                    if (n8 == n2) {
                        return n7;
                    }
                    if (n8 < n2) {
                        return -1;
                    }
                    do {
                        if ((n8 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n8)) >= n2) continue;
                        return -1;
                    } while (n8 > n2);
                    n3 = n7 + 1;
                    continue;
                }
                DTMDefaultBaseTraversers.this.nextNode();
                if (DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n2) != -2) break;
            }
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            n3 = DTMDefaultBaseTraversers.this._nextsib(DTMDefaultBaseTraversers.this.makeNodeIdentity(n3));
            while (-1 != n3) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) == n4) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
                }
                n3 = DTMDefaultBaseTraversers.this._nextsib(n3);
            }
            return -1;
        }

        private ChildTraverser() {
        }
    }

    private class DescendantFromRootTraverser
    extends DescendantTraverser {
        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.makeNodeHandle(DTMDefaultBaseTraversers.this._firstch(0));
        }

        protected int getFirstPotential(int n2) {
            return DTMDefaultBaseTraversers.this._firstch(0);
        }

        protected int getSubtreeRoot(int n2) {
            return 0;
        }

        public int first(int n2, int n3) {
            if (this.isIndexed(n3)) {
                int n4 = 0;
                int n5 = this.getFirstPotential(n4);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n4, n5, n3));
            }
            int n6 = DTMDefaultBaseTraversers.this.getDocumentRoot(n2);
            return this.next(n6, n6, n3);
        }

        private DescendantFromRootTraverser() {
        }
    }

    private class DescendantOrSelfFromRootTraverser
    extends DescendantTraverser {
        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getDocumentRoot(n2);
        }

        protected int getFirstPotential(int n2) {
            return n2;
        }

        protected int getSubtreeRoot(int n2) {
            return DTMDefaultBaseTraversers.this.makeNodeIdentity(DTMDefaultBaseTraversers.this.getDocument());
        }

        public int first(int n2, int n3) {
            if (this.isIndexed(n3)) {
                int n4 = 0;
                int n5 = this.getFirstPotential(n4);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n4, n5, n3));
            }
            int n6 = this.first(n2);
            return this.next(n6, n6, n3);
        }

        private DescendantOrSelfFromRootTraverser() {
        }
    }

    private class DescendantOrSelfTraverser
    extends DescendantTraverser {
        public int first(int n2) {
            return n2;
        }

        protected int getFirstPotential(int n2) {
            return n2;
        }

        private DescendantOrSelfTraverser() {
        }
    }

    private class DescendantTraverser
    extends IndexedDTMAxisTraverser {
        protected int getFirstPotential(int n2) {
            return n2 + 1;
        }

        protected int getSubtreeRoot(int n2) {
            return DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
        }

        protected boolean axisHasBeenProcessed(int n2) {
            return DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n2) != -2;
        }

        public int first(int n2, int n3) {
            if (this.isIndexed(n3)) {
                int n4 = this.getSubtreeRoot(n2);
                int n5 = this.getFirstPotential(n4);
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n4, n5, n3));
            }
            return this.next(n2, n2, n3);
        }

        public int next(int n2, int n3) {
            int n4 = this.getSubtreeRoot(n2);
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) + 1;
            while (true) {
                short s2 = DTMDefaultBaseTraversers.this._type(n3);
                if (!this.isDescendant(n4, n3)) {
                    return -1;
                }
                if (2 != s2 && 13 != s2) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
                }
                ++n3;
            }
        }

        protected boolean isAfterAxis(int n2, int n3) {
            do {
                if (n3 != n2) continue;
                return false;
            } while ((n3 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n3)) >= n2);
            return true;
        }

        protected boolean isDescendant(int n2, int n3) {
            return DTMDefaultBaseTraversers.this._parent(n3) >= n2;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = this.getSubtreeRoot(n2);
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) + 1;
            if (this.isIndexed(n4)) {
                return DTMDefaultBaseTraversers.this.makeNodeHandle(this.getNextIndexed(n5, n3, n4));
            }
            while (true) {
                int n6 = DTMDefaultBaseTraversers.this._exptype(n3);
                if (!this.isDescendant(n5, n3)) {
                    return -1;
                }
                if (n6 == n4) {
                    return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
                }
                ++n3;
            }
        }

        private DescendantTraverser() {
        }
    }

    private class FollowingSiblingTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n3);
        }

        public int next(int n2, int n3, int n4) {
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextSibling(n3))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) != n4) continue;
                return n3;
            }
            return -1;
        }

        private FollowingSiblingTraverser() {
        }
    }

    private class FollowingTraverser
    extends DescendantTraverser {
        public int first(int n2) {
            int n3;
            short s2 = DTMDefaultBaseTraversers.this._type(n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2));
            if ((2 == s2 || 13 == s2) && -1 != (n3 = DTMDefaultBaseTraversers.this._firstch(n2 = DTMDefaultBaseTraversers.this._parent(n2)))) {
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            do {
                if (-1 != (n3 = DTMDefaultBaseTraversers.this._nextsib(n2))) continue;
                n2 = DTMDefaultBaseTraversers.this._parent(n2);
            } while (-1 == n3 && -1 != n2);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
        }

        public int first(int n2, int n3) {
            int n4;
            short s2 = DTMDefaultBaseTraversers.this.getNodeType(n2);
            if ((2 == s2 || 13 == s2) && -1 != (n4 = DTMDefaultBaseTraversers.this.getFirstChild(n2 = DTMDefaultBaseTraversers.this.getParent(n2)))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n4) == n3) {
                    return n4;
                }
                return this.next(n2, n4, n3);
            }
            do {
                if (-1 != (n4 = DTMDefaultBaseTraversers.this.getNextSibling(n2))) {
                    if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n4) == n3) {
                        return n4;
                    }
                    return this.next(n2, n4, n3);
                }
                n2 = DTMDefaultBaseTraversers.this.getParent(n2);
            } while (-1 == n4 && -1 != n2);
            return n4;
        }

        public int next(int n2, int n3) {
            short s2;
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3);
            do {
                if (-1 != (s2 = DTMDefaultBaseTraversers.this._type(++n3))) continue;
                return -1;
            } while (2 == s2 || 13 == s2);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
        }

        public int next(int n2, int n3, int n4) {
            int n5;
            n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3);
            do {
                if (-1 != (n5 = DTMDefaultBaseTraversers.this._exptype(++n3))) continue;
                return -1;
            } while (n5 != n4);
            return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
        }

        private FollowingTraverser() {
        }
    }

    private abstract class IndexedDTMAxisTraverser
    extends DTMAxisTraverser {
        protected abstract boolean axisHasBeenProcessed(int var1);

        protected final boolean isIndexed(int n2) {
            return DTMDefaultBaseTraversers.this.m_indexing && 1 == DTMDefaultBaseTraversers.this.m_expandedNameTable.getType(n2);
        }

        protected abstract boolean isAfterAxis(int var1, int var2);

        protected int getNextIndexed(int n2, int n3, int n4) {
            int n5 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getNamespaceID(n4);
            int n6 = DTMDefaultBaseTraversers.this.m_expandedNameTable.getLocalNameID(n4);
            while (true) {
                int n7;
                if (-2 != (n7 = DTMDefaultBaseTraversers.this.findElementFromIndex(n5, n6, n3))) {
                    if (this.isAfterAxis(n2, n7)) {
                        return -1;
                    }
                    return n7;
                }
                if (this.axisHasBeenProcessed(n2)) break;
                DTMDefaultBaseTraversers.this.nextNode();
            }
            return -1;
        }

        private IndexedDTMAxisTraverser() {
        }
    }

    private class NamespaceDeclsTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false)));
            return -1;
        }

        private NamespaceDeclsTraverser() {
        }
    }

    private class NamespaceTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true);
            do {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true)));
            return -1;
        }

        private NamespaceTraverser() {
        }
    }

    private class ParentTraverser
    extends DTMAxisTraverser {
        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getParent(n2);
        }

        public int first(int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            while (-1 != (n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n2);
            }
            return -1;
        }

        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }

        private ParentTraverser() {
        }
    }

    private class PrecedingAndAncestorTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            for (n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) - 1; n3 >= 0; --n3) {
                short s2 = DTMDefaultBaseTraversers.this._type(n3);
                if (2 == s2 || 13 == s2) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            for (n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) - 1; n3 >= 0; --n3) {
                int n6 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                if (n6 != n4) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            return -1;
        }

        private PrecedingAndAncestorTraverser() {
        }
    }

    private class PrecedingSiblingTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getPreviousSibling(n3);
        }

        public int next(int n2, int n3, int n4) {
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.getPreviousSibling(n3))) {
                if (DTMDefaultBaseTraversers.this.getExpandedTypeID(n3) != n4) continue;
                return n3;
            }
            return -1;
        }

        private PrecedingSiblingTraverser() {
        }
    }

    private class PrecedingTraverser
    extends DTMAxisTraverser {
        public int next(int n2, int n3) {
            int n4 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            for (n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) - 1; n3 >= 0; --n3) {
                short s2 = DTMDefaultBaseTraversers.this._type(n3);
                if (2 == s2 || 13 == s2 || this.isAncestor(n4, n3)) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            return -1;
        }

        protected boolean isAncestor(int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2);
            while (-1 != n2) {
                if (n2 == n3) {
                    return true;
                }
                n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2);
            }
            return false;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n2);
            for (n3 = DTMDefaultBaseTraversers.this.makeNodeIdentity(n3) - 1; n3 >= 0; --n3) {
                int n6 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                if (n6 != n4 || this.isAncestor(n5, n3)) continue;
                return DTMDefaultBaseTraversers.this.makeNodeHandle(n3);
            }
            return -1;
        }

        private PrecedingTraverser() {
        }
    }

    private class RootTraverser
    extends AllFromRootTraverser {
        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }

        private RootTraverser() {
        }
    }

    private class SelfTraverser
    extends DTMAxisTraverser {
        public int first(int n2) {
            return n2;
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getExpandedTypeID(n2) == n3 ? n2 : -1;
        }

        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }

        private SelfTraverser() {
        }
    }
}

