/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.Timeable;
import sun.misc.TimerThread;

public class Timer {
    public Timeable owner;
    long interval;
    long sleepUntil;
    long remainingTime;
    boolean regular;
    boolean stopped;
    Timer next;
    static TimerThread timerThread = null;

    public synchronized long getInterval() {
        return this.interval;
    }

    public synchronized long getRemainingTime() {
        return this.remainingTime;
    }

    public synchronized long getStopTime() {
        return this.sleepUntil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cont() {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (this.stopped) {
                    this.sleepUntil = Math.max(this.sleepUntil + 1L, System.currentTimeMillis() + this.remainingTime);
                    TimerThread.enqueue(this);
                    this.stopped = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                this.setRemainingTime(this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long l2 = System.currentTimeMillis();
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (!this.stopped) {
                    TimerThread.dequeue(this);
                    this.remainingTime = Math.max(0L, this.sleepUntil - l2);
                    this.sleepUntil = l2;
                    this.stopped = true;
                }
            }
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void setInterval(long l2) {
        this.interval = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemainingTime(long l2) {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (this.stopped) {
                    this.remainingTime = l2;
                } else {
                    this.stop();
                    this.remainingTime = l2;
                    this.cont();
                }
            }
        }
    }

    public synchronized void setRegular(boolean bl2) {
        this.regular = bl2;
    }

    protected Thread getTimerThread() {
        return TimerThread.timerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(Timeable timeable, long l2) {
        this.owner = timeable;
        this.interval = l2;
        this.remainingTime = l2;
        this.regular = true;
        this.sleepUntil = System.currentTimeMillis();
        this.stopped = true;
        Class clazz = this.getClass();
        synchronized (clazz) {
            if (timerThread == null) {
                timerThread = new TimerThread();
            }
        }
    }
}

