/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.PSPrinterJob;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    protected void deviceDrawLine(int n2, int n3, int n4, int n5, Color color) {
        this.draw(new Line2D.Float(n2, n3, n4, n5));
    }

    protected void deviceFillRect(int n2, int n3, int n4, int n5, Color color) {
        this.fill(new Rectangle2D.Float(n2, n3, n4, n5));
    }

    protected void deviceFrameRect(int n2, int n3, int n4, int n5, Color color) {
        this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    private boolean hasTransparentPixels(Image image) {
        Object object;
        ColorModel colorModel;
        boolean bl2 = true;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            object = (sun.awt.image.Image)image;
            bufferedImage = ((sun.awt.image.Image)object).getBufferedImage();
            if (bufferedImage == null) {
                return false;
            }
            colorModel = ((sun.awt.image.Image)object).getColorModel();
        } else {
            if (image instanceof VolatileImage) {
                return false;
            }
            colorModel = null;
        }
        boolean bl3 = colorModel == null ? true : (bl2 = colorModel.getTransparency() != 1);
        if (bl2 && bufferedImage != null && bufferedImage.getType() == 2) {
            object = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (object instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)object).getData();
                int n2 = bufferedImage.getMinX();
                int n3 = bufferedImage.getMinY();
                int n4 = bufferedImage.getWidth();
                int n5 = bufferedImage.getHeight();
                int n6 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl4 = false;
                for (int i2 = n3; i2 < n3 + n5; ++i2) {
                    int n7 = n3 * n6;
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        if ((nArray[n7 + i3] & 0xFF000000) == -16777216) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) break;
                }
                if (!bl4) {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private boolean isBitmaskTransparency(Image image) {
        ColorModel colorModel = null;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            sun.awt.image.Image image2 = (sun.awt.image.Image)image;
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            return false;
        }
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    private void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        int n2 = pathIterator.getWindingRule() == 0 ? 1 : 2;
        pSPrinterJob.setFillMode(n2);
        pSPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    pSPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pSPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f2 = pSPrinterJob.getPenX();
                    float f3 = pSPrinterJob.getPenY();
                    float f4 = f2 + (fArray[0] - f2) * 2.0f / 3.0f;
                    float f5 = f3 + (fArray[1] - f3) * 2.0f / 3.0f;
                    float f6 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f7 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    pSPrinterJob.bezierTo(f4, f5, f6, f7, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pSPrinterJob.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pSPrinterJob.closeSubpath();
                }
            }
            pathIterator.next();
        }
    }

    protected void deviceClip(PathIterator pathIterator) {
    }

    public void drawString(String string, float f2, float f3) {
        PSPrinterJob pSPrinterJob;
        boolean bl2 = false;
        boolean bl3 = this.getFont().getTransform().isIdentity();
        if (!PSPrinterJob.shapeTextProp && bl3 && (pSPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                pSPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Expected a Color instance");
            }
            pSPrinterJob.setTransform(this.getTransform());
            pSPrinterJob.setClip(this.getClip());
            bl2 = pSPrinterJob.textOut(this, string, f2, f3);
        }
        if (!bl2) {
            super.drawString(string, f2, f3);
        }
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public void fill(Shape shape, Color color) {
        this.deviceFill(shape.getPathIterator(new AffineTransform()), color);
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.setTransform(this.getTransform());
        pSPrinterJob.setClip(this.getClip());
        pSPrinterJob.setColor(color);
        this.convertToPSPath(pathIterator);
        pSPrinterJob.fillPath();
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n2, n3, false);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        int n4 = bufferedImage.getWidth(null);
        int n5 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n4 <= 0 || n5 <= 0) {
            boolean bl2 = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n2, n3);
            boolean bl3 = this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n4, n5, false);
        }
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d2, double d3, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n2 = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, pSPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f2 = (float)(pSPrinterJob.getXRes() / d2);
        float f3 = (float)(pSPrinterJob.getYRes() / d3);
        proxyGraphics2D.scale(f2 / 72.0f, f3 / 72.0f);
        proxyGraphics2D.translate(-pSPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / pSPrinterJob.getXRes() * 72.0, -pSPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / pSPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n2);
        graphics2D.dispose();
        Shape shape = this.getClip();
        pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        pSPrinterJob.drawImageBGR(byteInterleavedRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        if (n10 <= 0 || n11 <= 0) {
            return false;
        }
        float f2 = (float)(n4 - n2) / (float)n10;
        float f3 = (float)(n5 - n3) / (float)n11;
        AffineTransform affineTransform = new AffineTransform(f2, 0.0f, 0.0f, f3, (float)n2 - (float)n6 * f2, (float)n3 - (float)n7 * f3);
        return this.drawImageToPS(image, affineTransform, null, color, n6, n7, n10, n11, false);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        boolean bl2 = n6 <= 0 || n7 <= 0 ? false : this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n6, n7, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        boolean bl2 = n4 <= 0 || n5 <= 0 ? false : this.drawImage(image, n2, n3, n4, n5, color, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        boolean bl2 = n2 <= 0 || n3 <= 0 ? false : this.drawImageToPS(image, affineTransform, null, null, 0, 0, n2, n3, false);
        return bl2;
    }

    private boolean drawBitmaskImage(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        Image image2;
        ColorModel colorModel;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            image2 = (sun.awt.image.Image)image;
            bufferedImage = image2.getBufferedImage();
            if (bufferedImage == null) {
                return true;
            }
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            bufferedImage = ((VolatileImage)image).getSnapshot();
            colorModel = bufferedImage.getColorModel();
        } else {
            return false;
        }
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (bufferedImageOp != null) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        image2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n10 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n10 >= 0) {
            byArray[n10] = 0;
        }
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        if (n2 > n11 || n3 > n12) {
            return false;
        }
        if (n2 + n4 > n11) {
            n9 = n11;
            n8 = n9 - n2;
        } else {
            n9 = n2 + n4;
            n8 = n4;
        }
        if (n3 + n5 > n12) {
            n7 = n12;
            n6 = n7 - n3;
        } else {
            n7 = n3 + n5;
            n6 = n5;
        }
        int[] nArray = new int[n8];
        for (int i2 = n3; i2 < n7; ++i2) {
            int n13 = -1;
            writableRaster.getPixels(n2, i2, n8, 1, nArray);
            for (int i3 = n2; i3 < n9; ++i3) {
                if (byArray[nArray[i3 - n2]] == 0) {
                    if (n13 < 0) continue;
                    image2 = bufferedImage.getSubimage(n13, i2, i3 - n13, 1);
                    affineTransform.translate(n13, i2);
                    this.drawImageToPS(image2, affineTransform, bufferedImageOp, color, 0, 0, i3 - n13, 1, true);
                    affineTransform.translate(-n13, -i2);
                    n13 = -1;
                    continue;
                }
                if (n13 >= 0) continue;
                n13 = i3;
            }
            if (n13 < 0) continue;
            image2 = bufferedImage.getSubimage(n13, i2, n9 - n13, 1);
            affineTransform.translate(n13, i2);
            this.drawImageToPS(image2, affineTransform, bufferedImageOp, color, 0, 0, n9 - n13, 1, true);
            affineTransform.translate(-n13, -i2);
        }
        return true;
    }

    private boolean drawImageToPS(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Object object;
        if (image instanceof sun.awt.image.Image && ((sun.awt.image.Image)(object = (sun.awt.image.Image)image)).getBufferedImage() == null) {
            return false;
        }
        object = (PSPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d2 = float_.distance(float_3);
        double d3 = float_2.distance(float_3);
        if (d2 != 0.0 && d3 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d2, dArray[1] / d3, dArray[2] / d2, dArray[3] / d3, dArray[4] / d2, dArray[5] / d3);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n2, n3, n4, n5);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n6 = (int)rectangle2D.getWidth();
            int n7 = (int)rectangle2D.getHeight();
            if (n6 > 0 && n7 > 0) {
                boolean bl3 = true;
                if (!bl2 && this.hasTransparentPixels(image)) {
                    bl3 = false;
                    if (this.isBitmaskTransparency(image)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(image, affineTransform, bufferedImageOp, color, n2, n3, n4, n5)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl3 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl3 = true;
                    }
                } else {
                    color = null;
                }
                if ((n2 + n4 > image.getWidth(null) || n3 + n5 > image.getHeight(null)) && this.canDoRedraws()) {
                    bl3 = false;
                }
                if (!bl3) {
                    ((RasterPrinterJob)object).saveState(this.getTransform(), this.getClip(), rectangle2D, d2, d3, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(image, n2, n3, n2 + n4, n3 + n5, n2, n3, n2 + n4, n3 + n5, color, null);
                Shape shape2 = this.getClip();
                Shape shape3 = this.getTransform().createTransformedShape(shape2);
                AffineTransform affineTransform4 = AffineTransform.getScaleInstance(d2, d3);
                Shape shape4 = affineTransform4.createTransformedShape(shape);
                Area area = new Area(shape4);
                Area area2 = new Area(shape3);
                area.intersect(area2);
                ((PSPrinterJob)object).setClip(area);
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
                ((PSPrinterJob)object).drawImageBGR(byteInterleavedRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
                ((PSPrinterJob)object).setClip(this.getTransform().createTransformedShape(shape2));
                graphics2D.dispose();
            }
        }
        return true;
    }

    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2, boolean bl2) {
        super(graphics2D, printerJob, printable, pageFormat, n2, bl2);
    }
}

