/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.awt.windows.WPrinterJob;
import sun.print.AttributeUpdater;
import sun.print.ServiceNotifier;
import sun.print.SunAlternateMedia;
import sun.print.SunPrinterJobService;
import sun.print.Win32MediaSize;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintJob;

public class Win32PrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    public static MediaSize[] predefMedia;
    private static final DocFlavor[] supportedFlavors;
    private static final Class[] serviceAttrCats;
    private static Class[] otherAttrCats;
    private static final MediaSizeName[] dmPaperToPrintService;
    private static final MediaTray[] dmPaperBinToPrintService;
    private static int DM_PAPERSIZE;
    private static int DM_PRINTQUALITY;
    private static int DM_YRESOLUTION;
    private static final int DMRES_MEDIUM = -3;
    private static final int DMRES_HIGH = -4;
    private static final int DMORIENT_LANDSCAPE = 2;
    private static final int DMDUP_VERTICAL = 2;
    private static final int DMDUP_HORIZONTAL = 3;
    private static final int DMCOLLATE_TRUE = 1;
    private static final int DMPAPER_A2 = 66;
    private static final int DMPAPER_A6 = 70;
    private static final int DMPAPER_B6_JIS = 88;
    private String printer;
    private PrinterName name;
    private String port;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private DocFlavor[] supportedDocFlavors;
    private MediaSizeName[] mediaSizeNames;
    private MediaPrintableArea[] mediaPrintables;
    private MediaTray[] mediaTrays;
    private PrinterResolution[] printRes;
    private int nCopies;
    private int lenOptAttrCats;
    private int defQuality;
    private int defPaper;
    private int defYRes;
    private int defMedia;
    private int defCopies;
    private int defOrient;
    private int defCollate;
    private int defSides;
    private boolean isResSup;
    private boolean isCollateSup;
    private boolean isColorSup;
    private boolean isSidesSup;
    private boolean isPrQualitySup;
    private boolean gotTrays;
    private boolean gotCopies;
    private boolean mediaInitialized;
    private ArrayList idList;
    private MediaSize[] mediaSizes;

    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    static {
        Class clazz = Win32MediaSize.class;
        supportedFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        serviceAttrCats = new Class[]{PrinterName.class, PrinterIsAcceptingJobs.class, QueuedJobCount.class, ColorSupported.class};
        otherAttrCats = new Class[]{JobName.class, RequestingUserName.class, Copies.class, Destination.class, OrientationRequested.class, PageRanges.class, Media.class, MediaPrintableArea.class, Fidelity.class, SunAlternateMedia.class, Chromaticity.class};
        dmPaperToPrintService = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.INVOICE, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.B, MediaSizeName.NA_LETTER, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.FOLIO, MediaSizeName.ISO_B4, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE};
        dmPaperBinToPrintService = new MediaTray[]{MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, Win32MediaTray.ENVELOPE_MANUAL, Win32MediaTray.AUTO, Win32MediaTray.TRACTOR, Win32MediaTray.SMALL_FORMAT, Win32MediaTray.LARGE_FORMAT, MediaTray.LARGE_CAPACITY, null, null, MediaTray.MAIN, Win32MediaTray.FORMSOURCE};
        DM_PAPERSIZE = 2;
        DM_PRINTQUALITY = 1024;
        DM_YRESOLUTION = 8192;
    }

    private synchronized void initMedia() {
        int n2;
        if (this.mediaInitialized) {
            return;
        }
        this.mediaInitialized = true;
        int[] nArray = this.getAllMediaIDs(this.printer, this.port);
        if (nArray == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.idList = new ArrayList();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.idList.add(new Integer(nArray[n2]));
        }
        this.mediaSizes = this.getMediaSizes(this.idList, nArray);
        for (n2 = 0; n2 < this.idList.size(); ++n2) {
            boolean bl2;
            MediaSizeName mediaSizeName = this.findWin32Media((Integer)this.idList.get(n2));
            if (mediaSizeName == null && this.idList.size() == this.mediaSizes.length) {
                mediaSizeName = this.mediaSizes[n2].getMediaSizeName();
            }
            if (mediaSizeName == null || !(bl2 = this.addToUniqueList(arrayList, mediaSizeName))) continue;
            float[] fArray = this.getMediaPrintableArea(this.printer, (Integer)this.idList.get(n2));
            try {
                MediaPrintableArea mediaPrintableArea = new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
                arrayList2.add(mediaPrintableArea);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mediaSizeNames = new MediaSizeName[arrayList.size()];
        arrayList.toArray(this.mediaSizeNames);
        this.mediaPrintables = new MediaPrintableArea[arrayList2.size()];
        arrayList2.toArray(this.mediaPrintables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    private boolean isSameSize(float f2, float f3, float f4, float f5) {
        float f6 = f2 - f4;
        float f7 = f3 - f5;
        float f8 = f2 - f5;
        float f9 = f3 - f4;
        return Math.abs(f6) <= 1.0f && Math.abs(f7) <= 1.0f || Math.abs(f8) <= 1.0f && Math.abs(f9) <= 1.0f;
    }

    public Class[] getSupportedAttributeCategories() {
        int n2 = otherAttrCats.length;
        Class[] classArray = new Class[n2 + this.lenOptAttrCats];
        System.arraycopy(otherAttrCats, 0, classArray, 0, otherAttrCats.length);
        int n3 = n2;
        if (this.isSidesSup) {
            classArray[n3++] = Sides.class;
        }
        Class clazz = classArray[n3++] = SheetCollate.class;
        if (this.isPrQualitySup) {
            Class clazz2 = classArray[n3++] = PrintQuality.class;
        }
        if (this.isResSup) {
            classArray[n3++] = PrinterResolution.class;
        }
        return classArray;
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        for (int i2 = 0; i2 < otherAttrCats.length; ++i2) {
            if (clazz != otherAttrCats[i2]) continue;
            return true;
        }
        if (clazz == Sides.class && this.isSidesSup) {
            return true;
        }
        if (clazz == SheetCollate.class) {
            return true;
        }
        if (clazz == PrintQuality.class && this.isPrQualitySup) {
            return true;
        }
        return clazz == PrinterResolution.class && this.isResSup;
    }

    private boolean isPSDocAttr(Class clazz) {
        return clazz == OrientationRequested.class;
    }

    public boolean usesClass(Class clazz) {
        return clazz == WPrinterJob.class;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Win32PrintService && ((Win32PrintService)object).getName().equals(this.getName());
    }

    public String getName() {
        return this.printer;
    }

    public String toString() {
        return "Win32 Printer : " + this.getName();
    }

    Win32PrintService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
        this.mediaInitialized = false;
        this.gotTrays = false;
        this.gotCopies = false;
        this.lenOptAttrCats = 0;
        this.port = this.getPrinterPort(this.printer);
        int n2 = this.getCapabilities(this.printer, this.port);
        this.isColorSup = (n2 & 1) != 0;
        this.isSidesSup = (n2 & 2) != 0;
        if (this.isSidesSup) {
            ++this.lenOptAttrCats;
        }
        this.isCollateSup = (n2 & 4) != 0;
        ++this.lenOptAttrCats;
        int[] nArray = this.getDefaultSettings(this.printer);
        this.defPaper = nArray[0];
        this.defMedia = nArray[1];
        this.defYRes = nArray[2];
        this.defQuality = nArray[3];
        this.defCopies = nArray[4];
        this.defOrient = nArray[5];
        this.defSides = nArray[6];
        this.defCollate = nArray[7];
        boolean bl2 = this.isPrQualitySup = (n2 & 8) != 0 && this.defQuality >= -4 && this.defQuality < 0;
        if (this.isPrQualitySup) {
            ++this.lenOptAttrCats;
        }
        int n3 = supportedFlavors.length;
        if ((n2 & 0x10) != 0) {
            this.supportedDocFlavors = new DocFlavor[n3 + 3];
            System.arraycopy(supportedFlavors, 0, this.supportedDocFlavors, 0, n3);
            this.supportedDocFlavors[n3] = DocFlavor.BYTE_ARRAY.POSTSCRIPT;
            this.supportedDocFlavors[n3 + 1] = DocFlavor.INPUT_STREAM.POSTSCRIPT;
            this.supportedDocFlavors[n3 + 2] = DocFlavor.URL.POSTSCRIPT;
        } else {
            this.supportedDocFlavors = new DocFlavor[n3];
            System.arraycopy(supportedFlavors, 0, this.supportedDocFlavors, 0, n3);
        }
        this.printRes = this.getPrintResolutions();
        if (this.printRes != null && (this.isResSup = this.printRes.length > 0)) {
            ++this.lenOptAttrCats;
        }
    }

    private native int[] getDefaultSettings(String var1);

    private native int getJobStatus(String var1, int var2);

    private native float[] getMediaPrintableArea(String var1, int var2);

    public DocFlavor[] getSupportedDocFlavors() {
        int n2 = this.supportedDocFlavors.length;
        DocFlavor[] docFlavorArray = new DocFlavor[n2];
        System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n2);
        return docFlavorArray;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        for (int i2 = 0; i2 < this.supportedDocFlavors.length; ++i2) {
            if (!docFlavor.equals(this.supportedDocFlavors[i2])) continue;
            return true;
        }
        return false;
    }

    private boolean isPostScriptFlavor(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT) || docFlavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) || docFlavor.equals(DocFlavor.URL.POSTSCRIPT);
    }

    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new Win32PrintJob(this);
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterName());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        if (this.isColorSup) {
            hashPrintServiceAttributeSet.add(ColorSupported.SUPPORTED);
        } else {
            hashPrintServiceAttributeSet.add(ColorSupported.NOT_SUPPORTED);
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        return hashPrintServiceAttributeSet;
    }

    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet printServiceAttributeSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = printServiceAttributeSet;
            return AttributeSetUtilities.unmodifiableView(printServiceAttributeSet);
        }
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute = attributeArray[i2];
            if (this.lastSet.containsValue(attribute)) continue;
            hashPrintServiceAttributeSet.add(attribute);
        }
        this.lastSet = printServiceAttributeSet;
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportedCopies(Copies copies) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (!this.gotCopies) {
                this.nCopies = this.getCopiesSupported(this.printer, this.port);
                this.gotCopies = true;
            }
        }
        int n2 = copies.getValue();
        return n2 > 0 && n2 <= this.nCopies;
    }

    private boolean isSupportedMediaPrintableArea(MediaPrintableArea mediaPrintableArea) {
        if (!this.mediaInitialized) {
            this.initMedia();
        }
        if (this.mediaPrintables != null) {
            for (int i2 = 0; i2 < this.mediaPrintables.length; ++i2) {
                if (!mediaPrintableArea.equals(this.mediaPrintables[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private MediaSizeName findMatchingMediaSizeNameMM(float f2, float f3) {
        if (predefMedia != null) {
            for (int i2 = 0; i2 < predefMedia.length; ++i2) {
                if (predefMedia[i2] == null || !this.isSameSize(predefMedia[i2].getX(1000), predefMedia[i2].getY(1000), f2, f3)) continue;
                return predefMedia[i2].getMediaSizeName();
            }
        }
        return null;
    }

    private MediaSizeName findWin32Media(int n2) {
        if (n2 >= 1 && n2 <= dmPaperToPrintService.length) {
            switch (n2) {
                case 66: {
                    return MediaSizeName.ISO_A2;
                }
                case 70: {
                    return MediaSizeName.ISO_A6;
                }
                case 88: {
                    return MediaSizeName.JIS_B6;
                }
            }
            return dmPaperToPrintService[n2 - 1];
        }
        return null;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        if (!this.mediaInitialized) {
            this.initMedia();
        }
        if (this.mediaSizeNames != null) {
            for (int i2 = 0; i2 < this.mediaSizeNames.length; ++i2) {
                if (!mediaSizeName.equals(this.mediaSizeNames[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized MediaTray[] getMediaTrays() {
        if (this.gotTrays) {
            return this.mediaTrays;
        }
        this.gotTrays = true;
        int[] nArray = this.getAllMediaTrays(this.printer, this.port);
        String[] stringArray = this.getAllMediaTrayNames(this.printer, this.port);
        if (nArray == null || stringArray == null) {
            return null;
        }
        int n2 = nArray.length;
        MediaTray[] mediaTrayArray = new MediaTray[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 > dmPaperBinToPrintService.length || dmPaperBinToPrintService[n3 - 1] == null) {
                Win32MediaTray win32MediaTray = new Win32MediaTray(n3, stringArray[i2]);
                mediaTrayArray[i2] = win32MediaTray;
                continue;
            }
            mediaTrayArray[i2] = n3 < 1 ? MediaTray.MAIN : dmPaperBinToPrintService[n3 - 1];
        }
        return mediaTrayArray;
    }

    private boolean isSupportedMediaTray(MediaTray mediaTray) {
        if (!this.gotTrays) {
            this.mediaTrays = this.getMediaTrays();
        }
        if (this.mediaTrays != null) {
            for (int i2 = 0; i2 < this.mediaTrays.length; ++i2) {
                if (!mediaTray.equals(this.mediaTrays[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (this.getJobStatus(this.printer, 2) != 1) {
            return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    private PrinterResolution[] getPrintResolutions() {
        int[] nArray = this.getAllResolutions(this.printer, this.port);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length / 2;
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                PrinterResolution printerResolution = new PrinterResolution(nArray[i2 * 2], nArray[i2 * 2 + 1], 100);
                arrayList.add(printerResolution);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])arrayList.toArray(new PrinterResolution[arrayList.size()]);
        return printerResolutionArray;
    }

    private boolean isSupportedResolution(PrinterResolution printerResolution) {
        if (this.printRes != null) {
            for (int i2 = 0; i2 < this.printRes.length; ++i2) {
                if (!printerResolution.equals(this.printRes[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private QueuedJobCount getQueuedJobCount() {
        int n2 = this.getJobStatus(this.printer, 1);
        if (n2 != -1) {
            return new QueuedJobCount(n2);
        }
        return new QueuedJobCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDefaultAttributeValue(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == Copies.class) {
            if (this.defCopies <= 0) return new Copies(1);
            return new Copies(this.defCopies);
        }
        if (clazz == Chromaticity.class) {
            if (this.isColorSup) return Chromaticity.COLOR;
            return Chromaticity.MONOCHROME;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == OrientationRequested.class) {
            if (this.defOrient != 2) return OrientationRequested.PORTRAIT;
            return OrientationRequested.LANDSCAPE;
        }
        if (clazz == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == Media.class) {
            MediaSizeName mediaSizeName = this.findWin32Media(this.defPaper);
            if (mediaSizeName != null) {
                return mediaSizeName;
            }
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            if (this.mediaSizeNames == null) return null;
            if (this.mediaSizeNames.length <= 0) return null;
            if (this.idList == null) return this.mediaSizeNames[0];
            if (this.mediaSizes == null) return this.mediaSizeNames[0];
            if (this.idList.size() != this.mediaSizes.length) return this.mediaSizeNames[0];
            Integer n2 = new Integer(this.defPaper);
            int n3 = this.idList.indexOf(n2);
            if (n3 < 0) return this.mediaSizeNames[0];
            if (n3 >= this.mediaSizes.length) return this.mediaSizeNames[0];
            return this.mediaSizes[n3].getMediaSizeName();
        }
        if (clazz == MediaPrintableArea.class) {
            float[] fArray = this.getMediaPrintableArea(this.printer, this.defPaper);
            MediaPrintableArea mediaPrintableArea = null;
            try {
                return new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return mediaPrintableArea;
        }
        if (clazz == SunAlternateMedia.class) {
            return null;
        }
        if (clazz == Destination.class) {
            return new Destination(new File("out.prn").toURI());
        }
        if (clazz == Sides.class) {
            switch (this.defSides) {
                case 2: {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                case 3: {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        if (clazz == PrinterResolution.class) {
            int n4 = this.defYRes;
            int n5 = this.defQuality;
            if (n5 >= 0) {
                if (n4 >= 0) return new PrinterResolution(n5, n4, 100);
            }
            int n6 = n4 > n5 ? n4 : n5;
            if (n6 <= 0) return null;
            return new PrinterResolution(n6, n6, 100);
        }
        if (clazz == ColorSupported.class) {
            if (!this.isColorSup) return ColorSupported.NOT_SUPPORTED;
            return ColorSupported.SUPPORTED;
        }
        if (clazz == PrintQuality.class) {
            if (this.defQuality >= 0) return null;
            if (this.defQuality < -4) return null;
            switch (this.defQuality) {
                case -4: {
                    return PrintQuality.HIGH;
                }
                case -3: {
                    return PrintQuality.NORMAL;
                }
            }
            return PrintQuality.DRAFT;
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
                return new RequestingUserName(string, null);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == SheetCollate.class) {
            if (this.defCollate != 1) return SheetCollate.UNCOLLATED;
            return SheetCollate.COLLATED;
        }
        if (clazz != Fidelity.class) return null;
        return Fidelity.FIDELITY_FALSE;
    }

    private native String getPrinterPort(String var1);

    private native int getCapabilities(String var1, String var2);

    private native int getCopiesSupported(String var1, String var2);

    private native int[] getAllMediaIDs(String var1, String var2);

    private native int[] getAllMediaSizes(String var1, String var2);

    private native int[] getAllMediaTrays(String var1, String var2);

    private native int[] getAllResolutions(String var1, String var2);

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == ColorSupported.class) {
            if (this.isColorSup) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == PrinterName.class) {
            return this.getPrinterName();
        }
        if (clazz == QueuedJobCount.class) {
            return this.getQueuedJobCount();
        }
        if (clazz == PrinterIsAcceptingJobs.class) {
            return this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    private MediaSize[] getMediaSizes(ArrayList arrayList, int[] nArray) {
        int[] nArray2 = this.getAllMediaSizes(this.printer, this.port);
        String[] stringArray = this.getAllMediaNames(this.printer, this.port);
        MediaSizeName mediaSizeName = null;
        MediaSize mediaSize = null;
        if (nArray2 == null || stringArray == null) {
            return null;
        }
        int n2 = nArray2.length / 2;
        ArrayList arrayList2 = new ArrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            block10: {
                Serializable serializable;
                float f2 = nArray2[i2 * 2] / 10;
                float f3 = nArray2[i2 * 2 + 1] / 10;
                if (f2 <= 0.0f || f3 <= 0.0f) {
                    if (n2 == nArray.length) {
                        serializable = new Integer(nArray[i2]);
                        arrayList.remove(arrayList.indexOf(serializable));
                    }
                } else {
                    mediaSizeName = this.findMatchingMediaSizeNameMM(f2, f3);
                    if (mediaSizeName != null) {
                        mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                    }
                    if (mediaSize != null) {
                        arrayList2.add(mediaSize);
                    } else {
                        serializable = new Win32MediaSize(stringArray[i2]);
                        try {
                            mediaSize = new MediaSize(f2, f3, 1000, (MediaSizeName)serializable);
                            arrayList2.add(mediaSize);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (n2 != nArray.length) break block10;
                            Integer n3 = new Integer(nArray[i2]);
                            arrayList.remove(arrayList.indexOf(n3));
                        }
                    }
                }
            }
            mediaSize = null;
        }
        Object[] objectArray = new MediaSize[arrayList2.size()];
        arrayList2.toArray(objectArray);
        return objectArray;
    }

    private boolean addToUniqueList(ArrayList arrayList, MediaSizeName mediaSizeName) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            MediaSizeName mediaSizeName2 = (MediaSizeName)arrayList.get(i2);
            if (mediaSizeName2 != mediaSizeName) continue;
            return false;
        }
        arrayList.add(mediaSizeName);
        return true;
    }

    private native String[] getAllMediaNames(String var1, String var2);

    private native String[] getAllMediaTrayNames(String var1, String var2);

    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        Class clazz = attribute.getCategory();
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                if (this.isColorSup) {
                    return true;
                }
                return attribute == Chromaticity.MONOCHROME;
            }
            return false;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Destination.class) {
            URI uRI = ((Destination)attribute).getURI();
            return "file".equals(uRI.getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == Media.class) {
            if (attribute instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attribute);
            }
            if (attribute instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attribute);
            }
        } else {
            if (attribute.getCategory() == MediaPrintableArea.class) {
                return this.isSupportedMediaPrintableArea((MediaPrintableArea)attribute);
            }
            if (attribute.getCategory() == SunAlternateMedia.class) {
                Media media = ((SunAlternateMedia)attribute).getMedia();
                return this.isAttributeValueSupported(media, docFlavor, attributeSet);
            }
            if (attribute.getCategory() == PageRanges.class) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == SheetCollate.class) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == Sides.class) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == PrinterResolution.class) {
                if (attribute instanceof PrinterResolution) {
                    return this.isSupportedResolution((PrinterResolution)attribute);
                }
            } else if (attribute.getCategory() == OrientationRequested.class ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) && !docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) && !docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) && !docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) && !docFlavor.equals(DocFlavor.URL.GIF) && !docFlavor.equals(DocFlavor.URL.JPEG) && !docFlavor.equals(DocFlavor.URL.PNG) : attribute.getCategory() == ColorSupported.class && (!this.isColorSup && attribute == ColorSupported.SUPPORTED || this.isColorSup && attribute == ColorSupported.NOT_SUPPORTED)) {
                return false;
            }
        }
        return true;
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            try {
                Attribute attribute = attributeArray[i2];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == ColorSupported.class) {
            if (this.isColorSup) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                if (!this.isColorSup) {
                    Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME};
                    return chromaticityArray;
                }
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == Destination.class) {
            return new Destination(new File("out.prn").toURI());
        }
        if (clazz == OrientationRequested.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            Win32PrintService win32PrintService = this;
            synchronized (win32PrintService) {
                if (!this.gotCopies) {
                    this.nCopies = this.getCopiesSupported(this.printer, this.port);
                    this.gotCopies = true;
                }
            }
            return new CopiesSupported(1, this.nCopies);
        }
        if (clazz == Media.class) {
            int n2;
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            int n3 = n2 = this.mediaSizeNames == null ? 0 : this.mediaSizeNames.length;
            if (!this.gotTrays) {
                this.mediaTrays = this.getMediaTrays();
            }
            Media[] mediaArray = new Media[n2 += this.mediaTrays == null ? 0 : this.mediaTrays.length];
            if (this.mediaSizeNames != null) {
                System.arraycopy(this.mediaSizeNames, 0, mediaArray, 0, this.mediaSizeNames.length);
            }
            if (this.mediaTrays != null) {
                System.arraycopy(this.mediaTrays, 0, mediaArray, this.mediaSizeNames.length, this.mediaTrays.length);
            }
            return mediaArray;
        }
        if (clazz == MediaPrintableArea.class) {
            Media media;
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            if (this.mediaPrintables == null) {
                return null;
            }
            if (attributeSet != null && (media = (Media)attributeSet.get(Media.class)) != null && media instanceof MediaSizeName) {
                MediaSize mediaSize;
                MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[1];
                if (this.mediaSizeNames.length == this.mediaPrintables.length) {
                    for (int i2 = 0; i2 < this.mediaSizeNames.length; ++i2) {
                        if (!media.equals(this.mediaSizeNames[i2])) continue;
                        mediaPrintableAreaArray[0] = this.mediaPrintables[i2];
                        return mediaPrintableAreaArray;
                    }
                }
                if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) != null) {
                    mediaPrintableAreaArray[0] = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(25400), mediaSize.getY(25400), 25400);
                    return mediaPrintableAreaArray;
                }
                return null;
            }
            MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[this.mediaPrintables.length];
            System.arraycopy(this.mediaPrintables, 0, mediaPrintableAreaArray, 0, this.mediaPrintables.length);
            return mediaPrintableAreaArray;
        }
        if (clazz == SunAlternateMedia.class) {
            return new SunAlternateMedia((Media)this.getDefaultAttributeValue(Media.class));
        }
        if (clazz == PageRanges.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == PrinterResolution.class) {
            if (this.printRes == null) {
                return null;
            }
            PrinterResolution[] printerResolutionArray = new PrinterResolution[this.printRes.length];
            System.arraycopy(this.printRes, 0, printerResolutionArray, 0, this.printRes.length);
            return printerResolutionArray;
        }
        if (clazz == Sides.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        if (clazz == PrintQuality.class) {
            PrintQuality[] printQualityArray = new PrintQuality[]{PrintQuality.DRAFT, PrintQuality.HIGH, PrintQuality.NORMAL};
            return printQualityArray;
        }
        if (clazz == SheetCollate.class) {
            if (this.isCollateSup && (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE))) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.COLLATED, SheetCollate.UNCOLLATED};
                return sheetCollateArray;
            }
            SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return sheetCollateArray;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        return null;
    }
}

