/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.krb5.Krb5NameElement;

public class GSSUtil {
    private static void populateCredentials(Set set, Set set2) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            Object object = iterator.next();
            if (object instanceof KerberosTicket && !object.getClass().getName().equals("javax.security.auth.kerberos.KerberosTicket")) {
                KerberosTicket kerberosTicket = (KerberosTicket)object;
                serializable = new KerberosTicket(kerberosTicket.getEncoded(), kerberosTicket.getClient(), kerberosTicket.getServer(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
                set.add(serializable);
                continue;
            }
            if (object instanceof KerberosKey && !object.getClass().getName().equals("javax.security.auth.kerberos.KerberosKey")) {
                KerberosKey kerberosKey = (KerberosKey)object;
                serializable = new KerberosKey(kerberosKey.getPrincipal(), kerberosKey.getEncoded(), kerberosKey.getKeyType(), kerberosKey.getVersionNumber());
                set.add(serializable);
                continue;
            }
            set.add(object);
        }
    }

    private static void populatePrincipals(Set set, Set set2) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Krb5NameElement) {
                KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(((Krb5NameElement)object).getKrb5PrincipalName().getName());
                set.add(kerberosPrincipal);
                continue;
            }
            throw new UnsupportedOperationException("Unknown principal class: " + object.getClass().getName());
        }
    }

    public static Subject getSubject(GSSName gSSName, GSSCredential gSSCredential) {
        HashSet hashSet = null;
        HashSet hashSet2 = null;
        HashSet hashSet3 = new HashSet();
        Set set = null;
        Set set2 = null;
        if (gSSName instanceof GSSNameImpl) {
            set = ((GSSNameImpl)gSSName).getElements();
            hashSet = new HashSet(set.size());
            GSSUtil.populatePrincipals(hashSet, set);
        } else {
            hashSet = new HashSet();
        }
        if (gSSCredential instanceof GSSCredentialImpl) {
            set2 = ((GSSCredentialImpl)gSSCredential).getElements();
            hashSet2 = new HashSet(set2.size());
            GSSUtil.populateCredentials(hashSet2, set2);
        } else {
            hashSet2 = new HashSet();
        }
        return new Subject(false, hashSet, hashSet3, hashSet2);
    }
}

