/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public abstract class Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    final PKIXBuilderParameters buildParams;
    final X500Principal targetSubjectDN;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void removeFinalCertFromPath(LinkedList var1);

    Set getMatchingPolicies() {
        Set set = this.buildParams.getInitialPolicies();
        if (!set.isEmpty() && !set.contains("2.5.29.32.0") && this.buildParams.isPolicyMappingInhibited()) {
            set.add("2.5.29.32.0");
            return set;
        }
        return new HashSet();
    }

    abstract Collection getMatchingCerts(State var1) throws CertStoreException, CertificateException, IOException;

    abstract void addCertToPath(X509Certificate var1, LinkedList var2);

    Builder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal) {
        this.buildParams = pKIXBuilderParameters;
        this.targetSubjectDN = x500Principal;
    }

    static int distance(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        switch (generalNameInterface.constrains(generalNameInterface2)) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                throw new IOException("Names are same type but in different subtrees");
            }
            case 0: {
                return 0;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
    }

    static int hops(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        int n2 = generalNameInterface.constrains(generalNameInterface2);
        switch (n2) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                break;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            case 1: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        if (generalNameInterface.getType() != 4) {
            throw new IOException("hopDistance not implemented for this name type");
        }
        X500Name x500Name = (X500Name)generalNameInterface;
        X500Name x500Name2 = (X500Name)generalNameInterface2;
        X500Name x500Name3 = x500Name.commonAncestor(x500Name2);
        if (x500Name3 == null) {
            throw new IOException("Names are in different namespaces");
        }
        int n3 = x500Name3.subtreeDepth();
        int n4 = x500Name.subtreeDepth();
        int n5 = x500Name2.subtreeDepth();
        return n4 + n5 - 2 * n3;
    }

    static void addMatchingCerts(X509CertSelector x509CertSelector, Collection collection, Collection collection2) {
        X509Certificate x509Certificate = x509CertSelector.getCertificate();
        if (x509Certificate != null) {
            if (x509CertSelector.match(x509Certificate) && !X509CertImpl.isSelfIssued(x509Certificate)) {
                collection2.add(x509Certificate);
            }
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                Collection collection3 = certStore.getCertificates(x509CertSelector);
                Iterator iterator2 = collection3.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate x509Certificate2 = (X509Certificate)iterator2.next();
                    if (X509CertImpl.isSelfIssued(x509Certificate2)) continue;
                    collection2.add(x509Certificate2);
                }
            }
            catch (CertStoreException certStoreException) {
            }
        }
    }

    abstract void verifyCert(X509Certificate var1, State var2, List var3) throws GeneralSecurityException;

    static int targetDistance(NameConstraintsExtension object, X509Certificate x509Certificate, GeneralNameInterface generalNameInterface) throws IOException {
        Object object2;
        X509CertImpl x509CertImpl;
        if (object != null && !((NameConstraintsExtension)object).verify(x509Certificate)) {
            throw new IOException("certificate does not satisfy existing name constraints");
        }
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw (IOException)new IOException("Invalid certificate").initCause(certificateException);
        }
        X500Name x500Name = X500Name.asX500Name(x509CertImpl.getSubjectX500Principal());
        if (x500Name.equals(generalNameInterface)) {
            return 0;
        }
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = x509CertImpl.getSubjectAlternativeNameExtension();
        if (subjectAlternativeNameExtension != null) {
            object2 = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            if (object2 != null) {
                int n2 = ((GeneralNames)object2).size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    GeneralNameInterface generalNameInterface2 = ((GeneralNames)object2).get(i2).getName();
                    if (!generalNameInterface2.equals(generalNameInterface)) continue;
                    return 0;
                }
            }
        }
        if ((object2 = x509CertImpl.getNameConstraintsExtension()) == null) {
            return -1;
        }
        if (object != null) {
            ((NameConstraintsExtension)object).merge((NameConstraintsExtension)object2);
        } else {
            object = object2 == null ? new NameConstraintsExtension(new GeneralSubtrees(), new GeneralSubtrees()) : object2;
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() merged constraints: " + String.valueOf(object));
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)((NameConstraintsExtension)object).get("permitted_subtrees");
        GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)((NameConstraintsExtension)object).get("excluded_subtrees");
        if (generalSubtrees != null) {
            generalSubtrees.reduce(generalSubtrees2);
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() reduced constraints: " + generalSubtrees);
        }
        if (!((NameConstraintsExtension)object).verify(generalNameInterface)) {
            throw new IOException("New certificate not allowed to sign certificate for target");
        }
        if (generalSubtrees == null) {
            return -1;
        }
        int n3 = generalSubtrees.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            GeneralNameInterface generalNameInterface3 = generalSubtrees.get(i3).getName().getName();
            try {
                int n4 = Builder.distance(generalNameInterface3, generalNameInterface);
                if (n4 < 0) continue;
                return n4 + 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }
}

