/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal issuerDN;
    X509CertImpl cert;
    HashSet subjectNamesTraversed;
    int traversedCACerts;
    private boolean init = true;
    public CrlRevocationChecker crlChecker;
    ArrayList forwardCheckers;
    boolean keyParamsNeededFlag = false;

    ForwardState() {
    }

    public boolean isInitial() {
        return this.init;
    }

    public boolean keyParamsNeeded() {
        return this.keyParamsNeededFlag;
    }

    public Object clone() {
        try {
            ForwardState forwardState = (ForwardState)super.clone();
            forwardState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator listIterator = forwardState.forwardCheckers.listIterator();
            while (listIterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)listIterator.next();
                if (!(pKIXCertPathChecker instanceof Cloneable)) continue;
                listIterator.set(pKIXCertPathChecker.clone());
            }
            forwardState.subjectNamesTraversed = (HashSet)this.subjectNamesTraversed.clone();
            return forwardState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        block3: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("State [");
                stringBuffer.append("\n  issuerDN of last cert: " + this.issuerDN);
                stringBuffer.append("\n  traversedCACerts: " + this.traversedCACerts);
                stringBuffer.append("\n  init: " + String.valueOf(this.init));
                stringBuffer.append("\n  keyParamsNeeded: " + String.valueOf(this.keyParamsNeededFlag));
                stringBuffer.append("\n  subjectNamesTraversed: \n");
                Iterator iterator = this.subjectNamesTraversed.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                }
                stringBuffer.append("]\n");
            }
            catch (Exception exception) {
                if (debug == null) break block3;
                debug.println("ForwardState.toString() unexpected exception");
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public void updateState(X509Certificate x509Certificate) throws CertificateException, IOException, CertPathValidatorException {
        if (x509Certificate == null) {
            return;
        }
        X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        PublicKey publicKey = x509CertImpl.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            this.keyParamsNeededFlag = true;
        }
        this.cert = x509CertImpl;
        this.issuerDN = x509Certificate.getIssuerX500Principal();
        if (!X509CertImpl.isSelfIssued(x509Certificate) && !this.init && x509Certificate.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        if (this.init || !X509CertImpl.isSelfIssued(x509Certificate)) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            this.subjectNamesTraversed.add(X500Name.asX500Name(x500Principal));
            try {
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = x509CertImpl.getSubjectAlternativeNameExtension();
                if (subjectAlternativeNameExtension != null) {
                    GeneralNames generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                    Iterator iterator = generalNames.iterator();
                    while (iterator.hasNext()) {
                        GeneralNameInterface generalNameInterface = ((GeneralName)iterator.next()).getName();
                        this.subjectNamesTraversed.add(generalNameInterface);
                    }
                }
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("ForwardState.updateState() unexpected exception");
                    exception.printStackTrace();
                }
                throw new CertPathValidatorException(exception);
            }
        }
        this.init = false;
    }

    public void initState(List list) throws CertPathValidatorException {
        this.subjectNamesTraversed = new HashSet();
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
                if (!pKIXCertPathChecker.isForwardCheckingSupported()) continue;
                pKIXCertPathChecker.init(true);
                this.forwardCheckers.add(pKIXCertPathChecker);
            }
        }
        this.init = true;
    }
}

